/*
 * Decompiled with CFR 0.152.
 */
package javalx.benchmark;

import java.io.PrintStream;
import java.util.List;
import javalx.data.products.P2;
import javalx.fn.Effect;
import javalx.fn.Fn;
import javalx.fn.Fn2;

public class Benchmark<A> {
    private int DEFAULT_WARMUP_RUNS = 10;
    private final String name;
    private final Fn<A, Long> runtimeObserver;
    private final Fn2<Effect<A>, A, Long> observer = new Fn2<Effect<A>, A, Long>(){

        @Override
        public Long apply(Effect<A> effect, A parameter) {
            long start = System.nanoTime();
            effect.observe(parameter);
            long finished = System.nanoTime();
            return (finished - start) / 1000000L;
        }
    };

    public Benchmark(Effect<A> effect) {
        this("Unnamed Benchmark", effect);
    }

    public Benchmark(String name, Effect<A> effect) {
        this.name = name;
        this.runtimeObserver = this.curriedApply(effect);
    }

    private Fn<A, Long> curriedApply(Effect<A> effect) {
        return this.observer.curry().apply(effect);
    }

    private Fn<List<Long>, P2<List<Long>, List<Long>>> curriedApply2(A parameter, Fn2<A, List<Long>, P2<List<Long>, List<Long>>> benchmark) {
        return benchmark.curry().apply(parameter);
    }

    private Fn<A, List<Long>> warmUp() {
        return this.runtimeObserver.times(this.DEFAULT_WARMUP_RUNS).andThen(Benchmark.gc());
    }

    private static Fn<List<Long>, List<Long>> gc() {
        return new Fn<List<Long>, List<Long>>(){

            @Override
            public List<Long> apply(List<Long> warmUpTimes) {
                System.gc();
                return warmUpTimes;
            }
        };
    }

    private Fn2<A, List<Long>, P2<List<Long>, List<Long>>> benchmark(final int times) {
        return new Fn2<A, List<Long>, P2<List<Long>, List<Long>>>(){

            @Override
            public P2<List<Long>, List<Long>> apply(A parameter, List<Long> warmUpTimes) {
                List runTimes = Benchmark.this.runtimeObserver.times(times).apply(parameter);
                return P2.tuple2(warmUpTimes, runTimes);
            }
        };
    }

    private P2<List<Long>, List<Long>> benchmark(int times, A parameter) {
        Fn2<A, List<Long>, P2<List<Long>, List<Long>>> benchmark = this.benchmark(times);
        Fn<List<Long>, P2<List<Long>, List<Long>>> applied = this.curriedApply2(parameter, benchmark);
        return this.warmUp().andThen(applied).apply(parameter);
    }

    public Fn<A, P2<List<Long>, List<Long>>> run(final int times, int timesWarmup) {
        this.DEFAULT_WARMUP_RUNS = timesWarmup;
        return new Fn<A, P2<List<Long>, List<Long>>>(){

            @Override
            public P2<List<Long>, List<Long>> apply(A parameter) {
                return Benchmark.this.benchmark(times, parameter);
            }
        };
    }

    public Fn<A, P2<List<Long>, List<Long>>> run(final int times) {
        return new Fn<A, P2<List<Long>, List<Long>>>(){

            @Override
            public P2<List<Long>, List<Long>> apply(A parameter) {
                return Benchmark.this.benchmark(times, parameter);
            }
        };
    }

    public Fn<P2<List<Long>, List<Long>>, P2<List<Long>, List<Long>>> showResultsTo(final PrintStream out) {
        return new Fn<P2<List<Long>, List<Long>>, P2<List<Long>, List<Long>>>(){

            @Override
            public P2<List<Long>, List<Long>> apply(P2<List<Long>, List<Long>> warmUpAndRuntimes) {
                String msgTemplate = "[%s] [%8d] %s: %5d ms";
                List<Long> warmUpTimes = warmUpAndRuntimes._1();
                long total = 0L;
                for (int i = 0; i < warmUpTimes.size(); ++i) {
                    String msg = String.format("[%s] [%8d] %s: %5d ms", "WW", i + 1, Benchmark.this.name, warmUpTimes.get(i));
                    out.println(msg);
                    total += warmUpTimes.get(i).longValue();
                }
                out.println(String.format("[%s] Total: %6d Mean: %5d", "WW", total, total / (long)warmUpTimes.size()));
                total = 0L;
                List<Long> runTimes = warmUpAndRuntimes._2();
                for (int i = 0; i < runTimes.size(); ++i) {
                    String msg = String.format("[%s] [%8d] %s: %5d ms", "BB", i + 1, Benchmark.this.name, runTimes.get(i));
                    out.println(msg);
                    total += runTimes.get(i).longValue();
                }
                out.println(String.format("[%s] Total: %6d Mean: %5d", "BB", total, total / (long)runTimes.size()));
                return warmUpAndRuntimes;
            }
        };
    }
}

