/*
 * Decompiled with CFR 0.152.
 */
package gmp;

import gmp.Mpfr;
import gmp.Mpq;
import gmp.Mpz;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;

public class Test {
    public static Object testSerialize(Object object) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Object object2 = objectInputStream.readObject();
            objectInputStream.close();
            return object2;
        }
        catch (Exception exception) {
            System.out.println("caught exception " + exception);
            return null;
        }
    }

    public static void main(String[] stringArray) throws CloneNotSupportedException {
        System.out.println("Mpz test");
        System.out.println("========");
        System.out.println("2 -> " + new Mpz(2));
        System.out.println("2.3 -> " + new Mpz(2.3));
        System.out.println("-2.3 -> " + new Mpz(-2.3));
        BigInteger bigInteger = BigInteger.valueOf(99L);
        for (int i = 0; i < 4; ++i) {
            bigInteger = bigInteger.multiply(bigInteger);
        }
        System.out.println(bigInteger + " -> " + new Mpz(bigInteger));
        System.out.println(bigInteger.negate() + " -> " + new Mpz(bigInteger.negate()));
        System.out.println("98765 -> " + new Mpz("98765"));
        System.out.println("-98765 -> " + new Mpz("-98765", 10));
        System.out.println("3735928559 -> " + new Mpz("deadbeef", 16));
        Mpz mpz = new Mpz(2);
        mpz.set(1);
        System.out.println("1-> " + mpz);
        mpz.set(-0.5);
        System.out.println("-0.5 -> " + mpz);
        mpz.fib(128);
        Mpz mpz2 = (Mpz)Test.testSerialize(mpz);
        System.out.println(mpz + " -> " + mpz2);
        assert (mpz.equals(mpz2)) : "Mpz serialization failed";
        assert (mpz.clone().equals(mpz));
        System.out.println("");
        System.out.println("Mpq test");
        System.out.println("========");
        System.out.println("1/2 -> " + new Mpq(1, 2));
        Mpq mpq = new Mpq(12, 99);
        System.out.println(mpq + " = " + mpq.getNum() + " / " + mpq.getDen());
        mpq.numRef().add(2);
        System.out.println(mpq);
        mpq.denRef().sub(2);
        System.out.println(mpq);
        mpq.set(99, 132);
        Mpq mpq2 = (Mpq)Test.testSerialize(mpq);
        System.out.println(mpq + " -> " + mpq2);
        assert (mpq.equals(mpq2)) : "Mpq serialization failed";
        assert (mpq.clone().equals(mpq));
        System.out.println("");
        System.out.println("Mpfr test");
        System.out.println("=========");
        System.out.println("version: " + Mpfr.getVersion());
        System.out.println("patches: " + Mpfr.getPatches());
        Mpfr mpfr = new Mpfr(1024);
        mpfr.constPi(0);
        System.out.println("pi " + mpfr);
        System.out.println("pi " + mpfr.toString(10, 10, 0));
        System.out.println("pi " + mpfr.toString(16, 5, 0));
        Mpfr mpfr2 = (Mpfr)Test.testSerialize(mpfr);
        System.out.println(mpfr + " -> " + mpfr2);
        assert (mpfr.equals(mpfr2)) : "Mpfr serialization failed";
        assert (mpfr.clone().equals(mpfr));
    }
}

