/*
 * Decompiled with CFR 0.152.
 */
package gmp;

import gmp.RandState;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigInteger;

public class Mpz
implements Serializable,
Comparable<Mpz>,
Cloneable {
    private long ptr;
    public static final int infinite = -1;

    private native void init();

    private native void init_set(Mpz var1);

    private native void init_set(int var1);

    private native void init_set(double var1);

    private native void init_set(String var1, int var2);

    public native void set(int var1, byte[] var2);

    public native byte[] byteArrayValue();

    protected native void finalize();

    private static native void class_init();

    public Mpz() {
        this.init();
    }

    public Mpz(Mpz mpz) {
        this.init_set(mpz);
    }

    public Mpz(int n) {
        this.init_set(n);
    }

    public Mpz(double d) {
        this.init_set(d);
    }

    public Mpz(BigInteger bigInteger) {
        this.init();
        this.set(bigInteger.signum(), bigInteger.abs().toByteArray());
    }

    public Mpz(String string, int n) {
        this.init_set(string, n);
    }

    public Mpz(String string) {
        this.init_set(string, 0);
    }

    public Mpz(int n, byte[] byArray) {
        this.init();
        this.set(n, byArray);
    }

    public Mpz clone() throws CloneNotSupportedException {
        return new Mpz(this);
    }

    public native void set(Mpz var1);

    public native void set(int var1);

    public native void set(double var1);

    public void set(BigInteger bigInteger) {
        this.set(bigInteger.signum(), bigInteger.abs().toByteArray());
    }

    public native void set(String var1, int var2);

    public void set(String string) {
        this.set(string, 0);
    }

    public native int intValue();

    public native double doubleValue();

    public native double doubleExponentValue(int[] var1);

    public BigInteger bigIntegerValue() {
        return new BigInteger(this.sgn(), this.byteArrayValue());
    }

    public native String toString(int var1);

    public String toString() {
        return this.toString(10);
    }

    public native void add(Mpz var1, Mpz var2);

    public native void add(Mpz var1, int var2);

    public void add(Mpz mpz) {
        this.add(this, mpz);
    }

    public void add(int n) {
        this.add(this, n);
    }

    public native void sub(Mpz var1, Mpz var2);

    public native void sub(Mpz var1, int var2);

    public native void sub(int var1, Mpz var2);

    public void sub(Mpz mpz) {
        this.sub(this, mpz);
    }

    public void sub(int n) {
        this.sub(this, n);
    }

    public void subRev(int n) {
        this.sub(n, this);
    }

    public native void mul(Mpz var1, Mpz var2);

    public native void mul(Mpz var1, int var2);

    public void mul(Mpz mpz) {
        this.mul(this, mpz);
    }

    public void mul(int n) {
        this.mul(this, n);
    }

    public native void addMul(Mpz var1, Mpz var2);

    public native void addMul(Mpz var1, int var2);

    public native void subMul(Mpz var1, Mpz var2);

    public native void subMul(Mpz var1, int var2);

    public native void mul2exp(Mpz var1, int var2);

    public void mul2exp(int n) {
        this.mul2exp(this, n);
    }

    public native void neg(Mpz var1);

    public void neg() {
        this.neg(this);
    }

    public native void abs(Mpz var1);

    public void abs() {
        this.abs(this);
    }

    public native void cdivQ(Mpz var1, Mpz var2) throws ArithmeticException;

    public void cdivQ(Mpz mpz) throws ArithmeticException {
        this.cdivQ(this, mpz);
    }

    public native void cdivR(Mpz var1, Mpz var2) throws ArithmeticException;

    public native void cdivQR(Mpz var1, Mpz var2, Mpz var3) throws ArithmeticException;

    public native int cdivQ(Mpz var1, int var2) throws ArithmeticException;

    public int cdivQ(int n) throws ArithmeticException {
        return this.cdivQ(this, n);
    }

    public native int cdivR(Mpz var1, int var2) throws ArithmeticException;

    public native int cdivQR(Mpz var1, Mpz var2, int var3) throws ArithmeticException;

    public native int cdivR(int var1) throws ArithmeticException;

    public native void cdivQ2exp(Mpz var1, int var2) throws ArithmeticException;

    public native void cdivR2exp(Mpz var1, int var2) throws ArithmeticException;

    public native void fdivQ(Mpz var1, Mpz var2) throws ArithmeticException;

    public void fdivQ(Mpz mpz) throws ArithmeticException {
        this.fdivQ(this, mpz);
    }

    public native void fdivR(Mpz var1, Mpz var2) throws ArithmeticException;

    public native void fdivQR(Mpz var1, Mpz var2, Mpz var3) throws ArithmeticException;

    public native int fdivQ(Mpz var1, int var2) throws ArithmeticException;

    public int fdivQ(int n) throws ArithmeticException {
        return this.fdivQ(this, n);
    }

    public native int fdivR(Mpz var1, int var2) throws ArithmeticException;

    public native int fdivQR(Mpz var1, Mpz var2, int var3) throws ArithmeticException;

    public native int fdivR(int var1) throws ArithmeticException;

    public native void fdivQ2exp(Mpz var1, int var2) throws ArithmeticException;

    public native void fdivR2exp(Mpz var1, int var2) throws ArithmeticException;

    public native void tdivQ(Mpz var1, Mpz var2) throws ArithmeticException;

    public void tdivQ(Mpz mpz) throws ArithmeticException {
        this.tdivQ(this, mpz);
    }

    public native void tdivR(Mpz var1, Mpz var2) throws ArithmeticException;

    public native void tdivQR(Mpz var1, Mpz var2, Mpz var3) throws ArithmeticException;

    public native int tdivQ(Mpz var1, int var2) throws ArithmeticException;

    public int tdivQ(int n) throws ArithmeticException {
        return this.tdivQ(this, n);
    }

    public native int tdivR(Mpz var1, int var2) throws ArithmeticException;

    public native int tdivQR(Mpz var1, Mpz var2, int var3) throws ArithmeticException;

    public native int tdivR(int var1) throws ArithmeticException;

    public native void tdivQ2exp(Mpz var1, int var2) throws ArithmeticException;

    public native void tdivR2exp(Mpz var1, int var2) throws ArithmeticException;

    public native void mod(Mpz var1, Mpz var2) throws ArithmeticException;

    public void mod(Mpz mpz) throws ArithmeticException {
        this.mod(this, mpz);
    }

    public native int mod(Mpz var1, int var2) throws ArithmeticException;

    public int mod(int n) throws ArithmeticException {
        return this.mod(this, n);
    }

    public native void divExact(Mpz var1, Mpz var2) throws ArithmeticException;

    public void divExact(Mpz mpz) throws ArithmeticException {
        this.divExact(this, mpz);
    }

    public native void divExact(Mpz var1, int var2) throws ArithmeticException;

    public void divExact(int n) throws ArithmeticException {
        this.divExact(this, n);
    }

    public native boolean isDivisible(Mpz var1);

    public native boolean isDivisible(int var1);

    public native boolean isDivisible2exp(int var1);

    public native boolean isCongruent(Mpz var1, Mpz var2);

    public native boolean isCongruent(int var1, int var2);

    public native boolean isCongruent2exp(Mpz var1, int var2);

    public native void pow(Mpz var1, Mpz var2, Mpz var3) throws ArithmeticException;

    public native void pow(Mpz var1, int var2, Mpz var3) throws ArithmeticException;

    public native void pow(Mpz var1, int var2);

    public void pow(int n) {
        this.pow(this, n);
    }

    public native void pow(int var1, int var2);

    public native boolean root(Mpz var1, int var2);

    public boolean root(int n) {
        return this.root(this, n);
    }

    public native void root(Mpz var1, Mpz var2, int var3);

    public native void sqrt(Mpz var1);

    public void sqrt() {
        this.sqrt(this);
    }

    public native void sqrt(Mpz var1, Mpz var2);

    public native boolean isPerfectPower();

    public native boolean isPerfectSquare();

    public native int isProbabPrime(int var1);

    public native void nextPrime(Mpz var1);

    public native void gcd(Mpz var1, Mpz var2);

    public native int gcd(Mpz var1, int var2);

    public native void gcd(Mpz var1, Mpz var2, Mpz var3, Mpz var4);

    public native void lcm(Mpz var1, Mpz var2);

    public native void lcm(Mpz var1, int var2);

    public native boolean invert(Mpz var1, Mpz var2);

    public static native int jacobi(Mpz var0, Mpz var1);

    public static native int legendre(Mpz var0, Mpz var1);

    public static native int kronecker(Mpz var0, Mpz var1);

    public static native int kronecker(Mpz var0, int var1);

    public static native int kronecker(int var0, Mpz var1);

    public native int remove(Mpz var1, Mpz var2);

    public int remove(Mpz mpz) {
        return this.remove(this, mpz);
    }

    public native void fac(int var1);

    public native void bin(Mpz var1, int var2);

    public native void bin(int var1, int var2);

    public native void fib(int var1);

    public native void fib(Mpz var1, int var2);

    public native void lucnum(int var1);

    public native void lucnum(Mpz var1, int var2);

    public native int cmp(Mpz var1);

    public native int cmp(int var1);

    public native int cmp(double var1);

    public native int cmpAbs(Mpz var1);

    public native int cmpAbs(int var1);

    public native int cmpAbs(double var1);

    public native int sgn();

    public boolean isEqual(Mpz mpz) {
        return this.cmp(mpz) == 0;
    }

    public boolean equals(Object object) {
        return object instanceof Mpz && this.cmp((Mpz)object) == 0;
    }

    @Override
    public int compareTo(Mpz mpz) {
        return this.cmp(mpz);
    }

    public native int hashCode();

    public boolean isPhysicalEqual(Mpz mpz) {
        return this.ptr == mpz.ptr;
    }

    public native void and(Mpz var1, Mpz var2);

    public void and(Mpz mpz) {
        this.and(this, mpz);
    }

    public native void or(Mpz var1, Mpz var2);

    public void or(Mpz mpz) {
        this.or(this, mpz);
    }

    public native void xor(Mpz var1, Mpz var2);

    public void xor(Mpz mpz) {
        this.xor(this, mpz);
    }

    public native void not(Mpz var1);

    public void not() {
        this.not(this);
    }

    public native int popCount();

    public native int hamDist(Mpz var1);

    public native int scan0(int var1);

    public native int scan1(int var1);

    public native void setBit(int var1);

    public native void clrBit(int var1);

    public native void notBit(int var1);

    public native boolean tstBit(int var1);

    public native boolean fitsInt();

    public native boolean isOdd();

    public native boolean isEven();

    public native int sizeInBase(int var1);

    public native int size();

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        byte[] byArray = this.byteArrayValue();
        objectOutputStream.writeInt(byArray.length);
        objectOutputStream.writeByte(this.sgn());
        objectOutputStream.write(byArray);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        byte by = objectInputStream.readByte();
        byte[] byArray = new byte[n];
        objectInputStream.readFully(byArray);
        this.init();
        this.set(by, byArray);
    }

    private void readObjectNoData() throws ObjectStreamException {
        this.init_set(0);
    }

    public native void randomBits(RandState var1, int var2);

    public native void random(RandState var1, Mpz var2);

    public native void rRandomBits(RandState var1, int var2);

    static {
        System.loadLibrary("jgmp");
        Mpz.class_init();
    }
}

