/*
 * Decompiled with CFR 0.152.
 */
package gmp;

import gmp.Mpq;
import gmp.Mpz;
import gmp.RandState;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigInteger;

public class Mpfr
implements Serializable,
Comparable<Mpfr>,
Cloneable {
    private long ptr;
    public static final int RNDN = 0;
    public static final int RNDZ = 1;
    public static final int RNDU = 2;
    public static final int RNDD = 3;

    private native void init();

    private native void init(int var1);

    private native void init_set(Mpfr var1, int var2);

    private native void init_set(int var1, int var2);

    private native void init_set(Mpz var1, int var2);

    private native void init_set(double var1, int var3);

    private native void init_set(Mpq var1, int var2);

    private native void init_set(String var1, int var2, int var3);

    protected native void finalize();

    private static native void class_init();

    public Mpfr() {
        this.init();
    }

    public Mpfr(int n) {
        this.init(n);
    }

    public Mpfr(Mpfr mpfr) {
        this.init(mpfr.getPrec());
        this.set(mpfr, 0);
    }

    public Mpfr(Mpfr mpfr, int n) {
        this.init_set(mpfr, n);
    }

    public Mpfr(int n, int n2) {
        this.init_set(n, n2);
    }

    public Mpfr(BigInteger bigInteger, int n) {
        this.init_set(new Mpz(bigInteger), n);
    }

    public Mpfr(Mpz mpz, int n) {
        this.init_set(mpz, n);
    }

    public Mpfr(double d, int n) {
        this.init_set(d, n);
    }

    public Mpfr(Mpq mpq, int n) {
        this.init_set(mpq, n);
    }

    public Mpfr(String string, int n, int n2) {
        this.init_set(string, n, n2);
    }

    public Mpfr(String string, int n) {
        this.init_set(string, 10, n);
    }

    public Mpfr clone() throws CloneNotSupportedException {
        return new Mpfr(this);
    }

    public static native void setDefaultPrec(int var0);

    public static native int getDefaultPrec();

    public native void setPrec(int var1);

    public native int getPrec();

    public native int set(Mpfr var1, int var2);

    public void set(Mpfr mpfr) {
        if (this.ptr != mpfr.ptr) {
            this.setPrec(mpfr.getPrec());
        }
        this.set(mpfr, 0);
    }

    public native int set(int var1, int var2);

    public native int set(int var1, int var2, int var3);

    public int set(BigInteger bigInteger, int n) {
        return this.set(new Mpz(bigInteger), n);
    }

    public native int set(Mpz var1, int var2);

    public native int set(double var1, int var3);

    public native int set(Mpq var1, int var2);

    public native void set(String var1, int var2, int var3);

    public void set(String string, int n) {
        this.set(string, 10, n);
    }

    public native void setInf(int var1);

    public native void setNaN();

    public native int intValue(int var1);

    public native double doubleValue(int var1);

    public native double doubleExponentValue(int[] var1, int var2);

    public native Mpz MpzValue(int var1);

    public native int MpzExponentValue(Mpz var1);

    public native String toString(int var1, int var2, int var3);

    public String toString() {
        return this.toString(10, 0, 0);
    }

    public native boolean fitsInt(int var1);

    public native int add(Mpfr var1, Mpfr var2, int var3);

    public native int add(Mpfr var1, int var2, int var3);

    public native int add(Mpfr var1, double var2, int var4);

    public native int add(Mpfr var1, Mpz var2, int var3);

    public native int add(Mpfr var1, Mpq var2, int var3);

    public int add(Mpfr mpfr, int n) {
        return this.add(this, mpfr, n);
    }

    public int add(int n, int n2) {
        return this.add(this, n, n2);
    }

    public int add(double d, int n) {
        return this.add(this, d, n);
    }

    public int add(Mpz mpz, int n) {
        return this.add(this, mpz, n);
    }

    public int add(Mpq mpq, int n) {
        return this.add(this, mpq, n);
    }

    public native int sub(Mpfr var1, Mpfr var2, int var3);

    public native int sub(Mpfr var1, int var2, int var3);

    public native int sub(Mpfr var1, double var2, int var4);

    public native int sub(Mpfr var1, Mpz var2, int var3);

    public native int sub(Mpfr var1, Mpq var2, int var3);

    public native int sub(int var1, Mpfr var2, int var3);

    public native int sub(double var1, Mpfr var3, int var4);

    public int sub(Mpfr mpfr, int n) {
        return this.sub(this, mpfr, n);
    }

    public int sub(int n, int n2) {
        return this.sub(this, n, n2);
    }

    public int sub(double d, int n) {
        return this.sub(this, d, n);
    }

    public int sub(Mpz mpz, int n) {
        return this.sub(this, mpz, n);
    }

    public int sub(Mpq mpq, int n) {
        return this.sub(this, mpq, n);
    }

    public int subRev(int n, int n2) {
        return this.sub(n, this, n2);
    }

    public int subRev(double d, int n) {
        return this.sub(d, this, n);
    }

    public native int mul(Mpfr var1, Mpfr var2, int var3);

    public native int mul(Mpfr var1, int var2, int var3);

    public native int mul(Mpfr var1, double var2, int var4);

    public native int mul(Mpfr var1, Mpz var2, int var3);

    public native int mul(Mpfr var1, Mpq var2, int var3);

    public int mul(Mpfr mpfr, int n) {
        return this.mul(this, mpfr, n);
    }

    public int mul(int n, int n2) {
        return this.mul(this, n, n2);
    }

    public int mul(double d, int n) {
        return this.mul(this, d, n);
    }

    public int mul(Mpz mpz, int n) {
        return this.mul(this, mpz, n);
    }

    public int mul(Mpq mpq, int n) {
        return this.mul(this, mpq, n);
    }

    public native int div(Mpfr var1, Mpfr var2, int var3);

    public native int div(Mpfr var1, int var2, int var3);

    public native int div(Mpfr var1, double var2, int var4);

    public native int div(Mpfr var1, Mpz var2, int var3);

    public native int div(Mpfr var1, Mpq var2, int var3);

    public native int div(int var1, Mpfr var2, int var3);

    public native int div(double var1, Mpfr var3, int var4);

    public int div(Mpfr mpfr, int n) {
        return this.div(this, mpfr, n);
    }

    public int div(int n, int n2) {
        return this.div(this, n, n2);
    }

    public int div(double d, int n) {
        return this.div(this, d, n);
    }

    public int div(Mpz mpz, int n) {
        return this.div(this, mpz, n);
    }

    public int div(Mpq mpq, int n) {
        return this.div(this, mpq, n);
    }

    public int divRev(int n, int n2) {
        return this.div(n, this, n2);
    }

    public int divRev(double d, int n) {
        return this.div(d, this, n);
    }

    public native int sqrt(Mpfr var1, int var2);

    public int sqrt(int n) {
        return this.sqrt(this, n);
    }

    public native int sqrt(int var1, int var2);

    public native int recSqrt(Mpfr var1, int var2);

    public int recSqrt(int n) {
        return this.recSqrt(this, n);
    }

    public native int cbrt(Mpfr var1, int var2);

    public int cbrt(int n) {
        return this.cbrt(this, n);
    }

    public native int root(Mpfr var1, int var2, int var3);

    public int root(int n, int n2) {
        return this.root(this, n, n2);
    }

    public native int pow(Mpfr var1, Mpfr var2, int var3);

    public native int pow(Mpfr var1, int var2, int var3);

    public native int pow(Mpfr var1, Mpz var2, int var3);

    public native int neg(Mpfr var1, int var2);

    public int neg(int n) {
        return this.neg(this, n);
    }

    public native int abs(Mpfr var1, int var2);

    public int abs(int n) {
        return this.abs(this, n);
    }

    public native int dim(Mpfr var1, Mpfr var2, int var3);

    public native int mul2exp(Mpfr var1, int var2, int var3);

    public int mul2exp(int n, int n2) {
        return this.mul2exp(this, n, n2);
    }

    public native int div2exp(Mpfr var1, int var2, int var3);

    public int div2exp(int n, int n2) {
        return this.div2exp(this, n, n2);
    }

    public native int cmp(Mpfr var1);

    public native int cmp(int var1);

    public native int cmp(double var1);

    public native int cmp(Mpz var1);

    public native int cmp(Mpq var1);

    public native int cmp2exp(int var1, int var2);

    public native int cmpAbs(Mpfr var1);

    public native boolean isNaN();

    public native boolean isInf();

    public native boolean isNumber();

    public native boolean isZero();

    public native int sgn();

    public native boolean isGreater(Mpfr var1);

    public native boolean isGreaterEqual(Mpfr var1);

    public native boolean isLess(Mpfr var1);

    public native boolean isLessEqual(Mpfr var1);

    public native boolean isLessGreater(Mpfr var1);

    public native boolean isEqual(Mpfr var1);

    public native boolean isUnordered(Mpfr var1);

    public boolean equals(Object object) {
        if (object instanceof Mpfr) {
            Mpfr mpfr = (Mpfr)object;
            return this.isEqual(mpfr) || this.isNaN() && mpfr.isNaN();
        }
        return false;
    }

    @Override
    public int compareTo(Mpfr mpfr) {
        if (this.isNaN()) {
            if (mpfr.isNaN()) {
                return 0;
            }
            return 1;
        }
        if (mpfr.isNaN()) {
            return -1;
        }
        return this.cmp(mpfr);
    }

    public native int hashCode();

    public boolean isPhysicalEqual(Mpfr mpfr) {
        return this.ptr == mpfr.ptr;
    }

    public native int log(Mpfr var1, int var2);

    public native int log2(Mpfr var1, int var2);

    public native int log10(Mpfr var1, int var2);

    public native int exp(Mpfr var1, int var2);

    public native int exp2(Mpfr var1, int var2);

    public native int exp10(Mpfr var1, int var2);

    public native int cos(Mpfr var1, int var2);

    public native int sin(Mpfr var1, int var2);

    public native int tan(Mpfr var1, int var2);

    public native int sec(Mpfr var1, int var2);

    public native int csc(Mpfr var1, int var2);

    public native int cot(Mpfr var1, int var2);

    public native int sinCos(Mpfr var1, Mpfr var2, int var3);

    public native int acos(Mpfr var1, int var2);

    public native int asin(Mpfr var1, int var2);

    public native int atan(Mpfr var1, int var2);

    public native int atan2(Mpfr var1, Mpfr var2, int var3);

    public native int cosh(Mpfr var1, int var2);

    public native int sinh(Mpfr var1, int var2);

    public native int sinhCosh(Mpfr var1, Mpfr var2, int var3);

    public native int sech(Mpfr var1, int var2);

    public native int csch(Mpfr var1, int var2);

    public native int coth(Mpfr var1, int var2);

    public native int acosh(Mpfr var1, int var2);

    public native int asinh(Mpfr var1, int var2);

    public native int atanh(Mpfr var1, int var2);

    public native int fac(int var1, int var2);

    public native int log1p(Mpfr var1, int var2);

    public native int expm1(Mpfr var1, int var2);

    public native int eint(Mpfr var1, int var2);

    public native int li2(Mpfr var1, int var2);

    public native int gamma(Mpfr var1, int var2);

    public native int lngamma(Mpfr var1, int var2);

    public native int lgamma(int[] var1, Mpfr var2, int var3);

    public native int zeta(Mpfr var1, int var2);

    public native int zeta(int var1, int var2);

    public native int erf(Mpfr var1, int var2);

    public native int erfc(Mpfr var1, int var2);

    public native int j0(Mpfr var1, int var2);

    public native int j1(Mpfr var1, int var2);

    public native int jn(int var1, Mpfr var2, int var3);

    public native int y0(Mpfr var1, int var2);

    public native int y1(Mpfr var1, int var2);

    public native int yn(int var1, Mpfr var2, int var3);

    public native int fma(Mpfr var1, Mpfr var2, Mpfr var3, int var4);

    public native int fms(Mpfr var1, Mpfr var2, Mpfr var3, int var4);

    public native int agm(Mpfr var1, Mpfr var2, int var3);

    public native int hypot(Mpfr var1, Mpfr var2, int var3);

    public native int constLog2(int var1);

    public native int constPi(int var1);

    public native int constEuler(int var1);

    public native int constCatalan(int var1);

    public static native void freeCache();

    public native int sum(Mpfr[] var1, int var2);

    public native int rint(Mpfr var1, int var2);

    public native int ceil(Mpfr var1);

    public native int floor(Mpfr var1);

    public native int round(Mpfr var1);

    public native int trunc(Mpfr var1);

    public native int rint_ceil(Mpfr var1, int var2);

    public native int rint_floor(Mpfr var1, int var2);

    public native int rint_round(Mpfr var1, int var2);

    public native int rint_trunc(Mpfr var1, int var2);

    public native int frac(Mpfr var1, int var2);

    public native int modf(Mpfr var1, Mpfr var2, int var3);

    public native int fmod(Mpfr var1, Mpfr var2, int var3);

    public native int remainder(Mpfr var1, Mpfr var2, int var3);

    public native int remquo(int[] var1, Mpfr var2, Mpfr var3, int var4);

    public native boolean isInteger();

    public native int precRound(int var1, int var2);

    public native boolean canRound(int var1, int var2, int var3, int var4);

    public static native String toStringRndMode(int var0);

    public native void nextToward(Mpfr var1);

    public native void nextAbove();

    public native void nextBelow();

    public native int min(Mpfr var1, Mpfr var2, int var3);

    public native int max(Mpfr var1, Mpfr var2, int var3);

    public native int getExp();

    public native boolean setExp(int var1);

    public native boolean signBit();

    public native int setSign(Mpfr var1, boolean var2, int var3);

    public native int copySign(Mpfr var1, Mpfr var2, int var3);

    public static native String getVersion();

    public static native String getPatches();

    public static native long getEmin();

    public static native long getEmax();

    public static native boolean setEmin(long var0);

    public static native boolean setEmax(long var0);

    public static native long getEminMin();

    public static native long getEminMax();

    public static native long getEmaxMin();

    public static native long getEmaxMax();

    public native int checkRange(int var1, int var2);

    public native int subNormalize(int var1, int var2);

    public static native void clearUnderflow();

    public static native void clearOverflow();

    public static native void clearNaNFlag();

    public static native void clearInexFlag();

    public static native void clearERangeFlag();

    public static native void setUnderflow();

    public static native void setOverflow();

    public static native void setNaNFlag();

    public static native void setInexFlag();

    public static native void setERangeFlag();

    public static native boolean isUnderflow();

    public static native boolean isOverflow();

    public static native boolean isNaNFlag();

    public static native boolean isInexFlag();

    public static native boolean isERangeFlag();

    public native int random(RandState var1);

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.getPrec());
        objectOutputStream.writeObject(this.toString(16, 0, 0));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.init(objectInputStream.readInt());
        this.set((String)objectInputStream.readObject(), 16, 0);
    }

    private void readObjectNoData() throws ObjectStreamException {
        this.init();
    }

    static {
        System.loadLibrary("jgmp");
        Mpfr.class_init();
    }
}

