/*
 * Decompiled with CFR 0.152.
 */
package gdsl.asm;

import gdsl.asm.Visitor;
import gdsl.asm.annotation.Annotation;
import gdsl.asm.operand.Operand;

public class Instruction {
    private long length;
    private String mnemonic;
    private Annotation[] annotations;
    private Operand[] operands;

    public long getLength() {
        return this.length;
    }

    public String getMnemonic() {
        return this.mnemonic;
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public Operand[] getOperands() {
        return this.operands;
    }

    public Instruction(long l, String string, Annotation[] annotationArray, Operand[] operandArray) {
        this.length = l;
        this.mnemonic = string;
        this.annotations = annotationArray;
        this.operands = operandArray;
    }

    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder(this.mnemonic);
        if (this.annotations.length > 0) {
            stringBuilder.append(" [");
            for (n = 0; n < this.annotations.length; ++n) {
                if (n > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.annotations[n]);
            }
            stringBuilder.append("]");
        }
        for (n = 0; n < this.operands.length; ++n) {
            stringBuilder.append(" ");
            stringBuilder.append(this.operands[n]);
        }
        return stringBuilder.toString();
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

