/*
 * Decompiled with CFR 0.152.
 */
package binparse.rreil;

import binparse.AbstractBinary;
import binparse.BinaryFileFormat;
import binparse.BinaryType;
import binparse.Endianness;
import binparse.Permission;
import binparse.SegmentImpl;
import binparse.Symbol;
import binparse.rreil.RReilSymbol;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Scanner;
import java.util.Set;
import java.util.SortedMap;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.numeric.FiniteRange;
import rreil.assembler.CompiledAssembler;
import rreil.lang.RReil;
import rreil.lang.RReilAddr;

public class RReilBinary
extends AbstractBinary {
    public static final String rreilArch = "rreil-vm";
    private static final String no_file_backing = "<rreil-assembler-text>";
    private final File sourceFile;
    private final CompiledAssembler compilationUnit;

    public RReilBinary(CompiledAssembler compilationUnit) {
        this.compilationUnit = compilationUnit;
        this.sourceFile = null;
    }

    public RReilBinary(String fileName) throws FileNotFoundException {
        this.sourceFile = new File(fileName);
        Scanner scanner = new Scanner(this.sourceFile);
        String fileContent = scanner.useDelimiter("\\A").next();
        scanner.close();
        this.compilationUnit = CompiledAssembler.from(fileContent);
    }

    public static RReilBinary fromString(String assemblerSourceCode) {
        return new RReilBinary(CompiledAssembler.from(assemblerSourceCode));
    }

    @Override
    public Option<File> getFile() {
        if (this.sourceFile != null) {
            return Option.some(this.sourceFile);
        }
        return Option.none();
    }

    @Override
    public String getFileName() {
        return this.sourceFile != null ? this.sourceFile.getName() : no_file_backing;
    }

    @Override
    public String getArchitectureName() {
        return rreilArch;
    }

    @Override
    public int getArchitectureSize() {
        return this.compilationUnit.getDefaultSize();
    }

    @Override
    public Endianness getEndianness() {
        return Endianness.LITTLE;
    }

    @Override
    public BinaryType getType() {
        return BinaryType.Executable;
    }

    @Override
    public BinaryFileFormat getFileFormat() {
        return BinaryFileFormat.RREIL;
    }

    @Override
    public long getEntryAddress() {
        RReilAddr entry = this.compilationUnit.entryAddress();
        assert (entry.offset() == 0) : "invalid compilation unit entry address";
        return entry.base();
    }

    @Override
    public boolean hasDebugInformation() {
        return false;
    }

    @Override
    public Option<Symbol> getMainFunction() {
        return this.getSymbol("main");
    }

    public String toString() {
        return this.sourceFile != null ? this.sourceFile.getPath() : no_file_backing;
    }

    @Override
    protected void initSegments() {
        ArrayList<SegmentImpl> segments = new ArrayList<SegmentImpl>();
        String name = ".text";
        long firstAddress = this.compilationUnit.minInstructionAddress().base();
        long lastAddress = this.compilationUnit.maxInstructionAddress().base();
        assert (firstAddress <= lastAddress);
        long size = lastAddress - firstAddress + 1L;
        byte[] data = new byte[]{};
        Set<Permission> permissions = Permission.$ReadExecute;
        SegmentImpl segment = new SegmentImpl(this.getFileName(), name, firstAddress, size, data, this.getEndianness(), permissions);
        segments.add(segment);
        this.segmentNames.put(name, segment);
        this.segmentAddresses = this.segmentAddresses.bind(FiniteRange.of(firstAddress, lastAddress + 1L), segment);
        this.segments = segments;
    }

    @Override
    protected void initExportedSymbols() {
        ArrayList<RReilSymbol> symbols = new ArrayList<RReilSymbol>();
        for (P2<RReilAddr, String> p2 : this.compilationUnit.getLabels()) {
            String name = p2._2();
            long address = p2._1().base();
            RReilSymbol symbol = new RReilSymbol(name, address, this.getArchitectureSize());
            symbols.add(symbol);
            this.symbolNames.put(name, symbol);
            if (this.symbolAddresses.containsKey(address)) {
                throw new IllegalArgumentException("Two symbols have the same base address: " + address + ". Symbol names are " + ((Symbol)this.symbolAddresses.get(address)).getNameOrAddress() + " and " + symbol.getNameOrAddress());
            }
            this.symbolAddresses.put(address, symbol);
        }
        this.exportedSymbols = symbols;
    }

    @Override
    protected void initImportedSymbols() {
        this.importedSymbols = Collections.emptyList();
    }

    public SortedMap<RReilAddr, RReil> getInstructions() {
        return this.compilationUnit.getInstructions();
    }
}

