/*
 * Decompiled with CFR 0.152.
 */
package binparse;

import binparse.Binary;
import binparse.elf.ElfBinary;
import binparse.pe.PEBinary;
import binparse.rreil.RReilBinary;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javalx.exceptions.UnimplementedException;

public final class BinaryFileFormat
extends Enum<BinaryFileFormat> {
    public static final /* enum */ BinaryFileFormat ELF = new BinaryFileFormat();
    public static final /* enum */ BinaryFileFormat PE = new BinaryFileFormat();
    public static final /* enum */ BinaryFileFormat RREIL = new BinaryFileFormat();
    public static final /* enum */ BinaryFileFormat MACHO = new BinaryFileFormat();
    public static final /* enum */ BinaryFileFormat TRACE = new BinaryFileFormat();
    private static final /* synthetic */ BinaryFileFormat[] $VALUES;

    public static BinaryFileFormat[] values() {
        return (BinaryFileFormat[])$VALUES.clone();
    }

    public static BinaryFileFormat valueOf(String name) {
        return Enum.valueOf(BinaryFileFormat.class, name);
    }

    public static Binary getBinary(String fileName) throws IOException {
        BinaryFileFormat format = BinaryFileFormat.getFormatOf(fileName);
        switch (format) {
            case RREIL: {
                return new RReilBinary(fileName);
            }
            case ELF: {
                return new ElfBinary(fileName);
            }
            case PE: {
                return new PEBinary(fileName);
            }
            case MACHO: {
                throw new UnimplementedException("Support for Mach-O binaries not yet implemented.");
            }
            case TRACE: {
                throw new UnimplementedException("Support for traces not yet implemented.");
            }
        }
        assert (false);
        assert (false);
        return null;
    }

    public static BinaryFileFormat getFormatOf(String file) throws IOException {
        if (BinaryFileFormat.getFileExtension(file).equals("rreil")) {
            return RREIL;
        }
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));
        if (!((InputStream)stream).markSupported()) {
            ((InputStream)stream).close();
            return null;
        }
        ((InputStream)stream).mark(4);
        int c1 = ((InputStream)stream).read();
        int c2 = ((InputStream)stream).read();
        int c3 = ((InputStream)stream).read();
        int c4 = ((InputStream)stream).read();
        ((InputStream)stream).reset();
        ((InputStream)stream).close();
        if (c1 == 127 && c2 == 69 && c3 == 76 && c4 == 70) {
            return ELF;
        }
        if (c1 == 77 && c2 == 90) {
            return PE;
        }
        return null;
    }

    private static String getFileExtension(String file) {
        String separator = System.getProperty("file.separator");
        int lastSeparatorIndex = file.lastIndexOf(separator);
        String filename = lastSeparatorIndex == -1 ? file : file.substring(lastSeparatorIndex + 1);
        int extensionIndex = filename.lastIndexOf(".");
        if (extensionIndex == -1) {
            return filename;
        }
        return filename.substring(extensionIndex + 1);
    }

    static {
        $VALUES = new BinaryFileFormat[]{ELF, PE, RREIL, MACHO, TRACE};
    }
}

