/*
 * Decompiled with CFR 0.152.
 */
package bindis.x86.x32;

import bindis.x86.common.X86RegOpnd;

public class X32Registers {
    public static final int NUM_REGISTERS = 8;
    public static final X86RegOpnd EAX = new X86RegOpnd("eax", 32);
    public static final X86RegOpnd ECX = new X86RegOpnd("ecx", 32);
    public static final X86RegOpnd EDX = new X86RegOpnd("edx", 32);
    public static final X86RegOpnd EBX = new X86RegOpnd("ebx", 32);
    public static final X86RegOpnd ESP = new X86RegOpnd("esp", 32);
    public static final X86RegOpnd EBP = new X86RegOpnd("ebp", 32);
    public static final X86RegOpnd ESI = new X86RegOpnd("esi", 32);
    public static final X86RegOpnd EDI = new X86RegOpnd("edi", 32);
    public static final X86RegOpnd AX = new X86RegOpnd("ax", 16);
    public static final X86RegOpnd CX = new X86RegOpnd("cx", 16);
    public static final X86RegOpnd DX = new X86RegOpnd("dx", 16);
    public static final X86RegOpnd BX = new X86RegOpnd("bx", 16);
    public static final X86RegOpnd SP = new X86RegOpnd("sp", 16);
    public static final X86RegOpnd BP = new X86RegOpnd("bp", 16);
    public static final X86RegOpnd SI = new X86RegOpnd("si", 16);
    public static final X86RegOpnd DI = new X86RegOpnd("di", 16);
    public static final X86RegOpnd AL = new X86RegOpnd("al", 8);
    public static final X86RegOpnd CL = new X86RegOpnd("cl", 8);
    public static final X86RegOpnd DL = new X86RegOpnd("dl", 8);
    public static final X86RegOpnd BL = new X86RegOpnd("bl", 8);
    public static final X86RegOpnd AH = new X86RegOpnd("ah", 8);
    public static final X86RegOpnd CH = new X86RegOpnd("ch", 8);
    public static final X86RegOpnd DH = new X86RegOpnd("dh", 8);
    public static final X86RegOpnd BH = new X86RegOpnd("bh", 8);
    private static X86RegOpnd[] registers8;
    private static X86RegOpnd[] registers16;
    private static X86RegOpnd[] registers32;

    public static int getNumberOfRegisters() {
        return 8;
    }

    public static X86RegOpnd getRegister8(int regNum) {
        assert (regNum > -1 && regNum < 8) : "invalid integer register number";
        return registers8[regNum];
    }

    public static X86RegOpnd getRegister16(int regNum) {
        assert (regNum > -1 && regNum < 8) : "invalid integer register number";
        return registers16[regNum];
    }

    public static X86RegOpnd getRegister32(int regNum) {
        assert (regNum > -1 && regNum < 8) : "invalid integer register number";
        return registers32[regNum];
    }

    public static String getRegisterName(int regNum) {
        assert (regNum > -1 && regNum < 8) : "invalid integer register number";
        return registers32[regNum].toString();
    }

    static {
        registers32 = new X86RegOpnd[]{EAX, ECX, EDX, EBX, ESP, EBP, ESI, EDI};
        registers16 = new X86RegOpnd[]{AX, CX, DX, BX, SP, BP, SI, DI};
        registers8 = new X86RegOpnd[]{AL, CL, DL, BL, AH, CH, DH, BH};
    }
}

