/*
 * Decompiled with CFR 0.152.
 */
package bindis.x86.common;

import bindis.x86.common.X86RegOpnd;

public class X86SegmentRegisters {
    public static final int NUM_SEGMENT_REGISTERS = 6;
    public static final X86RegOpnd ES = new X86RegOpnd("es", 32);
    public static final X86RegOpnd CS = new X86RegOpnd("cs", 32);
    public static final X86RegOpnd SS = new X86RegOpnd("ss", 32);
    public static final X86RegOpnd DS = new X86RegOpnd("ds", 32);
    public static final X86RegOpnd FS = new X86RegOpnd("fs", 32);
    public static final X86RegOpnd GS = new X86RegOpnd("gs", 32);
    private static X86RegOpnd[] segmentRegisters = new X86RegOpnd[]{ES, CS, SS, DS, FS, GS};

    public static int getNumberOfRegisters() {
        return 6;
    }

    public static X86RegOpnd getSegmentRegister(int regNum) {
        assert (regNum > -1 && regNum < 6) : "invalid segment register number";
        return segmentRegisters[regNum];
    }
}

