/*
 * Decompiled with CFR 0.152.
 */
package bindis.x86.common;

import bindis.gdsl.GdslInstruction;
import binparse.Binary;
import binparse.Symbol;
import java.util.Iterator;
import javalx.data.Option;
import javalx.numeric.Interval;
import rreil.disassembler.Instruction;
import rreil.disassembler.OperandInfixIterator;
import rreil.disassembler.OperandTree;
import rreil.lang.RReilAddr;

public class X86PrettyPrinter {
    private final Instruction insn;

    public X86PrettyPrinter(Instruction insn) {
        this.insn = insn;
    }

    public static String print(Instruction insn) {
        return new X86PrettyPrinter(insn).getInstruction();
    }

    public String getInstruction() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("%-6s", this.getMnemonic()));
        builder.append(" ");
        builder.append(this.getOperands(true));
        return builder.toString();
    }

    public String getRichInstruction(Binary symbolsProvider) {
        String instructionString = this.getInstruction();
        String mnemonic = this.getMnemonic();
        String operands = this.getOperands(false);
        if (mnemonic.matches("(?i)call|ja|jnbe|jae|jnb|jb|jnae|jbe|jna|jc|jcxz|jecxz|je|jz|jg|jnlejge|jnl|jl|jnge|jle|jng|jmp|jnc|jne|jnz|jno|jns|jnp|jpo|jo|jp|jpe|js")) {
            if (operands.matches("(?i).*(ip|eip|rip).*")) {
                long targetRelativeAddress = 0L;
                String[] params = operands.split("[\\+\\-]");
                if (params.length <= 1) {
                    return instructionString;
                }
                String offset = params[params.length - 1].trim();
                while (offset.startsWith("(")) {
                    offset = offset.substring(1);
                }
                while (offset.endsWith(")")) {
                    offset = offset.substring(0, offset.length() - 1);
                }
                offset = offset.trim();
                try {
                    targetRelativeAddress = Long.parseLong(offset, 10);
                    if (operands.contains("-")) {
                        targetRelativeAddress = -1L * targetRelativeAddress;
                    }
                }
                catch (NumberFormatException e) {
                    return instructionString;
                }
                RReilAddr address = this.insn.address();
                long targetAbsoluteAddress = targetRelativeAddress + address.base() + (long)this.insn.length();
                String addressString = RReilAddr.valueOf(targetAbsoluteAddress).toShortString();
                Option<Symbol> symbol = symbolsProvider.getSymbol(targetAbsoluteAddress);
                instructionString = instructionString + " # 0x" + addressString;
                if (symbol.isSome()) {
                    instructionString = instructionString + " <" + symbol.get() + ">";
                }
                return instructionString;
            }
            long targetAbsoluteAddress = 0L;
            String hexOperands = this.getOperands(true);
            String[] params = hexOperands.split("0x");
            if (params.length <= 1) {
                return instructionString;
            }
            try {
                String absolute = params[params.length - 1];
                absolute = absolute.trim();
                targetAbsoluteAddress = Long.parseLong(absolute, 16);
            }
            catch (NumberFormatException e) {
                return instructionString;
            }
            Option<Symbol> symbol = symbolsProvider.getSymbol(targetAbsoluteAddress);
            if (symbol.isNone()) {
                return instructionString;
            }
            return instructionString + " <" + symbol.get() + ">";
        }
        return instructionString;
    }

    public String getAddress() {
        return Long.toHexString(this.insn.baseAddress());
    }

    public String getOpcode() {
        StringBuilder builder = new StringBuilder();
        this.insn.opcode(builder);
        return builder.toString();
    }

    public String getMnemonic() {
        return this.insn.mnemonic();
    }

    public String getOperands(boolean numbersInHex) {
        if (this.insn instanceof GdslInstruction) {
            return ((GdslInstruction)this.insn).getOperandsString();
        }
        StringBuilder builder = new StringBuilder();
        Iterator<OperandTree> it = this.insn.operands().iterator();
        while (it.hasNext()) {
            boolean applyLeaHack = this.insn.mnemonic().toLowerCase().equals("lea");
            builder.append(X86PrettyPrinter.renderOperand(it.next(), numbersInHex, applyLeaHack));
            if (!it.hasNext()) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    private static String renderOperand(OperandTree operand, boolean numbersInHex, boolean isLea) {
        StringBuilder builder = new StringBuilder();
        OperandInfixIterator it = new OperandInfixIterator(operand.getRoot());
        boolean pointer = false;
        int size = 64;
        while (it.next()) {
            OperandTree.Node node = it.current();
            switch (node.getType()) {
                case Immf: 
                case Immi: {
                    builder.append(X86PrettyPrinter.formatNumber((Number)node.getData(), numbersInHex, size, pointer));
                    break;
                }
                case Immr: {
                    builder.append(((Interval)node.getData()).toString());
                    break;
                }
                case Sym: {
                    builder.append(node.getData().toString().toLowerCase());
                    break;
                }
                case Size: {
                    size = ((Number)node.getData()).intValue();
                    break;
                }
                case Op: {
                    builder.append(node.getData().toString().toLowerCase().replaceAll("dword ptr", "DWORD PTR"));
                    break;
                }
                case Mem: {
                    if (!isLea) {
                        builder.append(X86PrettyPrinter.pointerSizeTranslation((Number)node.getData()));
                    }
                    builder.append("[");
                    pointer = true;
                }
            }
        }
        if (pointer) {
            builder.append("]");
        }
        String string = builder.toString().replaceAll("\\+-", "-");
        return string;
    }

    private static String formatNumber(Number number, boolean hex, int size, boolean showSign) {
        String numString;
        String sign = "";
        long longValue = number.longValue();
        if (showSign && longValue < 0L) {
            sign = "-";
            longValue = -longValue;
        }
        if (hex) {
            String hexString = Long.toHexString(longValue);
            if (hexString.length() > size / 4) {
                hexString = hexString.substring(hexString.length() - size / 4);
            }
            numString = sign + "0x" + hexString;
        } else {
            numString = number.toString();
        }
        return numString;
    }

    private static String pointerSizeTranslation(Number size) {
        switch (size.intValue()) {
            case 8: {
                return "BYTE PTR ";
            }
            case 16: {
                return "WORD PTR ";
            }
            case 32: {
                return "DWORD PTR ";
            }
            case 64: {
                return "QWORD PTR ";
            }
        }
        throw new IllegalArgumentException("The size of an x86 instruction cannot be " + size);
    }
}

