/*
 * Decompiled with CFR 0.152.
 */
package bindis.x86.common;

import bindis.DecodeStream;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class X86Prefixes {
    private static final Map<Integer, Prefix> ords = new HashMap<Integer, Prefix>();
    private final EnumSet<Prefix> prefixes = EnumSet.noneOf(Prefix.class);

    private X86Prefixes() {
    }

    public boolean hasOpcodePrefix66() {
        return this.prefixes.contains((Object)Prefix.OPNDSZ);
    }

    public X86Prefixes discardOpcodePrefix66() {
        this.prefixes.remove((Object)Prefix.OPNDSZ);
        return this;
    }

    public boolean hasOpcodePrefixF2() {
        return this.prefixes.contains((Object)Prefix.REPNZ);
    }

    public X86Prefixes discardOpcodePrefixF2() {
        this.prefixes.remove((Object)Prefix.REPNZ);
        return this;
    }

    public boolean hasOpcodePrefixF3() {
        return this.prefixes.contains((Object)Prefix.REPZ);
    }

    public X86Prefixes discardOpcodePrefixF3() {
        this.prefixes.remove((Object)Prefix.REPZ);
        return this;
    }

    public boolean contains(Prefix p) {
        return this.prefixes.contains((Object)p);
    }

    public static X86Prefixes decode64(DecodeStream in) {
        int value;
        Prefix prefix;
        X86Prefixes actual = new X86Prefixes();
        while ((prefix = ords.get(value = in.peek8())) != null && !prefix.isRexPrefix()) {
            in.read8();
            actual.prefixes.add(ords.get(value));
        }
        value = in.peek8();
        boolean popByte = false;
        if (value > 79 || value < Prefix.REXB.ord()) {
            return actual;
        }
        if (X86Prefixes.isRexPrefix(value, Prefix.REXW.ord())) {
            actual.prefixes.add(Prefix.REXW);
            popByte = true;
        }
        if (X86Prefixes.isRexPrefix(value, Prefix.REXX.ord())) {
            actual.prefixes.add(Prefix.REXX);
            popByte = true;
        }
        if (X86Prefixes.isRexPrefix(value, Prefix.REXB.ord())) {
            actual.prefixes.add(Prefix.REXB);
            popByte = true;
        }
        if (X86Prefixes.isRexPrefix(value, Prefix.REXR.ord())) {
            actual.prefixes.add(Prefix.REXR);
            popByte = true;
        }
        if (popByte) {
            in.read8();
        }
        return actual;
    }

    private static boolean isRexPrefix(int value, int ord) {
        return (value & ord) == ord;
    }

    public static X86Prefixes decode32(DecodeStream in) {
        int value;
        Prefix prefix;
        X86Prefixes actual = new X86Prefixes();
        while ((prefix = ords.get(value = in.peek8())) != null && !prefix.isRexPrefix()) {
            in.read8();
            actual.prefixes.add(ords.get(value));
        }
        return actual;
    }

    public boolean isEmpty() {
        return this.prefixes.isEmpty();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        Iterator it = this.prefixes.iterator();
        while (it.hasNext()) {
            Prefix prefix = (Prefix)((Object)it.next());
            builder.append((Object)prefix);
            if (!it.hasNext()) continue;
            builder.append(", ");
        }
        builder.append('}');
        return builder.toString();
    }

    static {
        for (Prefix p : Prefix.values()) {
            ords.put(p.ord, p);
        }
    }

    public static enum Prefix {
        OPNDSZ(102),
        REPNZ(242),
        REPZ(243),
        LOCK(240),
        ADDRSZ(103),
        CS(46),
        SS(54),
        DS(62),
        ES(38),
        FS(100),
        GS(101),
        REXW(72),
        REXR(68),
        REXX(66),
        REXB(65);

        private final int ord;

        private Prefix(int ord) {
            this.ord = ord;
        }

        public int ord() {
            return this.ord;
        }

        public boolean isRexPrefix() {
            return this == REXW || this == REXR || this == REXX || this == REXB;
        }
    }
}

