/*
 * Decompiled with CFR 0.152.
 */
package bindis.x86.common;

import bindis.DecodeException;
import bindis.DecodeStream;
import bindis.x86.common.X86DecodeCtx;
import bindis.x86.common.X86ImmOpnd;
import bindis.x86.common.X86MemOpnd;
import bindis.x86.common.X86ModRM;
import bindis.x86.common.X86Operand;
import bindis.x86.common.X86Prefixes;
import bindis.x86.common.X86RegOpnd;
import bindis.x86.common.X86RegisterSet;
import bindis.x86.common.X86Sib;

public class X86OperandDecoders {
    public static final int a_mode = 1;
    public static final int b_mode = 2;
    public static final int c_mode = 3;
    public static final int d_mode = 4;
    public static final int dq_mode = 5;
    public static final int p_mode = 6;
    public static final int pd_mode = 7;
    public static final int pi_mode = 8;
    public static final int ps_mode = 9;
    public static final int q_mode = 10;
    public static final int s_mode = 11;
    public static final int sd_mode = 12;
    public static final int si_mode = 13;
    public static final int ss_mode = 14;
    public static final int v_mode = 15;
    public static final int w_mode = 16;
    public static final int z_mode = 17;
    public static final int INVALID_OPERANDTYPE = -1;
    public final AddrMode ADDR_A = new AddrModeA();
    public final AddrMode ADDR_C = new AddrModeC();
    public final AddrMode ADDR_D = new AddrModeD();
    public final AddrMode ADDR_E = new AddrModeE();
    public final AddrMode ADDR_F = new AddrModeF();
    public final AddrMode ADDR_FREG = new AddrModeFreg();
    public final AddrMode ADDR_G = new AddrModeG();
    public final AddrMode ADDR_I = new AddrModeI();
    public final AddrMode ADDR_I64 = new AddrModeI64();
    public final AddrMode ADDR_J = new AddrModeJ();
    public final AddrMode ADDR_M = new AddrModeM();
    public final AddrMode ADDR_N = new AddrModeN();
    public final AddrMode ADDR_O = new AddrModeO();
    public final AddrMode ADDR_P = new AddrModeP();
    public final AddrMode ADDR_Q = new AddrModeQ();
    public final AddrMode ADDR_R = new AddrModeR();
    public final AddrMode ADDR_REG = new AddrModeReg();
    public final AddrMode ADDR_S = new AddrModeS();
    public final AddrMode ADDR_T = new AddrModeT();
    public final AddrMode ADDR_U = new AddrModeU();
    public final AddrMode ADDR_V = new AddrModeV();
    public final AddrMode ADDR_W = new AddrModeW();
    public final AddrMode ADDR_X = new AddrModeX();
    public final AddrMode ADDR_Y = new AddrModeY();
    public final AddrMode ADDR_IMM = new AddrModeImm();
    private final X86RegisterSet registerSet;

    public X86OperandDecoders(X86RegisterSet registerSet) {
        this.registerSet = registerSet;
    }

    public static abstract class AddrMode {
        public abstract X86Operand decode(X86DecodeCtx var1, int var2);

        protected X86ImmOpnd imm8(DecodeStream in) {
            return new X86ImmOpnd(8, in.read8());
        }

        protected X86ImmOpnd imm16(DecodeStream in) {
            return new X86ImmOpnd(16, in.read16());
        }

        protected X86ImmOpnd imm32(DecodeStream in) {
            return new X86ImmOpnd(32, in.read32());
        }

        protected X86ImmOpnd signedImm8(int size, DecodeStream in) {
            return new X86ImmOpnd((int)((byte)size), in.raw8());
        }

        protected X86ImmOpnd signedImm16(int size, DecodeStream in) {
            return new X86ImmOpnd((int)((byte)size), in.raw16());
        }

        protected X86ImmOpnd signedImm32(int size, DecodeStream in) {
            return new X86ImmOpnd((int)((byte)size), in.raw32());
        }

        protected X86ImmOpnd signedImm64(int size, DecodeStream in) {
            return new X86ImmOpnd((int)((byte)size), in.raw64());
        }

        public X86Operand decodeModRM(X86DecodeCtx ctx, X86RegisterSet registerSet, int opndType) {
            X86Prefixes prefixes = ctx.getPrefixes();
            X86MemOpnd opnd = null;
            DecodeStream in = ctx.getDecodeStream();
            X86ModRM modRM = ctx.getModRM();
            int rm = modRM.getRm();
            int mod = modRM.getMod();
            int memSize = registerSet.effectiveMemoryAccessSize(ctx.getPrefixes(), opndType);
            int addrSize = registerSet.effectiveAddressSize(ctx.getPrefixes(), opndType);
            int scale = 0;
            int index = 0;
            int base = 0;
            long disp = 0L;
            if (rm == 4) {
                X86Sib sib = X86Sib.decode(in);
                scale = sib.getScale();
                index = sib.getIndex();
                base = sib.getBase();
                index = prefixes.contains(X86Prefixes.Prefix.REXX) ? index + 8 : index;
                base = prefixes.contains(X86Prefixes.Prefix.REXB) ? base + 8 : base;
            } else {
                rm = prefixes.contains(X86Prefixes.Prefix.REXB) ? rm + 8 : rm;
            }
            block0 : switch (mod) {
                case 3: {
                    throw DecodeException.inconsistentDecoder(ctx);
                }
                case 0: {
                    X86RegOpnd baseOpnd;
                    switch (rm) {
                        case 4: {
                            X86ImmOpnd dispOpnd;
                            if (base == 5) {
                                disp = in.read32();
                                if (index != 4) {
                                    X86RegOpnd indexOpnd = (X86RegOpnd)registerSet.getGPRAsAddressPart(prefixes, index);
                                    X86ImmOpnd dispOpnd2 = new X86ImmOpnd(addrSize, disp);
                                    opnd = X86MemOpnd.mk(memSize, indexOpnd, (byte)scale, dispOpnd2);
                                    break block0;
                                }
                                dispOpnd = new X86ImmOpnd(addrSize, disp);
                                opnd = X86MemOpnd.mk(memSize, dispOpnd);
                                break block0;
                            }
                            if (index != 4) {
                                baseOpnd = (X86RegOpnd)registerSet.getGPRAsAddressPart(prefixes, base);
                                X86RegOpnd indexOpnd = (X86RegOpnd)registerSet.getGPRAsAddressPart(prefixes, index);
                                opnd = X86MemOpnd.mk(memSize, baseOpnd, indexOpnd, (byte)scale);
                                break block0;
                            }
                            baseOpnd = (X86RegOpnd)registerSet.getGPRAsAddressPart(prefixes, rm);
                            opnd = X86MemOpnd.mk(memSize, baseOpnd);
                            break block0;
                        }
                        case 5: {
                            disp = in.read32();
                            if (registerSet.is64BitArchitecture()) {
                                disp += ctx.getStartPc() + (long)in.consumed();
                            }
                            X86ImmOpnd dispOpnd = new X86ImmOpnd(addrSize, disp);
                            opnd = X86MemOpnd.mk(memSize, dispOpnd);
                            break block0;
                        }
                    }
                    base = rm;
                    baseOpnd = (X86RegOpnd)registerSet.getGPRAsAddressPart(prefixes, base);
                    opnd = X86MemOpnd.mk(memSize, baseOpnd);
                    break;
                }
                case 1: {
                    X86RegOpnd baseOpnd;
                    disp = (byte)in.read8();
                    if (rm != 4) {
                        base = rm;
                        baseOpnd = (X86RegOpnd)registerSet.getGPRAsAddressPart(prefixes, base);
                        X86ImmOpnd dispOpnd = new X86ImmOpnd(addrSize, disp);
                        opnd = X86MemOpnd.mk(memSize, baseOpnd, dispOpnd);
                        break;
                    }
                    if (index != 4) {
                        baseOpnd = (X86RegOpnd)registerSet.getGPRAsAddressPart(prefixes, base);
                        X86RegOpnd indexOpnd = (X86RegOpnd)registerSet.getGPRAsAddressPart(prefixes, index);
                        X86ImmOpnd dispOpnd = new X86ImmOpnd(addrSize, disp);
                        opnd = X86MemOpnd.mk(memSize, baseOpnd, indexOpnd, (byte)scale, dispOpnd);
                        break;
                    }
                    baseOpnd = (X86RegOpnd)registerSet.getGPRAsAddressPart(prefixes, base);
                    X86ImmOpnd dispOpnd = new X86ImmOpnd(addrSize, disp);
                    opnd = X86MemOpnd.mk(memSize, baseOpnd, dispOpnd);
                    break;
                }
                case 2: {
                    X86RegOpnd baseOpnd;
                    disp = in.read32();
                    if (rm != 4) {
                        base = rm;
                        baseOpnd = (X86RegOpnd)registerSet.getGPRAsAddressPart(prefixes, base);
                        X86ImmOpnd dispOpnd = new X86ImmOpnd(addrSize, disp);
                        opnd = X86MemOpnd.mk(memSize, baseOpnd, dispOpnd);
                        break;
                    }
                    if (index != 4) {
                        baseOpnd = (X86RegOpnd)registerSet.getGPRAsAddressPart(prefixes, base);
                        X86RegOpnd indexOpnd = (X86RegOpnd)registerSet.getGPRAsAddressPart(prefixes, index);
                        X86ImmOpnd dispOpnd = new X86ImmOpnd(addrSize, disp);
                        opnd = X86MemOpnd.mk(memSize, baseOpnd, indexOpnd, (byte)scale, dispOpnd);
                        break;
                    }
                    baseOpnd = (X86RegOpnd)registerSet.getGPRAsAddressPart(prefixes, base);
                    X86ImmOpnd dispOpnd = new X86ImmOpnd(addrSize, disp);
                    opnd = X86MemOpnd.mk(memSize, baseOpnd, dispOpnd);
                }
            }
            return opnd;
        }
    }

    public class AddrModeReg
    extends AddrMode {
        @Override
        public X86Operand decode(X86DecodeCtx ctx, int opndType) {
            X86Operand opnd;
            X86Prefixes prefixes = ctx.getPrefixes();
            int opndOffset = prefixes.contains(X86Prefixes.Prefix.REXB) ? opndType + 8 : opndType;
            switch (opndType) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if (prefixes.contains(X86Prefixes.Prefix.REXW)) {
                        opnd = X86OperandDecoders.this.registerSet.getGPR64(prefixes, opndOffset - 0);
                        break;
                    }
                    opnd = X86OperandDecoders.this.registerSet.getGPR32(prefixes, opndOffset - 0);
                    break;
                }
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    opnd = X86OperandDecoders.this.registerSet.getGPR64(prefixes, opndOffset - 30);
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    opnd = X86OperandDecoders.this.registerSet.getGPR16(prefixes, opndOffset - 8);
                    break;
                }
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    opnd = X86OperandDecoders.this.registerSet.getGPR8(prefixes, opndOffset - 16);
                    break;
                }
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    opnd = X86OperandDecoders.this.registerSet.getSegmentRegister(prefixes, opndOffset - 24);
                    break;
                }
                default: {
                    throw DecodeException.inconsistentDecoder(ctx);
                }
            }
            return opnd;
        }
    }

    public class AddrModeY
    extends AddrMode {
        @Override
        public X86Operand decode(X86DecodeCtx ctx, int opndType) {
            X86Prefixes prefixes = ctx.getPrefixes();
            int size = X86OperandDecoders.this.registerSet.effectiveMemoryAccessSize(prefixes, opndType);
            return X86MemOpnd.mk(size, (X86RegOpnd)X86OperandDecoders.this.registerSet.getGPRAsAddressPart(prefixes, 7));
        }
    }

    public class AddrModeX
    extends AddrMode {
        @Override
        public X86Operand decode(X86DecodeCtx ctx, int opndType) {
            X86Prefixes prefixes = ctx.getPrefixes();
            int size = X86OperandDecoders.this.registerSet.effectiveMemoryAccessSize(prefixes, opndType);
            return X86MemOpnd.mk(size, (X86RegOpnd)X86OperandDecoders.this.registerSet.getGPRAsAddressPart(prefixes, 6));
        }
    }

    public class AddrModeW
    extends AddrMode {
        @Override
        public X86Operand decode(X86DecodeCtx ctx, int opndType) {
            X86Prefixes prefixes = ctx.getPrefixes();
            int rm = ctx.getModRM().getRm();
            int mod = ctx.getModRM().getMod();
            if (mod == 3) {
                return X86OperandDecoders.this.registerSet.getXMMRegister(prefixes, rm);
            }
            return this.decodeModRM(ctx, X86OperandDecoders.this.registerSet, opndType);
        }
    }

    public class AddrModeV
    extends AddrMode {
        @Override
        public X86Operand decode(X86DecodeCtx ctx, int opndType) {
            X86Prefixes prefixes = ctx.getPrefixes();
            int regOrOpcode = ctx.getModRM().getRegOrOpcode();
            regOrOpcode = prefixes.contains(X86Prefixes.Prefix.REXR) ? regOrOpcode + 8 : regOrOpcode;
            return X86OperandDecoders.this.registerSet.getXMMRegister(prefixes, regOrOpcode);
        }
    }

    public class AddrModeU
    extends AddrMode {
        @Override
        public X86Operand decode(X86DecodeCtx ctx, int opndType) {
            return X86OperandDecoders.this.registerSet.getXMMRegister(ctx.getPrefixes(), ctx.getModRM().getRm());
        }
    }

    public class AddrModeT
    extends AddrMode {
        @Override
        public X86Operand decode(X86DecodeCtx ctx, int opndType) {
            throw new UnsupportedOperationException();
        }
    }

    public class AddrModeS
    extends AddrMode {
        @Override
        public X86Operand decode(X86DecodeCtx ctx, int opndType) {
            return X86OperandDecoders.this.registerSet.getSegmentRegister(ctx.getPrefixes(), ctx.getModRM().getRegOrOpcode());
        }
    }

    public class AddrModeR
    extends AddrMode {
        @Override
        public X86Operand decode(X86DecodeCtx ctx, int opndType) {
            X86Operand op;
            X86Prefixes prefixes = ctx.getPrefixes();
            boolean opndSize = prefixes.contains(X86Prefixes.Prefix.OPNDSZ);
            boolean rexw = prefixes.contains(X86Prefixes.Prefix.REXW);
            int rm = ctx.getModRM().getRm();
            rm = prefixes.contains(X86Prefixes.Prefix.REXR) ? rm + 8 : rm;
            switch (opndType) {
                case 2: {
                    op = X86OperandDecoders.this.registerSet.getGPR8(prefixes, rm);
                    break;
                }
                case 16: {
                    op = X86OperandDecoders.this.registerSet.getGPR16(prefixes, rm);
                    break;
                }
                case 4: {
                    op = X86OperandDecoders.this.registerSet.getGPR32(prefixes, rm);
                    break;
                }
                case 15: {
                    if (rexw) {
                        op = X86OperandDecoders.this.registerSet.getGPR(prefixes, rm);
                        break;
                    }
                    if (opndSize) {
                        op = X86OperandDecoders.this.registerSet.getGPR16(prefixes, rm);
                        break;
                    }
                    op = X86OperandDecoders.this.registerSet.getGPR32(prefixes, rm);
                    break;
                }
                default: {
                    throw DecodeException.inconsistentDecoder(ctx);
                }
            }
            return op;
        }
    }

    public class AddrModeQ
    extends AddrMode {
        @Override
        public X86Operand decode(X86DecodeCtx ctx, int opndType) {
            X86Prefixes prefixes = ctx.getPrefixes();
            int rm = ctx.getModRM().getRm();
            int mod = ctx.getModRM().getMod();
            if (mod == 3) {
                return X86OperandDecoders.this.registerSet.getMMXRegister(prefixes, rm);
            }
            return this.decodeModRM(ctx, X86OperandDecoders.this.registerSet, opndType);
        }
    }

    public class AddrModeP
    extends AddrMode {
        @Override
        public X86Operand decode(X86DecodeCtx ctx, int opndType) {
            X86Prefixes prefixes = ctx.getPrefixes();
            int regOrOpcode = ctx.getModRM().getRegOrOpcode();
            regOrOpcode = prefixes.contains(X86Prefixes.Prefix.REXR) ? regOrOpcode + 8 : regOrOpcode;
            return X86OperandDecoders.this.registerSet.getMMXRegister(prefixes, regOrOpcode);
        }
    }

    public class AddrModeO
    extends AddrMode {
        @Override
        public X86Operand decode(X86DecodeCtx ctx, int opndType) {
            DecodeStream in = ctx.getDecodeStream();
            boolean addressSize = ctx.getPrefixes().contains(X86Prefixes.Prefix.ADDRSZ);
            X86ImmOpnd offsetOpnd = addressSize ? this.imm16(in) : this.imm32(in);
            return X86MemOpnd.mk(offsetOpnd.size(), offsetOpnd);
        }
    }

    public class AddrModeN
    extends AddrMode {
        @Override
        public X86Operand decode(X86DecodeCtx ctx, int opndType) {
            X86Prefixes prefixes = ctx.getPrefixes();
            int rm = ctx.getModRM().getRm();
            rm = prefixes.contains(X86Prefixes.Prefix.REXR) ? rm + 8 : rm;
            return X86OperandDecoders.this.registerSet.getMMXRegister(prefixes, rm);
        }
    }

    public class AddrModeM
    extends AddrMode {
        @Override
        public X86Operand decode(X86DecodeCtx ctx, int opndType) {
            return this.decodeModRM(ctx, X86OperandDecoders.this.registerSet, opndType);
        }
    }

    public class AddrModeJ
    extends AddrMode {
        @Override
        public X86Operand decode(X86DecodeCtx ctx, int opndType) {
            DecodeStream in = ctx.getDecodeStream();
            boolean operandSize = ctx.getPrefixes().contains(X86Prefixes.Prefix.OPNDSZ);
            long disp = 0L;
            long startPc = ctx.getStartPc();
            switch (opndType) {
                case 2: {
                    disp = in.raw8();
                    break;
                }
                case 15: {
                    if (operandSize) {
                        disp = in.raw16();
                        break;
                    }
                    disp = in.raw32();
                    break;
                }
                default: {
                    throw DecodeException.inconsistentDecoder(ctx);
                }
            }
            return new X86ImmOpnd(X86OperandDecoders.this.registerSet.getArchitectureSize(), disp += startPc + (long)in.consumed());
        }
    }

    public class AddrModeI64
    extends AddrMode {
        @Override
        public X86Operand decode(X86DecodeCtx ctx, int opndType) {
            X86ImmOpnd opnd;
            DecodeStream in = ctx.getDecodeStream();
            switch (opndType) {
                case 2: {
                    opnd = this.signedImm8(8, in);
                    break;
                }
                case 16: {
                    opnd = this.signedImm16(16, in);
                    break;
                }
                case 15: {
                    if (ctx.getPrefixes().contains(X86Prefixes.Prefix.OPNDSZ)) {
                        opnd = this.signedImm16(16, in);
                        break;
                    }
                    if (ctx.getPrefixes().contains(X86Prefixes.Prefix.REXW)) {
                        opnd = this.signedImm64(64, in);
                        break;
                    }
                    opnd = this.signedImm32(32, in);
                    break;
                }
                default: {
                    throw DecodeException.inconsistentDecoder(ctx);
                }
            }
            return opnd;
        }
    }

    public class AddrModeI
    extends AddrMode {
        @Override
        public X86Operand decode(X86DecodeCtx ctx, int opndType) {
            X86ImmOpnd opnd;
            DecodeStream in = ctx.getDecodeStream();
            switch (opndType) {
                case 2: {
                    opnd = this.signedImm8(8, in);
                    break;
                }
                case 16: {
                    opnd = this.signedImm16(16, in);
                    break;
                }
                case 15: {
                    if (ctx.getPrefixes().contains(X86Prefixes.Prefix.OPNDSZ)) {
                        opnd = this.signedImm16(16, in);
                        break;
                    }
                    opnd = this.signedImm32(32, in);
                    break;
                }
                default: {
                    throw DecodeException.inconsistentDecoder(ctx);
                }
            }
            return opnd;
        }
    }

    public class AddrModeG
    extends AddrMode {
        @Override
        public X86Operand decode(X86DecodeCtx ctx, int opndType) {
            X86Operand opnd;
            X86Prefixes prefixes = ctx.getPrefixes();
            int regOrOpcode = ctx.getModRM().getRegOrOpcode();
            regOrOpcode = prefixes.contains(X86Prefixes.Prefix.REXR) ? regOrOpcode + 8 : regOrOpcode;
            switch (opndType) {
                case 2: {
                    opnd = X86OperandDecoders.this.registerSet.getGPR8(prefixes, regOrOpcode);
                    break;
                }
                case 16: {
                    opnd = X86OperandDecoders.this.registerSet.getGPR16(prefixes, regOrOpcode);
                    break;
                }
                case 4: {
                    opnd = X86OperandDecoders.this.registerSet.getGPR32(prefixes, regOrOpcode);
                    break;
                }
                case 15: {
                    opnd = X86OperandDecoders.this.registerSet.getGPR(prefixes, regOrOpcode);
                    break;
                }
                default: {
                    throw DecodeException.inconsistentDecoder(ctx);
                }
            }
            return opnd;
        }
    }

    public class AddrModeFreg
    extends AddrMode {
        @Override
        public X86Operand decode(X86DecodeCtx ctx, int opndType) {
            X86Operand opnd;
            X86Prefixes prefixes = ctx.getPrefixes();
            int rm = ctx.getModRM().getRm();
            switch (opndType) {
                case 0: {
                    opnd = X86OperandDecoders.this.registerSet.getFloatingPointRegister(prefixes, 0);
                    break;
                }
                case 1: {
                    opnd = X86OperandDecoders.this.registerSet.getFloatingPointRegister(prefixes, rm);
                    break;
                }
                default: {
                    throw DecodeException.inconsistentDecoder(ctx);
                }
            }
            return opnd;
        }
    }

    public class AddrModeF
    extends AddrMode {
        @Override
        public X86Operand decode(X86DecodeCtx ctx, int opndType) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public class AddrModeE
    extends AddrMode {
        @Override
        public X86Operand decode(X86DecodeCtx ctx, int opndType) {
            X86Operand opnd;
            block9: {
                block8: {
                    X86Prefixes prefixes = ctx.getPrefixes();
                    opnd = null;
                    int rm = ctx.getModRM().getRm();
                    int mod = ctx.getModRM().getMod();
                    int n = rm = prefixes.contains(X86Prefixes.Prefix.REXB) ? rm + 8 : rm;
                    if (mod != 3) break block8;
                    switch (opndType) {
                        case 2: {
                            opnd = X86OperandDecoders.this.registerSet.getGPR8(prefixes, rm);
                            break block9;
                        }
                        case 16: {
                            opnd = X86OperandDecoders.this.registerSet.getGPR16(prefixes, rm);
                            break block9;
                        }
                        case 15: {
                            opnd = X86OperandDecoders.this.registerSet.getGPR(prefixes, rm);
                            break block9;
                        }
                        case 6: {
                            X86RegOpnd reg = (X86RegOpnd)X86OperandDecoders.this.registerSet.getGPRAsAddressPart(prefixes, rm);
                            opnd = X86MemOpnd.mk(X86OperandDecoders.this.registerSet.effectiveMemoryAccessSize(ctx.getPrefixes(), opndType), reg);
                            break block9;
                        }
                        case 4: {
                            opnd = X86OperandDecoders.this.registerSet.getGPR32(prefixes, rm);
                            break block9;
                        }
                        case 10: {
                            opnd = X86OperandDecoders.this.registerSet.getGPR64(prefixes, rm);
                            break block9;
                        }
                        default: {
                            throw DecodeException.inconsistentDecoder(ctx);
                        }
                    }
                }
                opnd = this.decodeModRM(ctx, X86OperandDecoders.this.registerSet, opndType);
            }
            return opnd;
        }
    }

    public class AddrModeD
    extends AddrMode {
        @Override
        public X86Operand decode(X86DecodeCtx ctx, int opndType) {
            X86Prefixes prefixes = ctx.getPrefixes();
            int regOrOpcode = ctx.getModRM().getRegOrOpcode();
            regOrOpcode = prefixes.contains(X86Prefixes.Prefix.REXR) ? regOrOpcode + 8 : regOrOpcode;
            return X86OperandDecoders.this.registerSet.getDebugRegister(prefixes, regOrOpcode);
        }
    }

    public class AddrModeC
    extends AddrMode {
        @Override
        public X86Operand decode(X86DecodeCtx ctx, int opndType) {
            X86Prefixes prefixes = ctx.getPrefixes();
            int regOrOpcode = ctx.getModRM().getRegOrOpcode();
            regOrOpcode = prefixes.contains(X86Prefixes.Prefix.REXR) ? regOrOpcode + 8 : regOrOpcode;
            return X86OperandDecoders.this.registerSet.getControlRegister(prefixes, regOrOpcode);
        }
    }

    public class AddrModeImm
    extends AddrMode {
        @Override
        public X86Operand decode(X86DecodeCtx ctx, int opndType) {
            X86Prefixes prefixes = ctx.getPrefixes();
            X86ImmOpnd opnd = new X86ImmOpnd(8, opndType);
            return opnd;
        }
    }

    public class AddrModeA
    extends AddrMode {
        @Override
        public X86Operand decode(X86DecodeCtx ctx, int opndType) {
            X86MemOpnd op;
            DecodeStream in = ctx.getDecodeStream();
            X86Prefixes prefixes = ctx.getPrefixes();
            int memSz = X86OperandDecoders.this.registerSet.effectiveMemoryAccessSize(prefixes, opndType);
            X86ImmOpnd segment = null;
            X86ImmOpnd offset = null;
            boolean addrSize = !ctx.getPrefixes().contains(X86Prefixes.Prefix.ADDRSZ);
            switch (opndType) {
                case 6: {
                    if (addrSize) {
                        offset = this.imm32(in);
                        segment = this.imm16(in);
                    } else {
                        offset = this.imm16(in);
                        segment = this.imm16(in);
                    }
                    op = new X86MemOpnd(memSz, addrSize ? 32 : 16, segment, offset);
                    break;
                }
                case 15: {
                    offset = addrSize ? this.imm32(in) : this.imm16(in);
                    op = X86MemOpnd.mk(offset.size(), offset);
                    break;
                }
                default: {
                    throw DecodeException.inconsistentDecoder(ctx);
                }
            }
            return op;
        }
    }
}

