/*
 * Decompiled with CFR 0.152.
 */
package bindis.x86.common;

import bindis.DecodeException;
import bindis.DecodeStream;
import bindis.IndexOutOfBoundsException;
import bindis.NativeDisassembler;
import bindis.NativeInstruction;
import bindis.x86.common.X86DecodeCtx;
import bindis.x86.common.X86DecodeTable;
import bindis.x86.common.X86InstructionDecoder;
import bindis.x86.common.X86Prefixes;
import java.nio.ByteOrder;

public abstract class X86NativeDisassembler
implements NativeDisassembler {
    private final X86DecodeTable decodeTable;

    protected X86NativeDisassembler(X86DecodeTable decodeTable) {
        this.decodeTable = decodeTable;
    }

    public abstract X86Prefixes decodePrefixes(DecodeStream var1);

    @Override
    public NativeInstruction decode(DecodeStream in, long currentPc) {
        NativeInstruction insn;
        in.order(ByteOrder.LITTLE_ENDIAN);
        X86Prefixes prefixes = this.decodePrefixes(in);
        X86InstructionDecoder[] opcodeTable = this.findOpcodeTable(in, prefixes);
        assert (opcodeTable != null) : "Null opcodeTable";
        int opcode = in.read8();
        X86InstructionDecoder decoder = opcodeTable[opcode];
        X86DecodeCtx ctx = new X86DecodeCtx(in, prefixes, currentPc);
        if (decoder == null) {
            throw DecodeException.unknownOpcode(ctx);
        }
        try {
            insn = decoder.decode(ctx);
        }
        catch (IndexOutOfBoundsException e) {
            throw DecodeException.outOfBytes(e.getIndex(), ctx);
        }
        catch (Exception e) {
            throw DecodeException.generalException(e, ctx);
        }
        if (insn == null) {
            throw DecodeException.unknownOpcode(ctx);
        }
        return insn;
    }

    private X86InstructionDecoder[] findOpcodeTable(DecodeStream in, X86Prefixes prefixes) {
        int opcodeOrEscape = in.peek8();
        if (opcodeOrEscape == 15) {
            in.read8();
            if (prefixes.contains(X86Prefixes.Prefix.REPNZ)) {
                return this.decodeTable.twoByteOpcodePrefixF2Table;
            }
            if (prefixes.contains(X86Prefixes.Prefix.REPZ)) {
                return this.decodeTable.twoByteOpcodePrefixF3Table;
            }
            if (prefixes.contains(X86Prefixes.Prefix.OPNDSZ)) {
                int realOpcode = in.peek8();
                if (this.decodeTable.twoByteOpcodePrefix66Table[realOpcode] != null) {
                    return this.decodeTable.twoByteOpcodePrefix66Table;
                }
                return this.decodeTable.twoByteOpcodeTable;
            }
            return this.decodeTable.twoByteOpcodeTable;
        }
        if (prefixes.contains(X86Prefixes.Prefix.REPZ)) {
            return this.decodeTable.twoByteOpcodePrefixF3Table;
        }
        return this.decodeTable.oneByteOpcodeTable;
    }
}

