/*
 * Decompiled with CFR 0.152.
 */
package bindis.x86.common;

import bindis.OperandKind;
import bindis.x86.common.X86ImmOpnd;
import bindis.x86.common.X86Operand;
import bindis.x86.common.X86OperandVisitor;
import bindis.x86.common.X86RegOpnd;

public class X86MemOpnd
extends X86Operand {
    protected final byte scale;
    protected final X86RegOpnd index;
    protected final X86RegOpnd base;
    protected final X86ImmOpnd disp;
    protected final X86ImmOpnd seg;
    protected final int ptrSize;

    private X86MemOpnd(int size, int ptrSize, byte scale, X86RegOpnd index, X86RegOpnd base, X86ImmOpnd disp, X86ImmOpnd seg) {
        super(size, OperandKind.MEM);
        this.scale = scale;
        this.index = index;
        this.base = base;
        this.disp = disp;
        this.seg = seg;
        this.ptrSize = ptrSize;
    }

    public X86MemOpnd(int size, int ptrSize, byte scale, X86RegOpnd index, X86RegOpnd base, X86ImmOpnd disp) {
        this(size, ptrSize, scale, index, base, disp, null);
    }

    public X86MemOpnd(int size, int ptrSize, X86ImmOpnd seg, X86ImmOpnd disp) {
        this(size, ptrSize, 0, null, null, disp, seg);
    }

    public X86RegOpnd base() {
        return this.base;
    }

    public X86ImmOpnd disp() {
        return this.disp;
    }

    public X86RegOpnd index() {
        return this.index;
    }

    public byte scale() {
        return this.scale;
    }

    public int ptrSize() {
        return this.ptrSize;
    }

    @Override
    public StringBuilder asString(StringBuilder buf) {
        buf.append(this.size);
        buf.append('[');
        if (this.base != null) {
            this.base.asString(buf);
        }
        if (this.index != null) {
            if (this.base != null) {
                buf.append('+');
            }
            this.index.asString(buf);
            if (this.scale > 1) {
                buf.append('*');
                buf.append(this.scale);
            }
        }
        if (this.disp != null) {
            if (this.index != null || this.base != null) {
                if (this.disp.imm.intValue() != 0) {
                    buf.append('+');
                    this.disp.asString(buf);
                }
            } else {
                this.disp.asString(buf);
            }
        }
        return buf.append("]:").append(this.ptrSize);
    }

    @Override
    public <R, T> R accept(X86OperandVisitor<R, T> visitor, T data) {
        return visitor.visit(this, data);
    }

    public static X86MemOpnd mk(int dataSize, X86RegOpnd base) {
        return new X86MemOpnd(dataSize, base.size(), -1, null, base, null);
    }

    public static X86MemOpnd mk(int dataSize, X86RegOpnd base, X86RegOpnd index, byte scale) {
        return new X86MemOpnd(dataSize, base.size(), scale, index, base, null);
    }

    public static X86MemOpnd mk(int dataSize, X86RegOpnd base, X86RegOpnd index, byte scale, X86ImmOpnd disp) {
        return new X86MemOpnd(dataSize, base.size(), scale, index, base, disp);
    }

    public static X86MemOpnd mk(int dataSize, X86RegOpnd base, X86ImmOpnd disp) {
        return new X86MemOpnd(dataSize, base.size(), -1, null, base, disp);
    }

    public static X86MemOpnd mk(int dataSize, X86ImmOpnd disp) {
        return new X86MemOpnd(dataSize, disp.size(), -1, null, null, disp);
    }

    public static X86MemOpnd mk(int dataSize, X86RegOpnd index, byte scale, X86ImmOpnd disp) {
        return new X86MemOpnd(dataSize, index.size(), scale, index, null, disp);
    }

    public static X86MemOpnd mk(int dataSize, X86ImmOpnd seg, X86ImmOpnd offs) {
        return new X86MemOpnd(dataSize, seg.size(), -1, null, null, offs, seg);
    }
}

