/*
 * Decompiled with CFR 0.152.
 */
package bindis.x86.common;

import bindis.DecodeStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class X86InstructionPrefixes {
    private static final Map<Integer, Prefix> ords = new HashMap<Integer, Prefix>();
    private static final int $OPNDSZ = 102;
    private static final int $REPNZ = 242;
    private static final int $REPZ = 243;
    private static final int $LOCK = 240;
    private static final int $ADDRSZ = 103;
    private static final int $FWAIT = 155;
    private static final int $CS = 46;
    private static final int $SS = 54;
    private static final int $DS = 62;
    private static final int $ES = 38;
    private static final int $FS = 100;
    private static final int $GS = 101;
    private static final int $REXW = 72;
    private static final int $REXR = 68;
    private static final int $REXX = 66;
    private static final int $REXB = 65;
    private static final int $REXPrefixLow = 65;
    private static final int $REXPrefixHigh = 79;
    public static final Prefix OPNDSZ = new SingleByteExactPrefix(102);
    public static final Prefix REPNZ = new SingleByteExactPrefix(242);
    public static final Prefix REPZ = new SingleByteExactPrefix(243);
    public static final Prefix LOCK = new SingleByteExactPrefix(240);
    public static final Prefix ADDRSZ = new SingleByteExactPrefix(103);
    public static final Prefix FWAIT = new SingleByteExactPrefix(155);
    public static final Prefix CS = new SingleByteExactPrefix(46);
    public static final Prefix SS = new SingleByteExactPrefix(54);
    public static final Prefix DS = new SingleByteExactPrefix(62);
    public static final Prefix ES = new SingleByteExactPrefix(38);
    public static final Prefix FS = new SingleByteExactPrefix(100);
    public static final Prefix GS = new SingleByteExactPrefix(101);
    public static final Prefix REXW = new REXPrefix(72);
    public static final Prefix REXR = new REXPrefix(68);
    public static final Prefix REXX = new REXPrefix(66);
    public static final Prefix REXB = new REXPrefix(65);
    private final Set<Prefix> prefixes = new HashSet<Prefix>();

    private X86InstructionPrefixes() {
    }

    public boolean contains(Prefix p) {
        return this.prefixes.contains(p);
    }

    public static X86InstructionPrefixes decode64(DecodeStream in) {
        throw new UnsupportedOperationException();
    }

    private static boolean isRexPrefix(int value, int ord) {
        return (value & ord) == ord;
    }

    private void addPrefix(Prefix prefix) {
        this.prefixes.add(prefix);
    }

    public static X86InstructionPrefixes decode32(DecodeStream in) {
        throw new UnsupportedOperationException();
    }

    public boolean isEmpty() {
        return this.prefixes.isEmpty();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        Iterator<Prefix> it = this.prefixes.iterator();
        while (it.hasNext()) {
            Prefix prefix = it.next();
            builder.append(prefix);
            if (!it.hasNext()) continue;
            builder.append(", ");
        }
        builder.append('}');
        return builder.toString();
    }

    public static class REXPrefix
    extends Prefix {
        private final int ord;

        public REXPrefix(int ord) {
            this.ord = ord;
        }

        @Override
        public boolean decode(DecodeStream in, X86InstructionPrefixes prefixes) {
            int value = in.peek8();
            if (REXPrefix.inRange(value) && (value & this.ord) == this.ord) {
                prefixes.addPrefix(this);
                return true;
            }
            return false;
        }

        private static boolean inRange(int value) {
            return value >= 65 && value <= 79;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof REXPrefix)) {
                return false;
            }
            REXPrefix other = (REXPrefix)obj;
            return this.ord == other.ord;
        }

        @Override
        public int hashCode() {
            return this.ord;
        }
    }

    public static class SingleByteExactPrefix
    extends Prefix {
        private final int ord;

        public SingleByteExactPrefix(int ord) {
            this.ord = ord;
        }

        @Override
        public boolean decode(DecodeStream in, X86InstructionPrefixes prefixes) {
            int value = in.peek8();
            if (value == this.ord) {
                prefixes.addPrefix(this);
                return true;
            }
            return false;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof SingleByteExactPrefix)) {
                return false;
            }
            SingleByteExactPrefix other = (SingleByteExactPrefix)obj;
            return this.ord == other.ord;
        }

        @Override
        public int hashCode() {
            return this.ord;
        }
    }

    public static abstract class Prefix {
        public abstract boolean decode(DecodeStream var1, X86InstructionPrefixes var2);

        public abstract boolean equals(Object var1);

        public abstract int hashCode();
    }
}

