/*
 * Decompiled with CFR 0.152.
 */
package bindis.x86.common;

import bindis.OperandKind;
import bindis.x86.common.X86Operand;
import bindis.x86.common.X86OperandVisitor;

public class X86ImmOpnd
extends X86Operand {
    protected final Number imm;

    public X86ImmOpnd(int size, Number imm) {
        super(size, OperandKind.IMM);
        this.imm = imm;
    }

    @Override
    public StringBuilder asString(StringBuilder buf) {
        switch (this.size) {
            case 8: {
                buf.append(Long.toHexString(this.imm.byteValue()));
                break;
            }
            case 16: {
                buf.append(Long.toHexString(this.imm.shortValue()));
                break;
            }
            case 32: {
                buf.append(Long.toHexString(this.imm.intValue()));
                break;
            }
            default: {
                buf.append(Long.toHexString(this.imm.longValue()));
            }
        }
        return buf;
    }

    @Override
    public <R, T> R accept(X86OperandVisitor<R, T> visitor, T data) {
        return visitor.visit(this, data);
    }

    public Number imm() {
        return this.imm;
    }
}

