/*
 * Decompiled with CFR 0.152.
 */
package bindis.avr8.decoders;

import bindis.NativeInstruction;
import bindis.avr8.AVRDecodeCtx;
import bindis.avr8.AVROpnd;
import bindis.avr8.decoders.InsnDecoder;
import bindis.avr8.decoders.NestedDecoder;
import bindis.avr8.decoders.OpcodeTables;
import bindis.avr8.decoders.OpndDecoder;
import bindis.avr8.decoders.Slice;

public final class Decode {
    public static final Decode INSTANCE = new Decode();

    public static InsnDecoder decodeGroup(final int groupIdx) {
        return new NestedDecoder(null){

            @Override
            protected InsnDecoder lookupDecoder(AVRDecodeCtx ctx) {
                int subgroupIdx = Slice.S2.slice(ctx.getInsnWord());
                return OpcodeTables.groupTable[groupIdx][subgroupIdx];
            }
        };
    }

    public static InsnDecoder decodeOverlayGroup(final int groupIdx, final Slice slice) {
        return new NestedDecoder(null){

            @Override
            protected InsnDecoder lookupDecoder(AVRDecodeCtx ctx) {
                int subgroupIdx = slice.slice(ctx.getInsnWord());
                return OpcodeTables.overlayGroupTable[groupIdx][subgroupIdx];
            }
        };
    }

    public static InsnDecoder decode(String mnemonic) {
        return new InsnDecoder(mnemonic){

            @Override
            public NativeInstruction decodeInstruction(AVRDecodeCtx ctx) {
                return factory.make(this.mnemonic, ctx);
            }
        };
    }

    public static InsnDecoder decode(String mnemonic, final OpndDecoder decodeOp1, final OpndDecoder decodeOp2) {
        return new InsnDecoder(mnemonic){

            @Override
            public NativeInstruction decodeInstruction(AVRDecodeCtx ctx) {
                AVROpnd op1 = decodeOp1.decode(ctx);
                AVROpnd op2 = decodeOp2.decode(ctx);
                return factory.make(this.mnemonic, op1, op2, ctx);
            }
        };
    }

    public static InsnDecoder decode(String mnemonic, final OpndDecoder decodeOp1) {
        return new InsnDecoder(mnemonic){

            @Override
            public NativeInstruction decodeInstruction(AVRDecodeCtx ctx) {
                AVROpnd op1 = decodeOp1.decode(ctx);
                return factory.make(this.mnemonic, op1, ctx);
            }
        };
    }
}

