/*
 * Decompiled with CFR 0.152.
 */
package bindis;

import bindis.INativeInstruction;
import bindis.Operand;
import rreil.disassembler.OpcodeFormatter;

public abstract class NativeInstruction
implements INativeInstruction {
    private final long address;
    private final String mnemonic;
    private final byte[] opcode;
    private final Operand[] opnds;

    public NativeInstruction(long address, String mnemonic, byte[] opcode, Operand ... opnds) {
        Operand opnd;
        int cnt;
        this.mnemonic = mnemonic;
        this.opcode = opcode;
        this.address = address;
        for (cnt = 0; cnt < opnds.length && (opnd = opnds[cnt]) != null; ++cnt) {
        }
        this.opnds = new Operand[cnt];
        System.arraycopy(opnds, 0, this.opnds, 0, cnt);
    }

    @Override
    public String mnemonic() {
        return this.mnemonic;
    }

    @Override
    public byte[] opcode() {
        byte[] data = new byte[this.opcode.length];
        System.arraycopy(this.opcode, 0, data, 0, this.opcode.length);
        return data;
    }

    @Override
    public long address() {
        return this.address;
    }

    @Override
    public Operand operand(int idx) {
        return this.opnds[idx];
    }

    @Override
    public int numberOfOperands() {
        return this.opnds.length;
    }

    public Operand[] operands() {
        Operand[] data = new Operand[this.opnds.length];
        System.arraycopy(this.opnds, 0, data, 0, this.opnds.length);
        return data;
    }

    @Override
    public int length() {
        return this.opcode.length;
    }

    public String toString() {
        StringBuilder pretty = new StringBuilder();
        pretty.append('{');
        this.address(pretty).append(": ");
        this.opcode(pretty).append(" -- ");
        this.asString(pretty);
        return pretty.append('}').toString();
    }

    @Override
    public StringBuilder asString(StringBuilder pretty) {
        pretty.append(this.mnemonic());
        pretty.append(" ");
        for (int i = 0; i < this.opnds.length; ++i) {
            if (i != 0) {
                pretty.append(", ");
            }
            this.opnds[i].asString(pretty);
        }
        return pretty;
    }

    @Override
    public StringBuilder opcode(StringBuilder buf) {
        return OpcodeFormatter.format(this.opcode, buf);
    }

    @Override
    public StringBuilder address(StringBuilder buf) {
        buf.append(String.format("%08x", this.address));
        return buf;
    }
}

