/*
 * Decompiled with CFR 0.152.
 */
package bindis;

import bindis.IndexOutOfBoundsException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class DecodeStream {
    private final ByteBuffer data;
    private int idx;
    private int mark;

    public DecodeStream(byte[] data, int idx) {
        this.data = ByteBuffer.allocateDirect(data.length);
        this.data.mark();
        this.data.put(data);
        this.idx = idx;
        this.mark = idx;
        this.data.order(ByteOrder.LITTLE_ENDIAN);
    }

    public DecodeStream(byte[] data) {
        this(data, 0);
    }

    public void mark() {
        this.mark = this.idx;
    }

    public int previous8() {
        return this.get(this.idx - 1) & 0xFF;
    }

    public int consumed() {
        assert (this.idx >= this.mark) : "inconsistent mark and index";
        return this.idx - this.mark;
    }

    public int available() {
        return this.data.limit() - this.idx;
    }

    public int getIdx() {
        return this.idx;
    }

    public int getMark() {
        return this.mark;
    }

    public void resetToMark() {
        assert (this.mark >= 0) : "invalid mark";
        this.idx = this.mark;
    }

    public int read8() {
        int value = this.peek8();
        ++this.idx;
        return value;
    }

    public byte[] read(int length) {
        byte[] bytes = new byte[length];
        this.data.position(this.idx);
        this.data.get(bytes, 0, length);
        this.idx += length;
        return bytes;
    }

    public int peek8() {
        return this.get(this.idx) & 0xFF;
    }

    public byte raw8() {
        byte value = this.get(this.idx);
        ++this.idx;
        return value;
    }

    public short raw16() {
        short value = this.getShort(this.idx);
        this.idx += 2;
        return value;
    }

    public int raw32() {
        int value = this.getInt(this.idx);
        this.idx += 4;
        return value;
    }

    public long raw64() {
        long value = this.getLong(this.idx);
        this.idx += 8;
        return value;
    }

    public long read63() {
        return this.raw64();
    }

    public int read16() {
        return this.raw16() & 0xFFFF;
    }

    public int peek16() {
        return this.getShort(this.idx) & 0xFFFF;
    }

    public int read32() {
        int value = this.getInt(this.idx);
        this.idx += 4;
        return value;
    }

    public int peek32() {
        return this.getInt(this.idx);
    }

    public void order(ByteOrder ord) {
        this.data.order(ord);
    }

    public ByteBuffer getBuffer() {
        return this.data;
    }

    public byte[] slice() {
        int length = this.idx - this.mark;
        assert (length > 0) : "Invalid slice length";
        byte[] slice = new byte[length];
        for (int i = 0; i < slice.length; ++i) {
            slice[i] = this.data.get(this.mark + i);
        }
        return slice;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[pos=");
        sb.append(this.getIdx());
        sb.append(" lim=");
        sb.append(this.data.limit());
        sb.append("]");
        return sb.toString();
    }

    private byte get(int index) {
        try {
            return this.data.get(index);
        }
        catch (java.lang.IndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(index);
        }
    }

    private short getShort(int index) {
        try {
            return this.data.getShort(index);
        }
        catch (java.lang.IndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(index);
        }
    }

    private int getInt(int index) {
        try {
            return this.data.getInt(index);
        }
        catch (java.lang.IndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(index);
        }
    }

    private long getLong(int index) {
        try {
            return this.data.getLong(index);
        }
        catch (java.lang.IndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(index);
        }
    }
}

