/*
 * Decompiled with CFR 0.152.
 */
package bindead.environment.platform;

import bindead.analyses.Bootstrap;
import bindead.domainnetwork.interfaces.ContentCtx;
import bindead.domainnetwork.interfaces.RegionCtx;
import bindead.domainnetwork.interfaces.RootDomain;
import bindead.environment.platform.Platform;
import binparse.Segment;
import binparse.trace.TraceBinary;
import binparse.trace.TraceDump;
import java.util.Map;
import javalx.numeric.BigInt;
import rreil.lang.MemVar;
import rreil.lang.RReil;
import rreil.lang.RReilAddr;
import rreil.lang.lowlevel.LowLevelRReil;
import rreil.lang.lowlevel.LowLevelRReilFactory;
import rreil.lang.lowlevel.LowLevelRReilOpnd;

public class DynamicallyStartedPlatform
extends Platform {
    private final TraceDump trace;
    private final Platform platform;
    private MemVar stackRegionId;

    public DynamicallyStartedPlatform(TraceBinary binary, Platform platform) {
        super(platform.getDisassembler());
        this.trace = binary.getTraceDump();
        this.platform = platform;
    }

    @Override
    public Bootstrap forwardAnalysisBootstrap() {
        return new Bootstrap(){

            @Override
            public <D extends RootDomain<D>> D bootstrap(D state, long initialPC) {
                Segment stack = DynamicallyStartedPlatform.this.trace.getStack();
                state = DynamicallyStartedPlatform.this.introSegment(stack, state);
                Map<String, BigInt> registerValues = DynamicallyStartedPlatform.this.trace.getRegisters();
                for (Map.Entry<String, BigInt> register : registerValues.entrySet()) {
                    String registerName = register.getKey();
                    if (registerName.equals(DynamicallyStartedPlatform.this.platform.getStackPointer())) {
                        DynamicallyStartedPlatform.this.stackRegionId = MemVar.getVarOrFresh(stack.getName().get());
                        BigInt stackOffset = register.getValue().sub(stack.getAddress());
                        state = DynamicallyStartedPlatform.this.introRegisterWithPointerValue(registerName, DynamicallyStartedPlatform.this.stackRegionId, stackOffset, state);
                        continue;
                    }
                    if (registerName.equals("PC")) continue;
                    state = DynamicallyStartedPlatform.this.introRegisterWithValue(registerName, register.getValue(), state);
                }
                state = DynamicallyStartedPlatform.this.introSegment(DynamicallyStartedPlatform.this.trace.getHeap(), state);
                return state;
            }
        };
    }

    private <D extends RootDomain<D>> D introSegment(Segment segment, D state) {
        if (segment == null) {
            return (D)state;
        }
        BigInt address = BigInt.of(segment.getAddress());
        long size = segment.getSize();
        ContentCtx segmentCtx = new ContentCtx(segment.getNameOrAddress(), address, size, segment.getPermissions(), segment.getData(), segment.getEndianness());
        state = (RootDomain)state.introduceRegion(MemVar.fresh(segmentCtx.getName()), new RegionCtx(segmentCtx));
        state = (RootDomain)state.eval(String.format("prim fixAtConstantAddress(%s.%d)", segmentCtx.getName(), this.platform.defaultArchitectureSize()));
        return (D)state;
    }

    @Override
    public String getStackPointer() {
        return this.platform.getStackPointer();
    }

    @Override
    public String getInstructionPointer() {
        return this.platform.getInstructionPointer();
    }

    @Override
    public MemVar getStackRegion() {
        return this.stackRegionId;
    }

    private <D extends RootDomain<D>> D assignValueToRegister(String registerName, BigInt value, D domain) {
        LowLevelRReilOpnd register = this.platform.getDisassembler().translateIdentifier(registerName);
        LowLevelRReilFactory rreil = LowLevelRReilFactory.getInstance();
        LowLevelRReil stmt = rreil.MOV(RReilAddr.ZERO, register, rreil.immediate(register.size(), (Number)value.getValue()));
        domain = (RootDomain)domain.eval((RReil.Assign)stmt.toRReil());
        return domain;
    }

    private <D extends RootDomain<D>> D assignPointerToRegister(String registerName, MemVar pointsToRegionId, BigInt offset, D domain) {
        LowLevelRReilOpnd register = this.platform.getDisassembler().translateIdentifier(registerName);
        LowLevelRReilFactory rreil = LowLevelRReilFactory.getInstance();
        LowLevelRReil stmt = rreil.ADD(RReilAddr.ZERO, register, register, rreil.immediate(register.size(), (Number)offset.getValue()));
        domain = (RootDomain)domain.eval((RReil.Assign)stmt.toRReil());
        return domain;
    }

    private <D extends RootDomain<D>> D introRegisterWithValue(String registerName, BigInt value, D domain) {
        MemVar registerRegionId = MemVar.getVarOrFresh(registerName);
        domain = (RootDomain)domain.introduceRegion(registerRegionId, RegionCtx.EMPTYSTICKY);
        return this.assignValueToRegister(registerName, value, domain);
    }

    private <D extends RootDomain<D>> D introRegisterWithPointerValue(String registerName, MemVar pointsToRegionId, BigInt offset, D domain) {
        MemVar registerRegionId = MemVar.getVarOrFresh(registerName);
        domain = (RootDomain)domain.introduceRegion(registerRegionId, RegionCtx.EMPTYSTICKY);
        return this.assignPointerToRegister(registerName, pointsToRegionId, offset, domain);
    }
}

