/*
 * Decompiled with CFR 0.152.
 */
package bindead.environment.abi;

import bindead.domainnetwork.interfaces.RootDomain;
import bindead.environment.abi.ABI;
import bindead.environment.platform.Platform;
import java.util.Arrays;
import java.util.List;
import javalx.numeric.Range;
import rreil.lang.RReilAddr;
import rreil.lang.Rhs;

public class X32SysVAbi
extends ABI {
    public static final String CLIB_RETURN_REGISTER = "eax";
    private static final String[] SYSCALL_INPUT_REGISTERS = new String[]{"ebx", "ecx", "edx", "esi", "edi", "ebp"};
    private static final String SYSCALL_RET_REGISTER = "eax";
    private static final String SYSCALL_NR_REGISTER = "eax";
    private static final String tempReg = "tmpReg_" + X32SysVAbi.class.getSimpleName();

    public X32SysVAbi(Platform platform) {
        super(platform);
    }

    @Override
    public Rhs.Rvar getReturnParameterAllocation() {
        return this.getPlatform().getRegisterAsVariable("eax");
    }

    @Deprecated
    public Rhs.Rvar getFunctionParameterAllocation(int parameterNumber, RootDomain<?> state) {
        Platform platform = this.getPlatform();
        Range stackOffset = this.getCurrentStackOffset(state);
        if (!stackOffset.isConstant()) {
            throw new UnsupportedOperationException("Non-constant stack offset.");
        }
        int parameterOffset = (stackOffset.getConstantOrNull().intValue() + platform.defaultArchitectureSize() / 8 * parameterNumber + 4) * 8;
        return new Rhs.Rvar(platform.defaultArchitectureSize(), parameterOffset, platform.getStackRegion());
    }

    @Override
    public Range getFunctionParameterValue(int parameterNumber, RootDomain<?> domainState) {
        RootDomain<?> state = domainState;
        state = this.assignFunctionParameterToRegister(parameterNumber, tempReg, state);
        Range value = this.getValueOf(tempReg, state);
        return value;
    }

    @Override
    public <D extends RootDomain<D>> D assignFunctionParameterToRegister(int parameterNumber, String reg, D domainState) {
        String sp = this.getPlatform().getStackPointer();
        int size = this.getPlatform().defaultArchitectureSize();
        int parameterOffset = size / 8 * parameterNumber + 4;
        String[] insns = new String[]{this.add(tempReg, sp, parameterOffset), this.load(reg, tempReg)};
        return (D)((RootDomain)domainState.eval(insns));
    }

    @Override
    public <D extends RootDomain<D>> D setRegisterAsReturnValue(String reg, D domainState) {
        return (D)((RootDomain)domainState.eval(this.mov("eax", reg)));
    }

    @Override
    public RReilAddr getReturnAddress(RootDomain<?> domainState) {
        String sp = this.getPlatform().getStackPointer();
        RootDomain state = domainState;
        Range returnAddress = this.getValueOf(tempReg, state = (RootDomain)state.eval(this.load(tempReg, sp)));
        if (!returnAddress.isConstant()) {
            throw new UnsupportedOperationException("Non-constant return address.");
        }
        return RReilAddr.valueOf(returnAddress.getConstantOrNull());
    }

    @Override
    public List<String> getSyscallInputRegisterNames() {
        return Arrays.asList(SYSCALL_INPUT_REGISTERS);
    }

    @Override
    public String getSyscallNrRegisterName() {
        return "eax";
    }

    @Override
    public String getSyscallReturnRegisterName() {
        return "eax";
    }
}

