/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.wrapping;

import bindead.abstractsyntax.finite.Finite;
import bindead.abstractsyntax.finite.FiniteExprVisitor;
import bindead.abstractsyntax.zeno.Zeno;
import bindead.abstractsyntax.zeno.ZenoFactory;
import bindead.data.Linear;
import bindead.data.NumVar;
import bindead.domainnetwork.channels.QueryChannel;
import bindead.domainnetwork.combinators.ZenoStateBuilder;
import bindead.domains.wrapping.WrappingBinOpVisitor;
import bindead.exceptions.DomainStateException;
import javalx.numeric.BigInt;
import javalx.numeric.Bound;
import javalx.numeric.Interval;
import javalx.numeric.Range;

public class WrappingStateBuilder
extends ZenoStateBuilder
implements FiniteExprVisitor<Linear, WrapInfo> {
    static final ZenoFactory zeno = ZenoFactory.getInstance();
    private final QueryChannel state;
    private final NumVar[] tempVars = new NumVar[]{NumVar.getSingleton("wrapTmpOne"), NumVar.getSingleton("wrapTmpTwo")};
    private int lastTemp = 0;

    WrappingStateBuilder(QueryChannel state) {
        this.state = state;
    }

    NumVar getTemp() {
        assert (this.lastTemp < this.tempVars.length);
        return this.tempVars[this.lastTemp++];
    }

    private void killTemps() {
        while (this.lastTemp > 0) {
            this.getChildOps().addKill(this.tempVars[--this.lastTemp]);
        }
    }

    public NumVar assignToTemp(Zeno.Rhs rhs) {
        NumVar var = this.getTemp();
        this.getChildOps().addAssignment(zeno.assign(zeno.variable(var), rhs));
        return var;
    }

    private void doPointTest(Finite.Test test, Zeno.ZenoTestOp op) {
        NumVar var;
        int size = test.getSize();
        if (size == 0) {
            Linear expr = test.toLinear();
            this.getChildOps().addTest(zeno.comparison(expr, op));
            return;
        }
        Interval uTop = Interval.unsignedTop(size);
        Interval sTop = Interval.signedTop(size);
        Linear lLin = test.getLeftExpr();
        Linear rLin = test.getRightExpr();
        Interval lRange = this.state.queryRange(lLin).convexHull();
        Interval rRange = this.state.queryRange(rLin).convexHull();
        BigInt lSpan = lRange.getSpan();
        BigInt rSpan = rRange.getSpan();
        BigInt width = uTop.getSpan();
        if (lSpan == null || width.isLessThan(lSpan)) {
            lSpan = width;
            lRange = sTop.contains(rRange) && rRange.hasNegativeValues() ? sTop : uTop;
            var = this.linearToVar(lLin);
            this.getChildOps().addAssignment(zeno.assign(zeno.variable(var), zeno.range(Range.from(lRange))));
            lLin = Linear.linear(var);
        }
        if (rSpan == null || width.isLessThan(rSpan)) {
            rSpan = width;
            rRange = sTop.contains(lRange) && lRange.hasNegativeValues() ? sTop : uTop;
            var = this.linearToVar(lLin);
            this.getChildOps().addAssignment(zeno.assign(zeno.variable(var), zeno.range(Range.from(rRange))));
            lLin = Linear.linear(var);
        }
        BigInt diff = lRange.low().asInteger().sub(rRange.low().asInteger());
        BigInt shift = diff.abs().divRoundDown(width).mul(width).mul(diff.sign());
        rRange = rRange.add(shift);
        rLin = rLin.add(shift);
        boolean applicable = lRange.low().isLessThan(rRange.low()) ? rRange.high().asInteger().isLessThan(lRange.low().asInteger().add(width)) : lRange.high().asInteger().isLessThan(rRange.low().asInteger().add(width));
        if (!applicable) {
            return;
        }
        Linear t = lLin.sub(rLin);
        this.getChildOps().addTest(zeno.comparison(t, op));
        this.getChildOps().hoist();
    }

    private void doRelationalTest(Finite.Test test, WrapInfo wi, BigInt slack, Zeno.ZenoTestOp op) {
        Linear lLin = this.wrapLinear(test.getLeftExpr(), wi);
        Linear rLin = this.wrapLinear(test.getRightExpr(), wi);
        Linear t = lLin.sub(rLin).add(slack);
        this.getChildOps().addTest(zeno.comparison(t, op));
        this.getChildOps().hoist();
    }

    void runTest(Finite.Test test) {
        switch (test.getOperator()) {
            case Equal: {
                this.doPointTest(test, Zeno.ZenoTestOp.EqualToZero);
                break;
            }
            case NotEqual: {
                this.doPointTest(test, Zeno.ZenoTestOp.NotEqualToZero);
                break;
            }
            case SignedLessThan: {
                this.doRelationalTest(test, WrapInfo.signed(test.getSize()), Bound.ONE, Zeno.ZenoTestOp.LessThanOrEqualToZero);
                break;
            }
            case SignedLessThanOrEqual: {
                this.doRelationalTest(test, WrapInfo.signed(test.getSize()), Bound.ZERO, Zeno.ZenoTestOp.LessThanOrEqualToZero);
                break;
            }
            case UnsignedLessThan: {
                this.doRelationalTest(test, WrapInfo.unsigned(test.getSize()), Bound.ONE, Zeno.ZenoTestOp.LessThanOrEqualToZero);
                break;
            }
            case UnsignedLessThanOrEqual: {
                this.doRelationalTest(test, WrapInfo.unsigned(test.getSize()), Bound.ZERO, Zeno.ZenoTestOp.LessThanOrEqualToZero);
                break;
            }
        }
        this.killTemps();
    }

    void runAssign(Finite.Assign stmt, WrappingStateBuilder builder) {
        if (stmt.getRhs() instanceof Finite.Cmp) {
            Zeno.RangeRhs top = zeno.range(Interval.BOOLEANTOP);
            Zeno.Assign assign = zeno.assign(zeno.variable(stmt.getLhs().getId()), top);
            builder.getChildOps().addAssignment(assign);
        } else {
            Linear rhs = stmt.getRhs().accept(this, WrapInfo.noWrap);
            NumVar resVar = rhs.getSingleVarOrNull();
            if (resVar == null || !resVar.equalTo(stmt.getLhs().getId())) {
                Zeno.Assign assign = zeno.assign(zeno.variable(stmt.getLhs().getId()), zeno.linear(rhs));
                builder.getChildOps().addAssignment(assign);
            }
        }
        builder.getChildOps().hoist();
        this.killTemps();
    }

    @Override
    public Linear visit(Finite.Bin expr, WrapInfo wi) {
        WrappingBinOpVisitor binOpVisitor = new WrappingBinOpVisitor(this);
        return (Linear)binOpVisitor.visit(expr);
    }

    @Override
    public Linear visit(Finite.SignExtend expr, WrapInfo wi) {
        int rhsSize = expr.getExpr().getSize();
        return expr.getExpr().accept(this, WrapInfo.signed(rhsSize));
    }

    @Override
    public Linear visit(Finite.Convert expr, WrapInfo wi) {
        int rhsSize = expr.getExpr().getSize();
        if (wi.getSize() > rhsSize) {
            return expr.getExpr().accept(this, WrapInfo.unsigned(rhsSize));
        }
        return expr.getExpr().accept(this, WrapInfo.noWrap);
    }

    @Override
    public Linear visit(Finite.FiniteRangeRhs expr, WrapInfo wi) {
        if (expr.getRange().isConstant()) {
            return Linear.linear(expr.getRange().getConstant());
        }
        NumVar var = this.assignToTemp(zeno.range(expr.getRange()));
        if (wi.useZenoSemantics() || wi.getInterval().contains(expr.getRange())) {
            return Linear.linear(var);
        }
        this.getChildOps().addWrap(var, wi.getInterval(), wi.saturated);
        return Linear.linear(var);
    }

    private Linear wrapLinear(Linear linear, WrapInfo wi) {
        BigInt con;
        if (wi.useZenoSemantics()) {
            return linear;
        }
        Interval wrappingRange = wi.getInterval();
        BigInt bigInt = con = linear.isConstantOnly() ? linear.getConstant() : null;
        if (con != null) {
            if (!wrappingRange.contains(con)) {
                BigInt diff = wrappingRange.high().asInteger().sub(con);
                BigInt width = wrappingRange.getSpan();
                BigInt shift = diff.div(width).mul(width);
                linear = linear.add(shift);
            }
        } else {
            Interval value = this.state.queryRange(linear).convexHull();
            if (!wrappingRange.contains(value)) {
                NumVar var = this.linearToVar(linear);
                this.getChildOps().addWrap(var, wrappingRange, wi.saturated);
                linear = Linear.linear(var);
            }
        }
        return linear;
    }

    private NumVar linearToVar(Linear lin) {
        NumVar var = lin.getSingleVarOrNull();
        if (var == null) {
            var = this.assignToTemp(zeno.linear(lin));
        }
        return var;
    }

    @Override
    public Linear visit(Finite.Rlin expr, WrapInfo wi) {
        return this.wrapLinear(expr.getLinearTerm(), wi);
    }

    @Override
    public Linear visit(Finite.Cmp expr, WrapInfo data) {
        throw new DomainStateException.UnimplementedMethodException("finite comparison must be caught in the assignment");
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Childops: " + this.getChildOps());
        return builder.toString();
    }

    public static class WrapInfo {
        boolean saturated = false;
        int size = 0;
        public static WrapInfo noWrap = WrapInfo.unsigned(0);

        private WrapInfo(boolean saturated, int size) {
            this.saturated = saturated;
            this.size = size;
        }

        public static WrapInfo unsigned(boolean saturated, int size) {
            return new WrapInfo(saturated, size);
        }

        public static WrapInfo unsigned(int size) {
            return new WrapInfo(false, size);
        }

        public static WrapInfo signed(boolean saturated, int size) {
            return new WrapInfo(saturated, -size);
        }

        public static WrapInfo signed(int size) {
            return new WrapInfo(false, -size);
        }

        public boolean useZenoSemantics() {
            return this.size == 0;
        }

        public Interval getInterval() {
            if (this.size < 0) {
                return Interval.signedTop(-this.size);
            }
            if (this.size > 0) {
                return Interval.unsignedTop(this.size);
            }
            return null;
        }

        public int getSize() {
            return Math.abs(this.size);
        }
    }
}

