/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.wrapping;

import bindead.abstractsyntax.finite.Finite;
import bindead.abstractsyntax.finite.FiniteBinOpVisitor;
import bindead.abstractsyntax.zeno.Zeno;
import bindead.data.Linear;
import bindead.data.NumVar;
import bindead.domains.wrapping.WrappingStateBuilder;

class WrappingBinOpVisitor
extends FiniteBinOpVisitor<Linear> {
    private final WrappingStateBuilder builder;

    public WrappingBinOpVisitor(WrappingStateBuilder builder) {
        this.builder = builder;
    }

    @Override
    protected Linear visitAdd(Finite.Rlin left, Finite.Rlin right) {
        Linear l = left.accept(this.builder, WrappingStateBuilder.WrapInfo.noWrap);
        Linear r = right.accept(this.builder, WrappingStateBuilder.WrapInfo.noWrap);
        return l.add(r);
    }

    @Override
    protected Linear visitAnd(Finite.Rlin left, Finite.Rlin right) {
        WrappingStateBuilder.WrapInfo wi = WrappingStateBuilder.WrapInfo.unsigned(left.getSize());
        Linear l = left.accept(this.builder, wi);
        Linear r = right.accept(this.builder, wi);
        NumVar res = this.builder.getTemp();
        this.builder.getChildOps().addAnd(res, l, r, left.getSize());
        return Linear.linear(res);
    }

    @Override
    protected Linear visitDiv(Finite.Rlin left, Finite.Rlin right) {
        WrappingStateBuilder.WrapInfo wi = WrappingStateBuilder.WrapInfo.unsigned(left.getSize());
        Linear l = left.accept(this.builder, wi);
        Linear r = right.accept(this.builder, wi);
        return Linear.linear(this.builder.assignToTemp(WrappingStateBuilder.zeno.binary(WrappingStateBuilder.zeno.linear(l), Zeno.ZenoBinOp.Div, WrappingStateBuilder.zeno.linear(r))));
    }

    @Override
    protected Linear visitDivs(Finite.Rlin left, Finite.Rlin right) {
        WrappingStateBuilder.WrapInfo wi = WrappingStateBuilder.WrapInfo.signed(left.getSize());
        Linear l = left.accept(this.builder, wi);
        Linear r = right.accept(this.builder, wi);
        return Linear.linear(this.builder.assignToTemp(WrappingStateBuilder.zeno.binary(WrappingStateBuilder.zeno.linear(l), Zeno.ZenoBinOp.Div, WrappingStateBuilder.zeno.linear(r))));
    }

    @Override
    protected Linear visitMod(Finite.Rlin left, Finite.Rlin right) {
        WrappingStateBuilder.WrapInfo wi = WrappingStateBuilder.WrapInfo.unsigned(left.getSize());
        Linear l = left.accept(this.builder, wi);
        Linear r = right.accept(this.builder, wi);
        return Linear.linear(this.builder.assignToTemp(WrappingStateBuilder.zeno.binary(WrappingStateBuilder.zeno.linear(l), Zeno.ZenoBinOp.Mod, WrappingStateBuilder.zeno.linear(r))));
    }

    @Override
    protected Linear visitMul(Finite.Rlin left, Finite.Rlin right) {
        WrappingStateBuilder.WrapInfo wi = WrappingStateBuilder.WrapInfo.unsigned(left.getSize());
        Linear r = right.accept(this.builder, wi);
        if (r.isConstantOnly()) {
            return Linear.linear(this.builder.assignToTemp(WrappingStateBuilder.zeno.linear(left.getLinearTerm().smul(r.getConstant()))));
        }
        Linear l = left.accept(this.builder, wi);
        if (l.isConstantOnly()) {
            return Linear.linear(this.builder.assignToTemp(WrappingStateBuilder.zeno.linear(right.getLinearTerm().smul(l.getConstant()))));
        }
        return Linear.linear(this.builder.assignToTemp(WrappingStateBuilder.zeno.binary(WrappingStateBuilder.zeno.linear(l), Zeno.ZenoBinOp.Mul, WrappingStateBuilder.zeno.linear(r))));
    }

    @Override
    protected Linear visitOr(Finite.Rlin left, Finite.Rlin right) {
        WrappingStateBuilder.WrapInfo wi = WrappingStateBuilder.WrapInfo.unsigned(left.getSize());
        Linear l = left.accept(this.builder, wi);
        Linear r = right.accept(this.builder, wi);
        NumVar res = this.builder.getTemp();
        this.builder.getChildOps().addOr(res, l, r, left.getSize());
        return Linear.linear(res);
    }

    @Override
    protected Linear visitShl(Finite.Rlin left, Finite.Rlin right) {
        WrappingStateBuilder.WrapInfo wi = WrappingStateBuilder.WrapInfo.unsigned(left.getSize());
        WrappingStateBuilder.WrapInfo satWi = WrappingStateBuilder.WrapInfo.unsigned(true, Integer.highestOneBit(right.getSize()));
        Linear l = left.accept(this.builder, wi);
        Linear r = right.accept(this.builder, satWi);
        return Linear.linear(this.builder.assignToTemp(WrappingStateBuilder.zeno.binary(WrappingStateBuilder.zeno.linear(l), Zeno.ZenoBinOp.Shl, WrappingStateBuilder.zeno.linear(r))));
    }

    @Override
    protected Linear visitShr(Finite.Rlin left, Finite.Rlin right) {
        WrappingStateBuilder.WrapInfo wi = WrappingStateBuilder.WrapInfo.unsigned(left.getSize());
        WrappingStateBuilder.WrapInfo satWi = WrappingStateBuilder.WrapInfo.unsigned(true, Integer.highestOneBit(right.getSize()));
        Linear l = left.accept(this.builder, wi);
        Linear r = right.accept(this.builder, satWi);
        return Linear.linear(this.builder.assignToTemp(WrappingStateBuilder.zeno.binary(WrappingStateBuilder.zeno.linear(l), Zeno.ZenoBinOp.Shr, WrappingStateBuilder.zeno.linear(r))));
    }

    @Override
    protected Linear visitShrs(Finite.Rlin left, Finite.Rlin right) {
        WrappingStateBuilder.WrapInfo wi = WrappingStateBuilder.WrapInfo.signed(left.getSize());
        WrappingStateBuilder.WrapInfo satWi = WrappingStateBuilder.WrapInfo.unsigned(true, Integer.highestOneBit(right.getSize()));
        Linear l = left.accept(this.builder, wi);
        Linear r = right.accept(this.builder, satWi);
        return Linear.linear(this.builder.assignToTemp(WrappingStateBuilder.zeno.binary(WrappingStateBuilder.zeno.linear(l), Zeno.ZenoBinOp.Shr, WrappingStateBuilder.zeno.linear(r))));
    }

    @Override
    protected Linear visitSub(Finite.Rlin left, Finite.Rlin right) {
        Linear l = left.accept(this.builder, WrappingStateBuilder.WrapInfo.noWrap);
        Linear r = right.accept(this.builder, WrappingStateBuilder.WrapInfo.noWrap);
        return l.sub(r);
    }

    @Override
    protected Linear visitXor(Finite.Rlin left, Finite.Rlin right) {
        if (left.getLinearTerm().equals(right.getLinearTerm())) {
            return Linear.ZERO;
        }
        WrappingStateBuilder.WrapInfo wi = WrappingStateBuilder.WrapInfo.unsigned(left.getSize());
        Linear l = left.accept(this.builder, wi);
        Linear r = right.accept(this.builder, wi);
        NumVar res = this.builder.getTemp();
        this.builder.getChildOps().addXOr(res, l, r, left.getSize());
        return Linear.linear(res);
    }
}

