/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.widening.thresholds;

import bindead.abstractsyntax.zeno.Zeno;
import bindead.abstractsyntax.zeno.ZenoFactory;
import bindead.abstractsyntax.zeno.util.ZenoTestHelper;
import bindead.analyses.algorithms.AnalysisProperties;
import bindead.data.FoldMap;
import bindead.data.Linear;
import bindead.data.NumVar;
import bindead.data.VarPair;
import bindead.data.VarSet;
import bindead.domainnetwork.channels.QueryChannel;
import bindead.domainnetwork.channels.SetOfEquations;
import bindead.domainnetwork.combinators.ZenoStateBuilder;
import bindead.domainnetwork.interfaces.ProgramPoint;
import bindead.domainnetwork.interfaces.ZenoDomain;
import bindead.domains.affine.Substitution;
import bindead.domains.widening.thresholds.Threshold;
import bindead.domains.widening.thresholds.ThresholdsWideningState;
import bindead.exceptions.DomainStateException;
import bindead.exceptions.Unreachable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.data.products.P3;
import javalx.numeric.Bound;
import javalx.persistentcollections.AVLSet;

class ThresholdsWideningStateBuilder<D extends ZenoDomain<D>>
extends ZenoStateBuilder {
    private static ZenoFactory zeno = ZenoFactory.getInstance();
    private ThresholdsWideningState.MutableState thresholds;

    public ThresholdsWideningStateBuilder(ThresholdsWideningState state) {
        this.thresholds = state.mutableCopy();
    }

    public ThresholdsWideningState build() {
        return this.thresholds.immutableCopy();
    }

    protected D collectThresholds(Option<ProgramPoint> currentLocation, Zeno.Test test, D state) {
        D newState;
        if (ZenoTestHelper.isTautologyReportUnreachable(test)) {
            if (AnalysisProperties.INSTANCE.debugTests.isTrue().booleanValue()) {
                System.out.println("Thresholds swallows test: " + test);
            }
            return state;
        }
        if (test.getOperator() == Zeno.ZenoTestOp.NotEqualToZero || test.getOperator() == Zeno.ZenoTestOp.EqualToZero) {
            if (AnalysisProperties.INSTANCE.debugTests.isTrue().booleanValue()) {
                System.out.println("Thresholds splits test: " + test);
            }
            P2<Zeno.Test, Zeno.Test> tests = test.splitEquality();
            this.collect(currentLocation, tests._1(), state);
            this.collect(currentLocation, tests._2(), state);
            return state.eval(test);
        }
        if (AnalysisProperties.INSTANCE.debugTests.isTrue().booleanValue()) {
            System.out.println("Thresholds test: " + test);
        }
        if ((newState = this.collect(currentLocation, test, state)) != null) {
            return newState;
        }
        return state.eval(test);
    }

    private static boolean isInterestingAsThreshold(Zeno.Test test) {
        for (NumVar var : test.getVars()) {
            if (var.isFlag()) continue;
            return true;
        }
        return false;
    }

    private D collect(Option<ProgramPoint> currentLocation, Zeno.Test test, D state) {
        assert (test.getOperator() != Zeno.ZenoTestOp.NotEqualToZero && test.getOperator() != Zeno.ZenoTestOp.EqualToZero);
        if (!ThresholdsWideningStateBuilder.isInterestingAsThreshold(test)) {
            return null;
        }
        Threshold threshold = currentLocation.isSome() ? new Threshold(currentLocation.get(), test) : new Threshold(ThresholdsWideningState.zeroPoint, test);
        P2<Boolean, D> result = this.isRedundant(test, state);
        if (result._1().booleanValue()) {
            this.thresholds.add(threshold);
        }
        return (D)((ZenoDomain)result._2());
    }

    private P2<Boolean, D> isRedundant(Zeno.Test test, D state) {
        try {
            Object newState = state.eval(test);
            boolean redundant = state.subsetOrEqual(newState);
            return P2.tuple2(redundant, newState);
        }
        catch (Unreachable _) {
            return P2.tuple2(false, null);
        }
    }

    private P2<Boolean, D> isRedundantwithQuery(Zeno.Test test, D state) {
        if (ZenoTestHelper.isAlwaysSatisfiable(test, state)) {
            return P2.tuple2(true, state.eval(test));
        }
        return P2.tuple2(false, null);
    }

    private P2<Boolean, D> isRedundantWithNegatedTest(Zeno.Test test, D state) {
        Zeno.Test opposingTest = test.not();
        try {
            state.eval(opposingTest);
        }
        catch (Unreachable _) {
            Object newState = state.eval(test);
            return P2.tuple2(true, newState);
        }
        return P2.tuple2(false, null);
    }

    protected void expand(FoldMap pairs) {
        for (Threshold threshold : this.thresholds.getTresholdsContainingAnyOf(pairs.getAllVars())) {
            Zeno.Test test = threshold.getTest();
            Linear lin = test.getExpr();
            Linear renamed = lin.renameVar(pairs);
            if (renamed == null) continue;
            Zeno.Test newTest = zeno.comparison(renamed, test.getOperator());
            this.thresholds.add(threshold.withTest(newTest), this.thresholds.getTransformations(threshold));
        }
    }

    protected void fold(FoldMap pairs) {
        HashSet<Threshold> permanentSet = new HashSet<Threshold>();
        HashSet<Threshold> ephemeralSet = new HashSet<Threshold>();
        ThresholdsWideningState.MutableState addedSet = ThresholdsWideningState.EMPTY.mutableCopy();
        HashSet<Threshold> removeSet = new HashSet<Threshold>();
        for (Threshold threshold : this.thresholds.getTresholdsContainingAnyOf(pairs.getAllVars())) {
            Zeno.Test test = threshold.getTest();
            Linear lin = test.getExpr();
            VarSet vars = lin.getVars();
            boolean hasEphemeral = false;
            boolean hasPermanent = false;
            for (VarPair pair : pairs) {
                if (vars.contains((NumVar)pair.getEphemeral())) {
                    hasEphemeral = true;
                }
                if (!vars.contains((NumVar)pair.getPermanent())) continue;
                hasPermanent = true;
            }
            if (hasEphemeral || hasPermanent) {
                removeSet.add(threshold);
            }
            if (hasEphemeral && hasPermanent) continue;
            if (hasPermanent) {
                permanentSet.add(threshold);
                addedSet.add(threshold, this.thresholds.getTransformations(threshold));
            }
            if (!hasEphemeral) continue;
            Zeno.Test newTest = zeno.comparison(test.getExpr().renameVar(pairs), test.getOperator());
            Threshold newThreshold = threshold.withTest(newTest);
            ephemeralSet.add(newThreshold);
            addedSet.add(newThreshold, this.thresholds.getTransformations(threshold));
        }
        for (Threshold threshold : removeSet) {
            this.thresholds.remove(threshold);
        }
        permanentSet.retainAll(ephemeralSet);
        for (Threshold threshold : permanentSet) {
            this.thresholds.add(threshold, addedSet.getTransformations(threshold));
        }
    }

    protected void copyAndPaste(VarSet vars, ThresholdsWideningState otherState) {
        ThresholdsWideningStateBuilder<D> otherBuilder = new ThresholdsWideningStateBuilder<D>(otherState);
        for (Threshold threshold : otherBuilder.thresholds.getTresholdsContainingAnyOf(vars)) {
            Zeno.Test test = threshold.getTest();
            if (!vars.containsAll(test.getExpr().getVars())) continue;
            this.thresholds.add(threshold, otherBuilder.thresholds.getTransformations(threshold));
        }
    }

    protected void substitute(NumVar x, NumVar y) {
        Substitution sigma = new Substitution(x, Linear.linear(y), Bound.ONE);
        this.applySubstitutionToAll(x, sigma, ProgramPoint.nowhere);
    }

    protected void removeThresholdsContaining(NumVar var, D state, Option<ProgramPoint> location) {
        AVLSet<Substitution> subsititions = ThresholdsWideningStateBuilder.generateSubstitutionsFor(var, state);
        if (!subsititions.isEmpty()) {
            this.applySubstitutionToAll(var, subsititions.getMin().get(), location);
        }
        for (Threshold threshold : this.thresholds.getTresholdsContaining(var)) {
            this.thresholds.remove(threshold);
        }
    }

    private void applySubstitutionToAll(NumVar var, Substitution sigma, Option<ProgramPoint> location) {
        for (Threshold threshold : this.thresholds.getTresholdsContaining(var)) {
            if (location.isSome() && this.thresholds.getTransformations(threshold).contains(location.get())) continue;
            Zeno.Test test = threshold.getTest();
            Zeno.Test newTest = test.applySubstitution(sigma);
            if (ZenoTestHelper.isTautology(newTest)) {
                this.thresholds.remove(threshold);
                continue;
            }
            Threshold newThreshold = threshold.withTest(newTest);
            this.thresholds.substitute(threshold, newThreshold);
            if (!location.isSome()) continue;
            this.thresholds.markTransformedAt(newThreshold, location.get());
        }
    }

    protected void applyAffineTransformation(NumVar lhs, Zeno.Rlin rhs, D state, Option<ProgramPoint> location) {
        if (rhs.getVars().contains(lhs)) {
            Substitution subst = Substitution.invertingSubstitution(rhs.getLinearTerm(), rhs.getDivisor(), lhs);
            this.applySubstitutionToAll(lhs, subst, location);
        } else {
            this.removeThresholdsContaining(lhs, state, location);
        }
    }

    private void generateNewPredicates(Linear newEq, Option<ProgramPoint> location) {
        for (Threshold threshold : this.thresholds.getTresholdsContainingAnyOf(newEq.getVars())) {
            Zeno.Test test = threshold.getTest();
            Linear testExpr = test.getExpr();
            VarSet vars = testExpr.getVars();
            for (NumVar var : vars) {
                Substitution sigma = newEq.genSubstitutionOrNull(var);
                if (sigma == null) continue;
                Zeno.Test newTest = test.applySubstitution(sigma);
                if (!this.thresholds.contains(threshold)) continue;
                Threshold newThreshold = threshold.withTest(newTest);
                this.thresholds.substitute(threshold, newThreshold);
                if (!location.isSome()) continue;
                this.thresholds.markTransformedAt(newThreshold, location.get());
            }
        }
    }

    private static AVLSet<Substitution> generateSubstitutionsFor(NumVar var, QueryChannel child) {
        if (child == null) {
            return AVLSet.empty();
        }
        SetOfEquations equalities = child.queryEqualities(var);
        return ThresholdsWideningStateBuilder.generateSubstitutionsFor(var, equalities);
    }

    private static AVLSet<Substitution> generateSubstitutionsFor(NumVar var, SetOfEquations equalities) {
        AVLSet<Substitution> substitutions = AVLSet.empty();
        if (equalities.isEmpty()) {
            return AVLSet.empty();
        }
        for (Linear equality : equalities) {
            substitutions = substitutions.add(equality.genSubstitution(var));
        }
        return substitutions;
    }

    protected P2<D, Set<Threshold>> applyNarrowing(D state, Option<ProgramPoint> point) {
        if (point.isNone()) {
            return P2.tuple2(state, Collections.emptySet());
        }
        ProgramPoint location = point.get();
        int wideningsHere = this.thresholds.getWideningNumber(location);
        if (wideningsHere > this.thresholds.wideningPointsSize() * this.thresholds.thresholdsSize() + 1) {
            return P2.tuple2(state, Collections.emptySet());
        }
        this.thresholds.appliedNarrowingAt(location);
        Set<Threshold> nonRedundant = ThresholdsWideningStateBuilder.toMutableSet(this.thresholds.asSet());
        if (nonRedundant.isEmpty()) {
            return P2.tuple2(state, Collections.emptySet());
        }
        D narrowedState = this.applyThresholds(nonRedundant, state);
        this.removeNonRedundantThresholds(narrowedState);
        return P2.tuple2(narrowedState, nonRedundant);
    }

    private static Set<Threshold> toMutableSet(Iterable<Threshold> set) {
        HashSet<Threshold> result = new HashSet<Threshold>();
        for (Threshold threshold : set) {
            result.add(threshold);
        }
        return result;
    }

    private Set<Threshold> getNonRedundantThresholds(D state) {
        HashSet<Threshold> nonRedundant = new HashSet<Threshold>();
        for (Threshold threshold : this.thresholds) {
            Zeno.Test test = threshold.getTest();
            if (this.isRedundant(test, state)._1().booleanValue()) continue;
            nonRedundant.add(threshold);
        }
        return nonRedundant;
    }

    protected void removeNonRedundantThresholds(D state) {
        Set<Threshold> nonRedundant = this.getNonRedundantThresholds(state);
        for (Threshold threshold : nonRedundant) {
            this.thresholds.remove(threshold);
        }
    }

    private D applyThresholds(Set<Threshold> thresh, D state) {
        for (Threshold threshold : thresh) {
            try {
                state = state.eval(threshold.getTest());
            }
            catch (Unreachable _) {
                throw new DomainStateException.InvariantViolationException();
            }
        }
        return state;
    }

    protected void mergeThresholds(D thisChildState, D otherChildState, ThresholdsWideningStateBuilder<D> otherBuilder) {
        P3<ThresholdsWideningState.MutableState, ThresholdsWideningState.MutableState, ThresholdsWideningState.MutableState> split = this.thresholds.split(otherBuilder.thresholds);
        ThresholdsWideningState.MutableState onlyInThis = split._1();
        ThresholdsWideningState.MutableState inBoth = split._2();
        ThresholdsWideningState.MutableState onlyInOther = split._3();
        assert (onlyInThis.isConsistent());
        assert (onlyInOther.isConsistent());
        assert (inBoth.isConsistent());
        this.thresholds = inBoth;
        this.copyRedundantThresholdsFrom(onlyInThis, thisChildState, otherChildState);
        this.copyRedundantThresholdsFrom(onlyInOther, otherChildState, thisChildState);
    }

    private void copyRedundantThresholdsFrom(ThresholdsWideningState.MutableState candidates, D candidatesState, D otherState) {
        for (Threshold threshold : candidates) {
            Zeno.Test test = threshold.getTest();
            Zeno.Test redundantTest = this.getRedundantTest(test, candidatesState, otherState, new HashSet<Zeno.Test>());
            if (redundantTest == null) continue;
            this.thresholds.add(threshold.withTest(redundantTest), candidates.getTransformations(threshold));
        }
    }

    private Zeno.Test getRedundantTest(Zeno.Test candidate, D candidatesState, D otherState, Set<Zeno.Test> usedCandidates) {
        if (usedCandidates.size() > 5) {
            return null;
        }
        if (this.isRedundant(candidate, otherState)._1().booleanValue()) {
            return candidate;
        }
        usedCandidates.add(candidate);
        AVLSet<Zeno.Test> substitutes = this.getSubstituteTests(candidate, candidatesState, otherState);
        for (Zeno.Test substitute : substitutes) {
            Zeno.Test redundantTest;
            if (usedCandidates.contains(substitute) || (redundantTest = this.getRedundantTest(substitute, candidatesState, otherState, usedCandidates)) == null) continue;
            return redundantTest;
        }
        return null;
    }

    private AVLSet<Zeno.Test> getSubstituteTests(Zeno.Test test, D testState, D otherState) {
        VarSet testVars = test.getVars();
        AVLSet<Substitution> substitutions = AVLSet.empty();
        for (NumVar var : testVars) {
            SetOfEquations thisEqualities = testState.queryEqualities(var);
            SetOfEquations otherEqualities = otherState.queryEqualities(var);
            substitutions = substitutions.union(ThresholdsWideningStateBuilder.generateSubstitutionsFor(var, thisEqualities.difference(otherEqualities)));
        }
        AVLSet<Zeno.Test> substitutes = AVLSet.empty();
        for (Substitution substitution : substitutions) {
            Zeno.Test substituteTest = test.applySubstitution(substitution);
            if (ZenoTestHelper.isTautology(substituteTest)) continue;
            substitutes = substitutes.add(substituteTest);
        }
        return substitutes;
    }

    public boolean subsetOrEqual(D thisChildState, ThresholdsWideningStateBuilder<D> other) {
        ThresholdsWideningState.MutableState allFromOther = other.thresholds;
        other.removeNonRedundantThresholds(thisChildState);
        ThresholdsWideningState.MutableState entailed = other.thresholds;
        return allFromOther.thresholds.difference(entailed.thresholds).isEmpty();
    }

    @Override
    public String toString() {
        return this.build().toString();
    }
}

