/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.widening.delayed;

import bindead.abstractsyntax.zeno.Zeno;
import bindead.abstractsyntax.zeno.ZenoFactory;
import bindead.abstractsyntax.zeno.ZenoRhsVisitorSkeleton;
import bindead.abstractsyntax.zeno.ZenoVisitor;
import bindead.data.Linear;
import bindead.data.NumVar;
import bindead.data.VarSet;
import bindead.domainnetwork.combinators.VoidDomainState;
import bindead.domainnetwork.combinators.ZenoFunctor;
import bindead.domainnetwork.interfaces.ProgramPoint;
import bindead.domainnetwork.interfaces.ZenoDomain;
import bindead.domains.widening.delayed.DelayedWideningProperties;
import bindead.exceptions.Unreachable;
import javalx.data.Option;
import javalx.numeric.BigInt;

public class DelayedWideningWithThresholds<D extends ZenoDomain<D>>
extends ZenoFunctor<VoidDomainState, D, DelayedWideningWithThresholds<D>> {
    public static final String NAME = "DELAYEDWIDENING(Thresholds)";
    private final boolean DEBUGASSIGN;
    private final boolean SEMANTICCONSTANTS;
    ZenoVisitor<Option<BigInt>, Void> rhsEvaluator;

    public DelayedWideningWithThresholds(D childState) {
        this(VoidDomainState.empty(), childState);
    }

    private DelayedWideningWithThresholds(VoidDomainState state, D childState) {
        super(NAME, state, childState);
        this.DEBUGASSIGN = DelayedWideningProperties.INSTANCE.debugAssignments.isTrue();
        this.SEMANTICCONSTANTS = DelayedWideningProperties.INSTANCE.semanticConstants.isTrue();
        this.rhsEvaluator = new ZenoRhsVisitorSkeleton<Option<BigInt>, Void>(){

            @Override
            public Option<BigInt> visit(Zeno.Bin expr, Void data) {
                return Option.none();
            }

            @Override
            public Option<BigInt> visit(Zeno.RangeRhs expr, Void data) {
                return Option.none();
            }

            @Override
            public Option<BigInt> visit(Zeno.Rlin expr, Void data) {
                if (!expr.getDivisor().isOne()) {
                    throw new IllegalStateException();
                }
                return Option.fromNullable(expr.getConstantOrNull());
            }
        };
    }

    @Override
    public DelayedWideningWithThresholds<D> build(VoidDomainState state, D childState) {
        return new DelayedWideningWithThresholds<D>(state, childState);
    }

    @Override
    public boolean subsetOrEqual(DelayedWideningWithThresholds<D> other) {
        return ((ZenoDomain)this.childState).subsetOrEqual(other.childState);
    }

    @Override
    public DelayedWideningWithThresholds<D> join(DelayedWideningWithThresholds<D> other) {
        ZenoDomain newChildState = (ZenoDomain)((ZenoDomain)this.childState).join(other.childState);
        return this.build((VoidDomainState)this.state, (D)newChildState);
    }

    @Override
    public DelayedWideningWithThresholds<D> widen(DelayedWideningWithThresholds<D> other) {
        ZenoDomain newChildState = (ZenoDomain)((ZenoDomain)this.childState).widen(other.childState);
        return this.build((VoidDomainState)other.state, (D)newChildState);
    }

    @Override
    public DelayedWideningWithThresholds<D> eval(Zeno.Assign stmt) {
        ZenoFactory zeno = ZenoFactory.getInstance();
        Object newChildState = ((ZenoDomain)this.childState).eval(stmt);
        Option<BigInt> constantRhs = this.getConstant(newChildState, stmt);
        if (constantRhs.isSome() && !DelayedWideningWithThresholds.isInvertibleAssignment(stmt)) {
            NumVar lhs = stmt.getLhs().getId();
            Linear linear = Linear.linear(lhs).sub(constantRhs.get());
            Zeno.Test test = zeno.comparison(linear, Zeno.ZenoTestOp.EqualToZero);
            newChildState = newChildState.eval(test);
            if (this.DEBUGASSIGN) {
                Option<ProgramPoint> location = this.getContext().getLocation();
                System.out.println(this.name + " @" + location + ": ");
                System.out.println("  evaluating assign: " + stmt);
                System.out.println("  adding threshold: " + test);
            }
        }
        return this.build((VoidDomainState)this.state, newChildState);
    }

    private static boolean isInvertibleAssignment(Zeno.Assign stmt) {
        NumVar lhs = stmt.getLhs().getId();
        Zeno.Rhs rhs = stmt.getRhs();
        return rhs.getVars().contains(lhs);
    }

    private Option<BigInt> getConstant(D newChildState, Zeno.Assign stmt) {
        if (this.SEMANTICCONSTANTS) {
            return Option.fromNullable(newChildState.queryRange(stmt.getLhs().getId()).getConstantOrNull());
        }
        return stmt.getRhs().accept(this.rhsEvaluator, null);
    }

    @Override
    public DelayedWideningWithThresholds<D> eval(Zeno.Test test) throws Unreachable {
        Object newChildState = ((ZenoDomain)this.childState).eval(test);
        return this.build((VoidDomainState)this.state, newChildState);
    }

    @Override
    public DelayedWideningWithThresholds<D> project(VarSet vars) {
        Object newChildState = ((ZenoDomain)this.childState).project(vars);
        return this.build((VoidDomainState)this.state, newChildState);
    }

    @Override
    public DelayedWideningWithThresholds<D> substitute(NumVar x, NumVar y) {
        Object newChildState = ((ZenoDomain)this.childState).substitute(x, y);
        return this.build((VoidDomainState)this.state, newChildState);
    }

    @Override
    public final String toString() {
        return ((ZenoDomain)this.childState).toString();
    }
}

