/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.undef;

import bindead.data.FoldMap;
import bindead.data.Linear;
import bindead.data.ListVarPair;
import bindead.data.NumVar;
import bindead.data.VarPair;
import bindead.data.VarSet;
import bindead.domainnetwork.channels.SetOfEquations;
import bindead.domainnetwork.combinators.FiniteStateBuilder;
import bindead.domainnetwork.interfaces.FiniteDomain;
import bindead.domains.undef.UndefState;
import bindead.exceptions.DomainStateException;
import java.util.HashMap;
import java.util.Map;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.data.products.P3;
import javalx.numeric.BigInt;
import javalx.numeric.Bound;
import javalx.numeric.Range;
import javalx.persistentcollections.AVLMap;
import javalx.persistentcollections.FiniteMap;
import javalx.persistentcollections.ThreeWaySplit;

class UndefStateBuilder
extends FiniteStateBuilder {
    VarSet undefined;
    private AVLMap<NumVar.FlagVar, VarSet> partitions;
    private AVLMap<NumVar, NumVar.FlagVar> reverse;

    public UndefStateBuilder(UndefState ctx) {
        this.undefined = ctx.undefined;
        this.partitions = ctx.partitions;
        this.reverse = ctx.reverse;
    }

    private static NumVar.FlagVar freshFlag() {
        return NumVar.freshFlag("e");
    }

    protected boolean isFlag(NumVar.FlagVar flag) {
        return this.partitions.contains(flag);
    }

    private boolean contains(NumVar variable) {
        return this.undefined.contains(variable) || this.reverse.contains(variable);
    }

    boolean isUndefined(NumVar var) {
        return this.undefined.contains(var);
    }

    private boolean isDefined(NumVar var) {
        return !this.contains(var);
    }

    protected boolean hasUndefined(VarSet variables) {
        for (NumVar var : variables) {
            if (!this.isUndefined(var)) continue;
            return true;
        }
        return false;
    }

    protected void addUndefined(NumVar var) {
        assert (!this.isUndefined(var));
        this.undefined = this.undefined.add(var);
    }

    private void addUndefined(VarSet partition) {
        this.undefined = this.undefined.union(partition);
    }

    void removeFromUndefined(NumVar var) {
        this.undefined = this.undefined.remove(var);
    }

    protected void removeFromPartition(NumVar variable) {
        NumVar.FlagVar flag = this.getFlagFor(variable).getOrNull();
        if (flag != null) {
            this.reverse = this.reverse.remove((Object)variable);
            VarSet partition = this.partitions.get(flag).get();
            if ((partition = partition.remove(variable)).isEmpty()) {
                this.partitions = this.partitions.remove((Object)flag);
                this.getChildOps().addKill(flag);
            } else {
                this.partitions = this.partitions.bind((Object)flag, (Object)partition);
            }
        }
    }

    private void removeFromPartitionNoKill(NumVar variable) {
        NumVar.FlagVar flag = this.getFlagFor(variable).getOrNull();
        if (flag != null) {
            this.reverse = this.reverse.remove((Object)variable);
            VarSet partition = this.partitions.get(flag).get();
            this.partitions = (partition = partition.remove(variable)).isEmpty() ? this.partitions.remove((Object)flag) : this.partitions.bind((Object)flag, (Object)partition);
        }
    }

    private void removeFromPartitionNoKill(NumVar.FlagVar flag, VarSet variables) {
        VarSet partition = this.partitions.get(flag).get();
        assert (partition.containsAll(variables));
        for (NumVar variable : variables) {
            this.reverse = this.reverse.remove((Object)variable);
        }
        this.partitions = (partition = partition.difference(variables)).isEmpty() ? this.partitions.remove((Object)flag) : this.partitions.bind((Object)flag, (Object)partition);
    }

    private void removePartition(NumVar.FlagVar flag) {
        if (!this.isFlag(flag)) {
            return;
        }
        VarSet partition = this.partitions.get(flag).get();
        this.partitions = this.partitions.remove((Object)flag);
        for (NumVar var : partition) {
            this.reverse = this.reverse.remove((Object)var);
        }
    }

    protected NumVar.FlagVar addPartition(NumVar singletonPartition) {
        return this.addPartition(VarSet.of(singletonPartition));
    }

    protected NumVar.FlagVar addEmptyPartition() {
        return this.addPartition(VarSet.empty());
    }

    private NumVar.FlagVar addPartition(VarSet partition) {
        NumVar.FlagVar flag = UndefStateBuilder.freshFlag();
        this.addNewPartition(flag, partition);
        this.getChildOps().addIntroZero(flag);
        return flag;
    }

    private void addNewPartition(NumVar.FlagVar flag, VarSet partition) {
        assert (this.partitions.get(flag).isNone());
        this.partitions = this.partitions.bind((Object)flag, (Object)partition);
        for (NumVar var : partition) {
            this.reverse = this.reverse.bind((Object)var, (Object)flag);
        }
    }

    protected void addToPartition(NumVar.FlagVar flag, NumVar variable) {
        VarSet partition = this.partitions.get(flag).getOrElse(VarSet.empty());
        this.partitions = this.partitions.bind((Object)flag, (Object)partition.add(variable));
        this.reverse = this.reverse.bind((Object)variable, (Object)flag);
    }

    protected void project(NumVar variable) {
        if (this.isUndefined(variable)) {
            this.removeFromUndefined(variable);
        } else {
            this.removeFromPartition(variable);
            this.getChildOps().addKill(variable);
        }
    }

    protected void promoteToChild(NumVar variable) {
        this.promoteToChild(VarSet.of(variable));
    }

    protected void promoteToChild(VarSet vars) {
        VarSet toPromote = vars.intersection(this.undefined);
        if (!toPromote.isEmpty()) {
            this.undefined = this.undefined.difference(toPromote);
            for (NumVar var : toPromote) {
                this.getChildOps().addIntro(var);
            }
        }
    }

    public VarSet getFlagsFor(VarSet vars) {
        VarSet flags = VarSet.empty();
        for (NumVar var : vars) {
            Option<NumVar.FlagVar> flag = this.getFlagFor(var);
            if (!flag.isSome()) continue;
            flags = flags.add(flag.get());
        }
        return flags;
    }

    Option<NumVar.FlagVar> getFlagFor(NumVar var) {
        return this.reverse.get(var);
    }

    public VarSet getFlagsFor(NumVar var) {
        return this.getFlagsFor(VarSet.empty().add(var));
    }

    public UndefState build() {
        return new UndefState(this.undefined, this.partitions, this.reverse);
    }

    public void substitute(NumVar x, NumVar y) {
        if (this.isUndefined(x)) {
            this.removeFromUndefined(x);
            this.addUndefined(y);
        } else {
            this.getChildOps().addSubst(x, y);
            NumVar.FlagVar flag = this.getFlagFor(x).getOrNull();
            if (flag != null) {
                VarSet part = this.partitions.get(flag).get();
                part = part.remove(x).add(y);
                this.reverse = ((AVLMap)this.reverse.remove((Object)x)).bind(y, flag);
                this.partitions = this.partitions.bind((Object)flag, (Object)part);
            }
        }
    }

    protected <D extends FiniteDomain<D>> void makeCompatible(D childState, UndefStateBuilder other, D otherChildState) {
        this.makeUndefinedCompatible(childState, other, otherChildState);
        this.makePartitionsCompatible(other);
    }

    private <D extends FiniteDomain<D>> void makeUndefinedCompatible(D childState, UndefStateBuilder other, D otherChildState) {
        P3<VarSet, VarSet, VarSet> split = this.undefined.split(other.undefined);
        VarSet undefinedInFst = split._1();
        VarSet inBoth = split._2();
        VarSet undefinedInSnd = split._3();
        this.undefined = inBoth;
        other.undefined = inBoth;
        if (!undefinedInFst.isEmpty()) {
            this.getChildOps().addCopyAndPaste(undefinedInFst, otherChildState);
            this.addPartition(undefinedInFst);
        }
        if (!undefinedInSnd.isEmpty()) {
            other.getChildOps().addCopyAndPaste(undefinedInSnd, childState);
            other.addPartition(undefinedInSnd);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void makePartitionsCompatible(UndefStateBuilder other) {
        void var8_29;
        void var7_20;
        void var6_11;
        ThreeWaySplit<AVLMap<NumVar.FlagVar, VarSet>> mapSplit = this.partitions.split(other.partitions);
        FiniteMap onlyInFirst = mapSplit.onlyInFirst();
        FiniteMap onlyInSecond = mapSplit.onlyInSecond();
        for (P2<NumVar.FlagVar, VarSet> p2 : mapSplit.inBothButDiffering()) {
            NumVar.FlagVar newPartitionFlag;
            NumVar.FlagVar flagVar = p2._1();
            VarSet varSet = p2._2();
            VarSet varSet2 = other.partitions.get(flagVar).get();
            P3<VarSet, VarSet, VarSet> p3 = varSet.split(varSet2);
            VarSet onlyInThis = p3._1();
            VarSet common = p3._2();
            VarSet onlyInOther = p3._3();
            if (!onlyInThis.isEmpty()) {
                newPartitionFlag = UndefStateBuilder.splitPartition(this, flagVar, onlyInThis);
                onlyInFirst = onlyInFirst.bind(newPartitionFlag, onlyInThis);
            }
            if (!onlyInOther.isEmpty()) {
                newPartitionFlag = UndefStateBuilder.splitPartition(other, flagVar, onlyInOther);
                onlyInSecond = onlyInSecond.bind(newPartitionFlag, onlyInOther);
            }
            this.removePartition(flagVar);
            other.removePartition(flagVar);
            if (!common.isEmpty()) {
                this.addNewPartition(flagVar, common);
                other.addNewPartition(flagVar, common);
                continue;
            }
            this.getChildOps().addKill(flagVar);
            other.getChildOps().addKill(flagVar);
        }
        VarSet definedInOther = VarSet.empty();
        for (P2<NumVar.FlagVar, VarSet> p2 : onlyInFirst) {
            for (NumVar numVar : p2._2()) {
                if (!other.isDefined(numVar)) continue;
                definedInOther = definedInOther.add(numVar);
            }
        }
        if (!definedInOther.isEmpty()) {
            NumVar.FlagVar flagVar = UndefStateBuilder.freshFlag();
            other.getChildOps().addIntro(flagVar, Bound.ONE);
            other.addNewPartition(flagVar, definedInOther);
        }
        VarSet varSet = VarSet.empty();
        for (P2<NumVar.FlagVar, VarSet> p2 : onlyInSecond) {
            for (NumVar numVar : p2._2()) {
                if (!this.isDefined(numVar)) continue;
                VarSet varSet3 = var6_11.add(numVar);
            }
        }
        if (!var6_11.isEmpty()) {
            NumVar.FlagVar flagVar = UndefStateBuilder.freshFlag();
            this.getChildOps().addIntro(flagVar, Bound.ONE);
            this.addNewPartition(flagVar, (VarSet)var6_11);
        }
        VarSet varSet4 = VarSet.empty();
        for (P2<NumVar.FlagVar, VarSet> p2 : onlyInFirst) {
            VarSet varSet5 = var7_20.union(p2._2());
        }
        VarSet varSet6 = VarSet.empty();
        for (P2<NumVar.FlagVar, VarSet> p2 : onlyInSecond) {
            VarSet varSet7 = var8_29.union(p2._2());
        }
        VarSet varSet10 = VarSet.empty();
        varSet10 = this.splitMatching((VarSet)var7_20, varSet10, other);
        varSet10 = this.splitMatching((VarSet)var8_29, varSet10, other);
        assert (varSet10.difference((VarSet)var7_20).difference((VarSet)var8_29).isEmpty());
    }

    private VarSet splitMatching(VarSet variablesToMatch, VarSet alreadyMatched, UndefStateBuilder other) {
        for (NumVar variable : variablesToMatch) {
            if (alreadyMatched.contains(variable)) continue;
            NumVar.FlagVar thisFlag = this.reverse.get(variable).get();
            NumVar.FlagVar otherFlag = other.reverse.get(variable).get();
            assert (!otherFlag.equalTo(thisFlag));
            VarSet thisPartition = this.partitions.get(thisFlag).get();
            VarSet otherPartition = other.partitions.get(otherFlag).get();
            P3<VarSet, VarSet, VarSet> split = thisPartition.split(otherPartition);
            VarSet onlyInThis = split._1();
            VarSet common = split._2();
            VarSet onlyInOther = split._3();
            UndefStateBuilder.splitPartition(this, thisFlag, onlyInThis);
            UndefStateBuilder.splitPartition(other, otherFlag, onlyInOther);
            alreadyMatched = alreadyMatched.union(common);
            this.removePartition(thisFlag);
            this.addNewPartition(otherFlag, common);
            this.getChildOps().addSubst(thisFlag, otherFlag);
        }
        return alreadyMatched;
    }

    public void reduceFromNewEqualities(SetOfEquations newEqualities) {
        for (Linear eq : newEqualities) {
            Option<VarSet> oPart;
            BigInt value;
            NumVar var;
            if (!eq.isSingleTerm() || !(var = eq.getKey()).isFlag() || !(value = eq.getConstant()).isEqualTo(Bound.MINUSONE) || !(oPart = this.partitions.get((NumVar.FlagVar)var)).isSome()) continue;
            this.removePartition((NumVar.FlagVar)var);
            this.getChildOps().addKill(var);
        }
    }

    public <D extends FiniteDomain<D>> void reduceWithQuery(D childState, VarSet flags) {
        for (NumVar flag : flags) {
            Range range = childState.queryRange(flag);
            if (range.isOne()) {
                this.removePartition((NumVar.FlagVar)flag);
                this.getChildOps().addKill(flag);
                continue;
            }
            if (!range.isZero()) continue;
            VarSet partition = this.partitions.get((NumVar.FlagVar)flag).get();
            this.addUndefined(partition);
            this.removePartition((NumVar.FlagVar)flag);
            this.getChildOps().addKill(flag);
            for (NumVar var : partition) {
                this.getChildOps().addKill(var);
            }
        }
    }

    protected <D extends FiniteDomain<D>> void copyAndPaste(VarSet vars, UndefState otherState, D otherChildState) {
        VarSet childCopyVars = vars;
        for (NumVar var : vars) {
            if (this.contains(var)) {
                throw new DomainStateException.VariableSupportSetException();
            }
            if (!otherState.undefined.contains(var)) continue;
            childCopyVars = childCopyVars.remove(var);
            this.addUndefined(var);
        }
        VarSet otherFlags = new UndefStateBuilder(otherState).getFlagsFor(childCopyVars);
        for (NumVar otherFlagVar : otherFlags) {
            NumVar.FlagVar otherFlag = (NumVar.FlagVar)otherFlagVar;
            VarSet otherPartition = otherState.partitions.getOrNull(otherFlag);
            if (this.isFlag(otherFlag)) {
                NumVar.FlagVar renamedOtherFlag = UndefStateBuilder.freshFlag();
                otherChildState = otherChildState.substitute(otherFlag, renamedOtherFlag);
                otherFlag = renamedOtherFlag;
            }
            this.addNewPartition(otherFlag, otherPartition.intersection(vars));
            childCopyVars = childCopyVars.add(otherFlag);
        }
        this.getChildOps().addCopyAndPaste(childCopyVars, otherChildState);
    }

    protected void fold(ListVarPair pairs) {
        ListVarPair childVars = this.foldNG(pairs);
        this.getChildOps().addFoldNG(childVars);
    }

    ListVarPair foldNG(ListVarPair pairs) {
        NumVar.FlagVar undefinedFlag = UndefStateBuilder.freshFlag();
        this.getChildOps().addIntroZero(undefinedFlag);
        NumVar.FlagVar definedFlag = UndefStateBuilder.freshFlag();
        this.getChildOps().addIntro(definedFlag, Bound.ONE);
        VarSet permanents = VarSet.empty();
        VarSet ephemerals = VarSet.empty();
        ListVarPair childVars = new ListVarPair();
        ListVarPair partitionVars = new ListVarPair();
        HashMap<NumVar, NumVar> forwardPairs = new HashMap<NumVar, NumVar>();
        HashMap<NumVar, NumVar> backwardPairs = new HashMap<NumVar, NumVar>();
        for (VarPair pair : pairs) {
            ListVarPair singleton;
            NumVar permanentVar = (NumVar)pair.getPermanent();
            NumVar ephemeralVar = (NumVar)pair.getEphemeral();
            if (this.isUndefined(permanentVar) && this.isUndefined(ephemeralVar)) {
                this.removeFromUndefined(ephemeralVar);
                continue;
            }
            if (this.isDefined(permanentVar) && this.isDefined(ephemeralVar)) {
                childVars.add(pair);
                continue;
            }
            if (this.isUndefined(permanentVar)) {
                this.removeFromUndefined(permanentVar);
                this.addToPartition(undefinedFlag, permanentVar);
                singleton = new ListVarPair();
                singleton.add(ephemeralVar, permanentVar);
                this.getChildOps().addExpandNG(singleton);
            } else if (this.isUndefined(ephemeralVar)) {
                this.removeFromUndefined(ephemeralVar);
                this.addToPartition(undefinedFlag, ephemeralVar);
                singleton = new ListVarPair();
                singleton.add(permanentVar, ephemeralVar);
                this.getChildOps().addExpandNG(singleton);
            }
            if (this.isDefined(permanentVar)) {
                this.addToPartition(definedFlag, permanentVar);
            } else if (this.isDefined(ephemeralVar)) {
                this.addToPartition(definedFlag, ephemeralVar);
            }
            partitionVars.add(pair);
            forwardPairs.put(permanentVar, ephemeralVar);
            backwardPairs.put(ephemeralVar, permanentVar);
            permanents = permanents.add(permanentVar);
            ephemerals = ephemerals.add(ephemeralVar);
        }
        if (this.partitions.get(definedFlag).isNone()) {
            this.getChildOps().addKill(definedFlag);
        }
        if (this.partitions.get(undefinedFlag).isNone()) {
            this.getChildOps().addKill(undefinedFlag);
        }
        VarSet permanentFlags = this.getFlagsFor(permanents);
        VarSet ephemeralFlags = this.getFlagsFor(ephemerals);
        VarSet mixedPartitions = permanentFlags.intersection(ephemeralFlags);
        for (NumVar flag : mixedPartitions) {
            NumVar.FlagVar partitionFlag = (NumVar.FlagVar)flag;
            VarSet partition = this.partitions.get(partitionFlag).get();
            VarSet ephemeralsInPartition = partition.intersection(ephemerals);
            UndefStateBuilder.splitPartition(this, partitionFlag, ephemeralsInPartition);
        }
        VarSet matched = VarSet.empty();
        for (VarPair pair : partitionVars) {
            NumVar permanentVar = (NumVar)pair.getPermanent();
            if (matched.contains(permanentVar)) continue;
            NumVar ephemeralVar = (NumVar)pair.getEphemeral();
            NumVar.FlagVar permanentFlag = this.getFlagFor(permanentVar).get();
            NumVar.FlagVar ephemeralFlag = this.getFlagFor(ephemeralVar).get();
            VarSet permanentPartition = this.partitions.get(permanentFlag).get();
            VarSet ephemeralPartition = this.partitions.get(ephemeralFlag).get();
            P3<VarSet, VarSet, VarSet> split = UndefStateBuilder.splitWithMapping(permanentPartition, ephemeralPartition, forwardPairs, backwardPairs);
            VarSet onlyInPermanent = split._1();
            VarSet common = split._2();
            VarSet onlyInEphemeral = split._3();
            matched = matched.union(common);
            UndefStateBuilder.splitPartition(this, permanentFlag, onlyInPermanent);
            UndefStateBuilder.splitPartition(this, ephemeralFlag, onlyInEphemeral);
        }
        FoldMap childMap = FoldMap.fromList(childVars);
        for (VarPair pair : partitionVars) {
            NumVar.FlagVar ephemeralFlag;
            childVars.add(pair);
            childMap.add(pair);
            NumVar permanentVar = (NumVar)pair.getPermanent();
            NumVar ephemeralVar = (NumVar)pair.getEphemeral();
            NumVar.FlagVar permanentFlag = this.getFlagFor(permanentVar).get();
            if (permanentFlag.equalTo(ephemeralFlag = this.getFlagFor(ephemeralVar).get())) continue;
            this.removeFromPartitionNoKill(ephemeralVar);
            if (childMap.isPermanent(permanentFlag)) {
                assert (childMap.getEphemeral(permanentFlag).equalTo(ephemeralFlag));
                continue;
            }
            childVars.add(permanentFlag, ephemeralFlag);
            childMap.add(permanentFlag, ephemeralFlag);
        }
        return childVars;
    }

    private static NumVar.FlagVar splitPartition(UndefStateBuilder builder, NumVar.FlagVar partitionFlag, VarSet fragment) {
        if (fragment.isEmpty()) {
            return partitionFlag;
        }
        VarSet partition = builder.partitions.get(partitionFlag).get();
        assert (partition.containsAll(fragment));
        builder.removeFromPartitionNoKill(partitionFlag, fragment);
        NumVar.FlagVar newPartitionFlag = UndefStateBuilder.freshFlag();
        UndefStateBuilder.copyFlag(builder, partitionFlag, newPartitionFlag, fragment);
        return newPartitionFlag;
    }

    private static P3<VarSet, VarSet, VarSet> splitWithMapping(VarSet first, VarSet second, Map<NumVar, NumVar> forwardPairs, Map<NumVar, NumVar> backwardPairs) {
        VarSet common = first.intersection(second.substitute(backwardPairs));
        VarSet onlyInFirst = first.difference(common);
        VarSet onlyInSecond = second.difference(common.substitute(forwardPairs));
        return P3.tuple3(onlyInFirst, common, onlyInSecond);
    }

    private static void copyFlag(UndefStateBuilder builder, NumVar.FlagVar fromFlag, NumVar.FlagVar toFlag, VarSet variables) {
        ListVarPair singleton = new ListVarPair();
        singleton.add(fromFlag, toFlag);
        builder.getChildOps().addExpandNG(singleton);
        builder.addNewPartition(toFlag, variables);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.getChildOps().length() > 0) {
            builder.append("Childops:").append(this.getChildOps()).append("\n");
        }
        builder.append(this.build().toString());
        return builder.toString();
    }

    public void expandNG(NumVar.AddrVar p, NumVar.AddrVar e, ListVarPair nvps) {
        ListVarPair cvps = this.expandOnState(nvps);
        this.getChildOps().addExpandNG(p, e, cvps);
    }

    public void expandNG(ListVarPair nvps) {
        ListVarPair cvps = this.expandOnState(nvps);
        this.getChildOps().addExpandNG(cvps);
    }

    private ListVarPair expandOnState(ListVarPair nvps) {
        ListVarPair cvps = new ListVarPair();
        for (VarPair pair : nvps) {
            NumVar permanentVar = (NumVar)pair.getPermanent();
            NumVar ephemeralVar = (NumVar)pair.getEphemeral();
            if (this.contains(ephemeralVar)) {
                throw new DomainStateException.VariableSupportSetException();
            }
            if (this.isUndefined(permanentVar)) {
                this.addUndefined(ephemeralVar);
                continue;
            }
            if (this.isDefined(permanentVar)) {
                cvps.add(pair);
                continue;
            }
            NumVar.FlagVar flag = this.reverse.getOrNull(permanentVar);
            VarSet partition = this.partitions.getOrNull(flag);
            this.removePartition(flag);
            this.addNewPartition(flag, partition.add(ephemeralVar));
            cvps.add(pair);
        }
        return cvps;
    }
}

