/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.undef;

import bindead.data.NumVar;
import bindead.data.VarSet;
import bindead.debug.PrettyDomain;
import bindead.debug.XmlPrintHelpers;
import bindead.domainnetwork.interfaces.FunctorState;
import com.jamesmurty.utils.XMLBuilder;
import javalx.data.products.P2;
import javalx.persistentcollections.AVLMap;

class UndefState
extends FunctorState {
    private static final UndefState EMPTY = new UndefState();
    protected final VarSet undefined;
    protected final AVLMap<NumVar.FlagVar, VarSet> partitions;
    protected final AVLMap<NumVar, NumVar.FlagVar> reverse;

    private UndefState() {
        this(VarSet.empty(), AVLMap.empty(), AVLMap.empty());
    }

    protected UndefState(VarSet undefined, AVLMap<NumVar.FlagVar, VarSet> partitions, AVLMap<NumVar, NumVar.FlagVar> reverse) {
        this.undefined = undefined;
        this.partitions = partitions;
        this.reverse = reverse;
        assert (this.isConsistent());
    }

    public static UndefState empty() {
        return EMPTY;
    }

    private boolean isConsistent() {
        for (P2<NumVar.FlagVar, VarSet> p2 : this.partitions) {
            NumVar.FlagVar flag = p2._1();
            VarSet variables = p2._2();
            if (this.undefined.containsAll(variables)) {
                return false;
            }
            for (NumVar variable : variables) {
                if (!this.reverse.contains(variable)) {
                    return false;
                }
                if (this.reverse.get(variable).get().equalTo(flag)) continue;
                return false;
            }
        }
        for (P2<NumVar, Comparable<VarSet>> p2 : this.reverse) {
            NumVar variable = p2._1();
            NumVar.FlagVar flag = (NumVar.FlagVar)p2._2();
            if (this.undefined.contains(variable)) {
                return false;
            }
            if (!this.partitions.contains(flag)) {
                return false;
            }
            if (this.partitions.get(flag).get().contains(variable)) continue;
            return false;
        }
        return true;
    }

    public VarSet getFlagVars(VarSet vars) {
        VarSet res = VarSet.empty();
        for (NumVar var : vars) {
            if (!(var instanceof NumVar.FlagVar) || !this.partitions.contains((NumVar.FlagVar)var)) continue;
            res = res.add(var);
        }
        return res;
    }

    @Override
    public XMLBuilder toXML(XMLBuilder builder) {
        builder = builder.e("UNDEF");
        if (!this.undefined.isEmpty()) {
            builder = builder.e("Entry").a("type", "Always");
            builder = XmlPrintHelpers.variableSet(builder, this.undefined);
            builder = builder.up();
        }
        for (P2<NumVar.FlagVar, VarSet> p2 : this.partitions) {
            builder = builder.e("Entry").a("type", "Conditionally");
            builder = builder.e("Flag").t(p2._1().toString()).up();
            builder = XmlPrintHelpers.variableSet(builder, p2._2());
            builder = builder.up();
        }
        builder = builder.up();
        return builder;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("#");
        if (!this.undefined.isEmpty()) {
            builder.append(this.partitions.size() + 1);
        } else {
            builder.append(this.partitions.size());
        }
        builder.append(" ");
        builder.append("{");
        String separator = "";
        if (!this.undefined.isEmpty()) {
            builder.append("always: ");
            builder.append(this.undefined);
            separator = ", ";
        }
        for (P2<NumVar.FlagVar, VarSet> p2 : this.partitions) {
            builder.append(separator);
            builder.append("if ");
            builder.append(p2._1());
            builder.append(": ");
            builder.append(p2._2());
            separator = ", ";
        }
        builder.append("}");
        return builder.toString();
    }

    @Override
    public void toCompactString(String domainName, StringBuilder builder, PrettyDomain childDomain) {
    }
}

