/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.segments.machine;

import bindead.abstractsyntax.memderef.AbstractMemPointer;
import bindead.abstractsyntax.memderef.AbstractPointer;
import bindead.abstractsyntax.memderef.SymbolicOffset;
import bindead.data.MemVarSet;
import bindead.data.NumVar;
import bindead.debug.PrettyDomain;
import bindead.domainnetwork.interfaces.MemoryDomain;
import bindead.domainnetwork.interfaces.RegionCtx;
import bindead.domains.segments.basics.RegionAccess;
import bindead.domains.segments.basics.SegCompatibleState;
import bindead.domains.segments.basics.Segment;
import bindead.domains.segments.basics.SegmentWithState;
import bindead.exceptions.DomainStateException;
import java.util.LinkedList;
import java.util.List;
import javalx.data.Option;
import javalx.data.products.P3;
import javalx.exceptions.UnimplementedException;
import rreil.lang.Lhs;
import rreil.lang.MemVar;
import rreil.lang.Rhs;
import rreil.lang.util.Type;

public class ThreadLocalStorage<D extends MemoryDomain<D>>
extends Segment<D> {
    private final MemVar tlsRegion = MemVar.fresh("thread-local storage");
    private final NumVar.AddrVar tlsAddr = NumVar.freshAddress("thread-local storage");
    public static final String NAME = "ThreadLocalStorage";

    @Override
    public P3<List<MemVar>, Boolean, D> initialize(D state) {
        state = state.introduceRegion(this.tlsRegion, RegionCtx.EMPTYSTICKY);
        state = state.introduce(this.tlsAddr, Type.Address, Option.none());
        return P3.tuple3(new LinkedList(), Boolean.FALSE, state);
    }

    @Override
    public SegmentWithState<D> triggerAssignment(Lhs lhs, Rhs rhs, D state) {
        throw new DomainStateException.InvariantViolationException();
    }

    @Override
    public SegCompatibleState<D> makeCompatible(Segment<D> otherRaw, D state, D otherState) {
        ThreadLocalStorage other = (ThreadLocalStorage)otherRaw;
        assert (this.tlsRegion.equals(other.tlsRegion));
        assert (this.tlsAddr.equalTo(other.tlsAddr));
        return new SegCompatibleState<D>(this, state, otherState);
    }

    @Override
    public List<RegionAccess<D>> dereference(Rhs.Lin sourcePointerValue, AbstractPointer dRef, D state) {
        LinkedList<RegionAccess<D>> res = null;
        if (!dRef.isAbsolute() && dRef.address.equalTo(this.tlsAddr)) {
            res = new LinkedList<RegionAccess<D>>();
            res.add(new RegionAccess<D>(new AbstractMemPointer(this.tlsRegion, new SymbolicOffset(dRef.offset)), new SegmentWithState<D>(this, state)));
        }
        return res;
    }

    @Override
    public MemVarSet getChildSupportSet() {
        return MemVarSet.of(this.tlsRegion);
    }

    @Override
    public void toCompactString(StringBuilder builder, PrettyDomain childDomain) {
        throw new UnimplementedException();
    }
}

