/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.segments.machine;

import bindead.data.MemVarSet;
import bindead.debug.PrettyDomain;
import bindead.domainnetwork.interfaces.MemoryDomain;
import bindead.domainnetwork.interfaces.RegionCtx;
import bindead.domains.segments.basics.SegCompatibleState;
import bindead.domains.segments.basics.Segment;
import bindead.domains.segments.basics.SegmentWithState;
import bindead.exceptions.DomainStateException;
import java.util.LinkedList;
import java.util.List;
import javalx.data.products.P3;
import rreil.lang.Lhs;
import rreil.lang.MemVar;
import rreil.lang.RReil;
import rreil.lang.Rhs;

public class Processor<D extends MemoryDomain<D>>
extends Segment<D> {
    public static final String NAME = "Processor";
    private final MemVarSet registers;

    public Processor() {
        this.registers = MemVarSet.empty();
    }

    private Processor(MemVarSet registers) {
        this.registers = registers;
    }

    @Override
    public P3<List<MemVar>, Boolean, D> initialize(D state) {
        for (MemVar region : this.registers) {
            state = state.introduceRegion(region, RegionCtx.EMPTYSTICKY);
        }
        return P3.tuple3(new LinkedList(), Boolean.FALSE, state);
    }

    @Override
    public SegmentWithState<D> triggerAssignment(Lhs lhs, Rhs rhs, D state) {
        throw new DomainStateException.InvariantViolationException();
    }

    @Override
    public SegCompatibleState<D> makeCompatible(Segment<D> otherRaw, D state, D otherState) {
        Processor other = (Processor)otherRaw;
        MemVarSet union = this.registers.insertAll(other.registers);
        D newState = state;
        for (MemVar region : union.difference(this.registers)) {
            newState = newState.introduceRegion(region, RegionCtx.EMPTYSTICKY);
        }
        D newOtherState = otherState;
        for (MemVar region : union.difference(other.registers)) {
            newOtherState = newOtherState.introduceRegion(region, RegionCtx.EMPTYSTICKY);
        }
        return new SegCompatibleState<D>(new Processor<D>(union), newState, newOtherState);
    }

    @Override
    public SegmentWithState<D> tryPrimitive(RReil.PrimOp prim, D state) {
        if (prim.is("addRegisters", Integer.MAX_VALUE, Integer.MAX_VALUE)) {
            LinkedList<MemVar> newRegisters = new LinkedList<MemVar>();
            for (Lhs variable : prim.getOutArgs()) {
                newRegisters.add(variable.getRegionId());
            }
            for (Rhs.Rval rhs : prim.getInArgs()) {
                if (!(rhs instanceof Rhs.Rvar)) continue;
                newRegisters.add(((Rhs.Rvar)rhs).getRegionId());
            }
            MemVarSet updatedRegisters = this.registers;
            D updatedState = state;
            for (MemVar register : newRegisters) {
                if (updatedRegisters.contains(register)) continue;
                updatedRegisters = updatedRegisters.insert(register);
                updatedState = updatedState.introduceRegion(register, RegionCtx.EMPTYSTICKY);
            }
            return new SegmentWithState<D>(new Processor<D>(updatedRegisters), updatedState);
        }
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Processor: ").append(this.registers);
        return builder.toString();
    }

    @Override
    public MemVarSet getChildSupportSet() {
        return this.registers;
    }

    @Override
    public void toCompactString(StringBuilder builder, PrettyDomain childDomain) {
        builder.append("Processor\n");
        for (MemVar reg : this.registers) {
            builder.append("    " + reg + " = ");
            childDomain.memVarToCompactString(builder, reg);
            builder.append('\n');
        }
    }
}

