/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.segments.machine;

import bindead.abstractsyntax.memderef.AbstractMemPointer;
import bindead.abstractsyntax.memderef.AbstractPointer;
import bindead.data.MemVarSet;
import bindead.debug.PrettyDomain;
import bindead.domainnetwork.channels.QueryChannel;
import bindead.domainnetwork.interfaces.ContentCtx;
import bindead.domainnetwork.interfaces.MemoryDomain;
import bindead.domains.segments.basics.RegionAccess;
import bindead.domains.segments.basics.SegCompatibleState;
import bindead.domains.segments.basics.Segment;
import bindead.domains.segments.basics.SegmentWithState;
import bindead.domains.segments.warnings.IllegalNumericPointerTarget;
import bindead.exceptions.DomainStateException;
import bindead.exceptions.Unreachable;
import java.util.LinkedList;
import java.util.List;
import javalx.data.products.P2;
import javalx.data.products.P3;
import javalx.numeric.Range;
import rreil.lang.Lhs;
import rreil.lang.MemVar;
import rreil.lang.RReil;
import rreil.lang.RReilAddr;
import rreil.lang.Rhs;

public class NullSegment<D extends MemoryDomain<D>>
extends Segment<D> {
    public static final String NAME = "Null";

    @Override
    public P3<List<MemVar>, Boolean, D> initialize(D state) {
        return P3.tuple3(new LinkedList(), Boolean.FALSE, state);
    }

    @Override
    public SegmentWithState<D> triggerAssignment(Lhs lhs, Rhs rhs, D state) {
        throw new DomainStateException.InvariantViolationException();
    }

    @Override
    public List<P2<RReilAddr, SegmentWithState<D>>> resolveJump(Rhs.Lin target, AbstractMemPointer location, D state) {
        this.warn(state, location.getOffsetRange(state));
        return null;
    }

    @Override
    public List<RegionAccess<D>> dereference(Rhs.Lin sourcePointerValue, AbstractPointer pointer, D state) {
        if (pointer.isAbsolute()) {
            try {
                state = state.assumePointsToAndConcretize(sourcePointerValue, null, null);
                this.warn(state, pointer.getExplicitOffset((QueryChannel)state));
            }
            catch (Unreachable unreachable) {
                // empty catch block
            }
        }
        return null;
    }

    private void warn(D state, Range accessRange) {
        state.getContext().addWarning(new IllegalNumericPointerTarget(accessRange));
    }

    @Override
    public SegCompatibleState<D> makeCompatible(Segment<D> otherRaw, D state, D otherState) {
        return new SegCompatibleState<D>(this, state, otherState);
    }

    @Override
    public SegmentWithState<D> tryPrimitive(RReil.PrimOp prim, D state) {
        return null;
    }

    @Override
    public NullSegment<D> introduceRegion(MemVar region, ContentCtx ctx) {
        return new NullSegment<D>();
    }

    public String toString() {
        return "Null: --";
    }

    @Override
    public MemVarSet getChildSupportSet() {
        return MemVarSet.empty();
    }

    @Override
    public void toCompactString(StringBuilder builder, PrettyDomain childDomain) {
    }
}

