/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.segments.machine;

import bindead.abstractsyntax.finite.FiniteFactory;
import bindead.abstractsyntax.memderef.AbstractMemPointer;
import bindead.abstractsyntax.memderef.AbstractPointer;
import bindead.abstractsyntax.memderef.DerefOffset;
import bindead.abstractsyntax.memderef.ExplicitOffset;
import bindead.abstractsyntax.memderef.SymbolicOffset;
import bindead.data.Linear;
import bindead.data.MemVarSet;
import bindead.data.NumVar;
import bindead.debug.PrettyDomain;
import bindead.debug.StringHelpers;
import bindead.domainnetwork.channels.QueryChannel;
import bindead.domainnetwork.interfaces.ContentCtx;
import bindead.domainnetwork.interfaces.MemoryDomain;
import bindead.domains.segments.basics.RegionAccess;
import bindead.domains.segments.basics.SegCompatibleState;
import bindead.domains.segments.basics.Segment;
import bindead.domains.segments.basics.SegmentWithState;
import bindead.domains.segments.warnings.IllegalNumericPointerTarget;
import bindead.domains.segments.warnings.ImpreciseCallTarget;
import bindead.domains.segments.warnings.OutOfRegionBoundsAccess;
import bindead.exceptions.DomainStateException;
import bindead.exceptions.Unreachable;
import java.util.LinkedList;
import java.util.List;
import javalx.data.products.P2;
import javalx.data.products.P3;
import javalx.numeric.BigInt;
import javalx.numeric.Bound;
import javalx.numeric.FiniteRange;
import javalx.numeric.Interval;
import javalx.numeric.Range;
import javalx.persistentcollections.AVLMap;
import javalx.persistentcollections.FiniteMap;
import javalx.persistentcollections.tree.FiniteRangeTree;
import javalx.persistentcollections.tree.OverlappingRanges;
import rreil.lang.Lhs;
import rreil.lang.MemVar;
import rreil.lang.RReil;
import rreil.lang.RReilAddr;
import rreil.lang.Rhs;

public class DataSegments<D extends MemoryDomain<D>>
extends Segment<D> {
    private static final int maxJumpTargets = 100;
    public static final String NAME = "Data";
    private static final FiniteFactory fin = FiniteFactory.getInstance();
    private final AVLMap<NumVar.AddrVar, P2<BigInt, MemVar>> symbolic;
    private final AbsoluteAddresses absolute;
    private final AVLMap<MemVar, ContentCtx> pending;

    public DataSegments() {
        this.symbolic = AVLMap.empty();
        this.absolute = AbsoluteAddresses.empty();
        this.pending = AVLMap.empty();
    }

    private DataSegments(AVLMap<NumVar.AddrVar, P2<BigInt, MemVar>> addresses, AbsoluteAddresses absolute, AVLMap<MemVar, ContentCtx> pending) {
        this.symbolic = addresses;
        this.absolute = absolute;
        this.pending = pending;
    }

    @Override
    public P3<List<MemVar>, Boolean, D> initialize(D state) {
        return P3.tuple3(new LinkedList(), Boolean.FALSE, state);
    }

    @Override
    public SegmentWithState<D> triggerAssignment(Lhs lhs, Rhs rhs, D state) {
        throw new DomainStateException.InvariantViolationException();
    }

    @Override
    public List<P2<RReilAddr, SegmentWithState<D>>> resolveJump(Rhs.Lin target, AbstractMemPointer location, D state) {
        LinkedList<P2<RReilAddr, SegmentWithState<D>>> targets = new LinkedList<P2<RReilAddr, SegmentWithState<D>>>();
        Range offsets = location.getOffsetRange(state);
        if (offsets.numberOfDiscreteValues().isLessThan(BigInt.of(100L))) {
            assert (this.absolute.contains(location.region)) : "Code must be in absolute regions for now.";
            BigInt baseAddress = this.absolute.startAddressOf(location.region);
            for (BigInt offset : offsets) {
                BigInt absoluteAddress = baseAddress.add(offset);
                D jumpedToState = state;
                SegmentWithState<D> inState = new SegmentWithState<D>(this, jumpedToState);
                targets.add(P2.tuple2(RReilAddr.valueOf(absoluteAddress), inState));
            }
        } else {
            state.getContext().addWarning(new ImpreciseCallTarget(location, offsets));
        }
        return targets;
    }

    private void assertAccessInBounds(BigInt lower, BigInt upper, AbstractMemPointer location, D state) {
        Linear belowBound = location.offset.upperBound();
        Linear aboveBound = location.offset.lowerBound();
        try {
            if (belowBound != null) {
                state.eval(fin.unsignedLessThan(0, belowBound, Linear.linear(lower)));
            }
            state.getContext().addWarning(new OutOfRegionBoundsAccess.Below(location));
        }
        catch (Unreachable unreachable) {
            // empty catch block
        }
        try {
            if (aboveBound != null) {
                state.eval(fin.unsignedLessThanOrEqualTo(0, Linear.linear(upper), aboveBound));
            }
            state.getContext().addWarning(new OutOfRegionBoundsAccess.Above(location));
        }
        catch (Unreachable unreachable) {
            // empty catch block
        }
    }

    @Override
    public List<RegionAccess<D>> dereference(Rhs.Lin sourcePointerValue, AbstractPointer pointer, D state) {
        try {
            if (pointer.isAbsolute()) {
                return this.resolveAbsolute(sourcePointerValue, pointer, state);
            }
            return this.resolveSymbolic(sourcePointerValue, pointer, state);
        }
        catch (Unreachable _) {
            return null;
        }
    }

    private List<RegionAccess<D>> resolveAbsolute(Rhs.Lin sourcePointerValue, AbstractPointer pointer, D state) {
        Range accessRange = pointer.getExplicitOffset((QueryChannel)(state = state.assumePointsToAndConcretize(sourcePointerValue, null, null)));
        OverlappingRanges<MemVar> overlapping = this.absolute.searchOverlaps(accessRange.convexHull());
        if (overlapping.size() != 1 || !accessRange.isFinite()) {
            state.getContext().addWarning(new IllegalNumericPointerTarget(accessRange));
            return null;
        }
        P2<FiniteRange, MemVar> overlap = overlapping.getFirst();
        FiniteRange regionRange = overlap._1();
        BigInt regionStartAddress = regionRange.low().asInteger();
        MemVar region = overlap._2();
        Range accessOffset = accessRange.sub(regionStartAddress);
        ExplicitOffset offset = new ExplicitOffset(accessOffset);
        BigInt regionSize = regionRange.getSpan();
        return this.singleAccess(state, region, offset, regionSize);
    }

    private List<RegionAccess<D>> resolveSymbolic(Rhs.Lin sourcePointerValue, AbstractPointer pointer, D state) {
        if (!this.symbolic.contains(pointer.address)) {
            return null;
        }
        state = state.assumePointsToAndConcretize(sourcePointerValue, pointer.address, null);
        P2<BigInt, MemVar> tuple = this.symbolic.get(pointer.address).get();
        MemVar region = tuple._2();
        SymbolicOffset offset = new SymbolicOffset(pointer.offset);
        BigInt regionSize = tuple._1();
        return this.singleAccess(state, region, offset, regionSize);
    }

    private List<RegionAccess<D>> singleAccess(D state, MemVar region, DerefOffset offset, BigInt regionSize) {
        AbstractMemPointer location = new AbstractMemPointer(region, offset);
        this.assertAccessInBounds(Bound.ZERO, regionSize, location, state);
        RegionAccess<D> access = new RegionAccess<D>(location, new SegmentWithState<D>(this, state));
        return this.singleton(access);
    }

    private List<RegionAccess<D>> singleton(RegionAccess<D> access) {
        LinkedList<RegionAccess<D>> result = new LinkedList<RegionAccess<D>>();
        result.add(access);
        return result;
    }

    @Override
    public SegCompatibleState<D> makeCompatible(Segment<D> otherRaw, D state, D otherState) {
        DataSegments other = (DataSegments)otherRaw;
        assert (this.symbolic == other.symbolic);
        assert (this.absolute == other.absolute);
        assert (this.pending == other.pending);
        return new SegCompatibleState<D>(this, state, otherState);
    }

    @Override
    public SegmentWithState<D> tryPrimitive(RReil.PrimOp prim, D state) {
        if (prim.is("fixAtConstantAddress", 0, 1)) {
            MemVar region = null;
            Rhs.Rval rval = prim.getInArg(0);
            if (rval instanceof Rhs.Rvar) {
                region = ((Rhs.Rvar)rval).getRegionId();
            }
            if (region != null) {
                assert (this.pending.contains(region));
                ContentCtx ctx = this.pending.get(region).get();
                long l = ctx.getSize();
                assert (l > 0L);
                FiniteRange rangeInBytes = ctx.addressableSpaceInBytes();
                if (this.absolute.hasOverlaps(rangeInBytes)) {
                    throw new DomainStateException.InvariantViolationException();
                }
                AbsoluteAddresses newAbsolute = this.absolute.bind(region, rangeInBytes);
                return new SegmentWithState<D>(new DataSegments<D>(this.symbolic, newAbsolute, (AVLMap<MemVar, ContentCtx>)this.pending.remove((Object)region)), state);
            }
        } else if (prim.is("addressOf", 1, 1)) {
            MemVar region = null;
            Rhs.Rval rval = prim.getInArg(0);
            if (rval instanceof Rhs.Rvar) {
                region = ((Rhs.Rvar)rval).getRegionId();
            }
            if (region != null) {
                if (this.pending.contains(region)) {
                    ContentCtx ctx = this.pending.get(region).get();
                    NumVar.AddrVar addrVar = NumVar.freshAddress("&" + region.toString());
                    FiniteMap newSymbolic = this.symbolic.bind((Object)addrVar, P2.tuple2(BigInt.of(ctx.getSize()), region));
                    Lhs var = prim.getOutArg(0);
                    state = state.assignSymbolicAddressOf(var, addrVar);
                    return new SegmentWithState<D>(new DataSegments<D>((AVLMap<NumVar.AddrVar, P2<BigInt, MemVar>>)newSymbolic, this.absolute, (AVLMap<MemVar, ContentCtx>)this.pending.remove((Object)region)), state);
                }
                for (P2<NumVar.AddrVar, P2<BigInt, MemVar>> p2 : this.symbolic) {
                    if (!p2._2()._2().equals(region)) continue;
                    Lhs var = prim.getOutArg(0);
                    state = state.assignSymbolicAddressOf(var, p2._1());
                    return new SegmentWithState<D>(new DataSegments<D>(this.symbolic, this.absolute, this.pending), state);
                }
            }
        }
        return null;
    }

    @Override
    public DataSegments<D> introduceRegion(MemVar region, ContentCtx ctx) {
        return new DataSegments<D>(this.symbolic, this.absolute, (AVLMap<MemVar, ContentCtx>)this.pending.bind((Object)region, (Object)ctx));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (!this.absolute.isEmpty()) {
            builder.append("Absolute: ").append(this.absolute);
        }
        if (!this.symbolic.isEmpty()) {
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append("Symbolic: ").append(this.symbolic);
        }
        return StringHelpers.indentMultiline("Data: ", builder.toString());
    }

    @Override
    public MemVarSet getChildSupportSet() {
        MemVarSet css = MemVarSet.empty();
        for (P2<NumVar.AddrVar, P2<BigInt, MemVar>> p2 : this.symbolic) {
            css = css.insert(p2._2()._2());
        }
        css = css.insertAll(this.absolute.getChildSupportSet());
        for (P2<Comparable<NumVar>, Object> p2 : this.pending) {
            css = css.insert((MemVar)p2._1());
        }
        return css;
    }

    @Override
    public void toCompactString(StringBuilder builder, PrettyDomain childDomain) {
    }

    static class AbsoluteAddresses {
        private static final AbsoluteAddresses EMPTY = new AbsoluteAddresses();
        private final AVLMap<MemVar, FiniteRange> regions;
        private final FiniteRangeTree<MemVar> ranges;

        private AbsoluteAddresses(AVLMap<MemVar, FiniteRange> regions, FiniteRangeTree<MemVar> ranges) {
            this.regions = regions;
            this.ranges = ranges;
        }

        private AbsoluteAddresses() {
            this.ranges = FiniteRangeTree.empty();
            this.regions = AVLMap.empty();
        }

        public static AbsoluteAddresses empty() {
            return EMPTY;
        }

        public AbsoluteAddresses bind(MemVar region, FiniteRange range) {
            return new AbsoluteAddresses((AVLMap<MemVar, FiniteRange>)this.regions.bind((Object)region, (Object)range), this.ranges.bind(range, region));
        }

        public OverlappingRanges<MemVar> searchOverlaps(Interval range) {
            return this.ranges.searchOverlaps(range);
        }

        public BigInt startAddressOf(MemVar region) {
            return this.regions.get(region).get().low().asInteger();
        }

        public boolean isEmpty() {
            return this.ranges.isEmpty();
        }

        public boolean contains(MemVar region) {
            return this.regions.contains(region);
        }

        public String toString() {
            return this.ranges.toString();
        }

        public MemVarSet getChildSupportSet() {
            MemVarSet css = MemVarSet.empty();
            for (P2<MemVar, FiniteRange> p2 : this.regions) {
                css = css.insert(p2._1());
            }
            return css;
        }

        boolean hasOverlaps(FiniteRange rangeInBytes) {
            return this.ranges.hasOverlaps(rangeInBytes);
        }
    }
}

