/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.segments.heap;

import bindead.data.MemVarSet;
import bindead.data.NumVar;
import bindead.debug.PrettyDomain;
import bindead.domains.segments.heap.HeapRegion;
import javalx.data.products.P2;
import javalx.persistentcollections.AVLMap;
import rreil.lang.MemVar;

public class HeapRegionMap {
    private static final HeapRegionMap EMPTY = new HeapRegionMap();
    public final AVLMap<NumVar.AddrVar, HeapRegion> byAddress;
    public final AVLMap<MemVar, HeapRegion> fromMemVar;

    static HeapRegionMap empty() {
        return EMPTY;
    }

    private HeapRegionMap() {
        this.byAddress = AVLMap.empty();
        this.fromMemVar = AVLMap.empty();
    }

    public HeapRegionMap(AVLMap<NumVar.AddrVar, HeapRegion> a, AVLMap<MemVar, HeapRegion> m) {
        this.byAddress = a;
        this.fromMemVar = m;
    }

    public boolean contains(MemVar memVar) {
        return this.fromMemVar.contains(memVar);
    }

    public HeapRegionMap remove(NumVar.AddrVar addr) {
        HeapRegion r = this.byAddress.getOrNull(addr);
        return new HeapRegionMap((AVLMap<NumVar.AddrVar, HeapRegion>)this.byAddress.remove((Object)addr), (AVLMap<MemVar, HeapRegion>)this.fromMemVar.remove((Object)r.memId));
    }

    public HeapRegionMap bind(HeapRegion segment) {
        return new HeapRegionMap((AVLMap<NumVar.AddrVar, HeapRegion>)this.byAddress.bind((Object)segment.address, (Object)segment), (AVLMap<MemVar, HeapRegion>)this.fromMemVar.bind((Object)segment.memId, (Object)segment));
    }

    public HeapRegion get(MemVar from) {
        assert (from != null);
        return this.fromMemVar.getOrNull(from);
    }

    HeapRegion get(NumVar.AddrVar from) {
        assert (from != null);
        return this.byAddress.get(from).getOrNull();
    }

    public void toCompactString(StringBuilder builder, PrettyDomain childDomain) {
        for (P2<MemVar, HeapRegion> p2 : this.fromMemVar) {
            p2._2().toCompactString(builder, childDomain);
        }
    }

    public Iterable<MemVar> allRegions() {
        return this.fromMemVar.keys();
    }

    public MemVarSet regions() {
        return MemVarSet.empty().insertAll(this.allRegions());
    }
}

