/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.segments.heap;

import bindead.data.MemVarSet;
import bindead.debug.PrettyDomain;
import bindead.domains.segments.heap.Connector;
import bindead.domains.segments.heap.ConnectorData;
import bindead.domains.segments.heap.ConnectorId;
import bindead.domains.segments.heap.PathString;
import java.util.Iterator;
import java.util.LinkedList;
import javalx.data.products.P2;
import javalx.numeric.Range;
import javalx.persistentcollections.AVLMap;
import javalx.persistentcollections.ThreeWaySplit;
import rreil.lang.MemVar;

public class ConnectorSet
implements Iterable<Connector> {
    private static final ConnectorSet EMPTY = new ConnectorSet();
    final AVLMap<ConnectorId, ConnectorData> connectors;

    public ConnectorSet() {
        this.connectors = AVLMap.empty();
    }

    private ConnectorSet(AVLMap<ConnectorId, ConnectorData> connectors) {
        this.connectors = connectors;
    }

    @Override
    public Iterator<Connector> iterator() {
        LinkedList<Connector> r = new LinkedList<Connector>();
        for (P2<ConnectorId, ConnectorData> p2 : this.connectors) {
            r.add(new Connector(p2._1(), p2._2()));
        }
        return r.iterator();
    }

    public boolean isEmpty() {
        return this.connectors.isEmpty();
    }

    ConnectorSet add(Connector connector) {
        return this.add(connector.id, connector.data);
    }

    ConnectorSet add(ConnectorId id, ConnectorData data) {
        assert (!this.connectors.contains(id)) : "Error addding " + id + ": EdgeNodeSet already contains Data " + this.connectors.get(id);
        return new ConnectorSet((AVLMap<ConnectorId, ConnectorData>)this.connectors.bind((Object)id, (Object)data));
    }

    public String toString() {
        return this.connectors.toString();
    }

    ConnectorSet getConnectorComingFrom(MemVar from) {
        ConnectorSet m = EMPTY;
        for (P2<ConnectorId, ConnectorData> p2 : this.connectors) {
            if (!from.equals(p2._1().src)) continue;
            m = m.add(p2._1(), p2._2());
        }
        return m;
    }

    ConnectorSet getConnectorGoingTo(MemVar to) {
        ConnectorSet m = new ConnectorSet();
        for (P2<ConnectorId, ConnectorData> p2 : this.connectors) {
            if (!to.equals(p2._1().tgt)) continue;
            m = m.add(p2._1(), p2._2());
        }
        return m;
    }

    boolean contains(ConnectorId id) {
        return this.connectors.contains(id);
    }

    private static void msg(String string) {
        System.out.println("EdgeNodeSet: " + string);
    }

    ThreeWaySplit<ConnectorSet> split(ConnectorSet other) {
        ThreeWaySplit<AVLMap<ConnectorId, ConnectorData>> split = this.connectors.split(other.connectors);
        return ThreeWaySplit.make(new ConnectorSet(split.onlyInFirst()), new ConnectorSet(split.inBothButDiffering()), new ConnectorSet(split.onlyInSecond()));
    }

    public MemVarSet getChildSupportSet() {
        MemVarSet css = MemVarSet.empty();
        for (P2<ConnectorId, ConnectorData> p2 : this.connectors) {
            css = css.insertAll(p2._2().getChildSupportSet());
        }
        return css;
    }

    public static ConnectorSet empty() {
        return EMPTY;
    }

    public Connector get(ConnectorId key) {
        ConnectorData data = this.connectors.getOrNull(key);
        assert (data != null);
        return new Connector(key, data);
    }

    Connector get(MemVar src, PathString transitivePathString, MemVar tgt) {
        return this.get(new ConnectorId(src, transitivePathString, tgt));
    }

    public ConnectorSet remove(ConnectorId id) {
        return new ConnectorSet((AVLMap<ConnectorId, ConnectorData>)this.connectors.remove((Object)id));
    }

    public ConnectorSet join(ConnectorSet other) {
        return new ConnectorSet(this.connectors.union(other.connectors));
    }

    public ConnectorSet removeConnectorsFrom(MemVar mv, Range offset) {
        ConnectorSet m = EMPTY;
        for (P2<ConnectorId, ConnectorData> p2 : this.connectors) {
            if (p2._1().comesFrom(mv, offset)) continue;
            m = m.add(p2._1(), p2._2());
        }
        return m;
    }

    public ConnectorSet getEdgenodesAttachedTo(MemVar region) {
        ConnectorSet m = EMPTY;
        for (P2<ConnectorId, ConnectorData> p2 : this.connectors) {
            ConnectorId id = p2._1();
            if (!id.attachedTo(region)) continue;
            m = m.add(id, p2._2());
        }
        return m;
    }

    public void toCompactString(StringBuilder builder, PrettyDomain childDomain) {
        builder.append("Connectors\n");
        for (Connector en : this) {
            en.printCompact(builder, childDomain);
            builder.append('\n');
        }
    }
}

