/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.segments;

import bindead.abstractsyntax.memderef.AbstractMemPointer;
import bindead.data.MemVarSet;
import bindead.domainnetwork.interfaces.AnalysisCtx;
import bindead.domainnetwork.interfaces.MemoryDomain;
import bindead.domainnetwork.interfaces.RegionCtx;
import bindead.domains.segments.SegMem;
import bindead.domains.segments.SegMemState;
import bindead.domains.segments.basics.Segment;
import bindead.domains.segments.basics.SegmentWithState;
import bindead.domains.segments.warnings.PrimitiveNotFound;
import bindead.exceptions.Unreachable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javalx.mutablecollections.CollectionHelpers;
import javalx.numeric.Range;
import rreil.lang.Lhs;
import rreil.lang.MemVar;
import rreil.lang.RReil;
import rreil.lang.Rhs;
import rreil.lang.Test;
import rreil.lang.util.RhsFactory;
import rreil.lang.util.RvarExtractor;

class SegMemStateBuilder<D extends MemoryDomain<D>> {
    private static final RhsFactory imp = RhsFactory.getInstance();
    final Segment<D>[] segments;
    D childState;
    private MemVarSet explicitlyIntroducedRegions;

    SegMemStateBuilder(SegMem<D> state) {
        this.segments = ((SegMemState)state.state).cloneSegments();
        this.childState = (MemoryDomain)state.childState;
        this.explicitlyIntroducedRegions = ((SegMemState)state.state).explicitlyIntroducedRegions;
    }

    public String toString() {
        return Arrays.toString(this.segments);
    }

    SegMemState<D> build() {
        return new SegMemState<D>(this.segments, this.explicitlyIntroducedRegions);
    }

    void evalAssign(RReil.Assign stmt, Integer triggerIdx) {
        this.introduceRegisters(stmt);
        Rhs rhs = stmt.getRhs();
        Lhs lhs = stmt.getLhs();
        this.informAboutAssign(lhs.getRegionId(), Range.from(lhs.getOffset()), rhs.getRegionOrNull(), rhs.getOffsetOrTop());
        this.childState = this.childState.evalAssign(lhs, rhs);
        if (triggerIdx != null) {
            this.triggerN(triggerIdx, lhs, rhs);
        }
    }

    void evalLoadFromLocation(RReil.Load stmt, AbstractMemPointer location) {
        this.introduceRegisters(stmt);
        Lhs lhs = stmt.getLhs();
        this.build().edgenodesAreSane();
        this.informAboutAssign(lhs.getRegionId(), Range.from(lhs.getOffset()), location.region, location.getOffsetRange(this.childState));
        this.build().edgenodesAreSane();
        this.childState = this.childState.evalLoad(lhs, location);
    }

    void evalLoadTop(RReil.Load stmt) {
        this.introduceRegisters(stmt);
        Lhs lhs = stmt.getLhs();
        this.informAboutAssign(lhs.getRegionId(), Range.from(lhs.getOffset()), null, Range.ZERO);
        this.childState = this.childState.evalAssign(stmt.getLhs(), imp.top(stmt.getLhs().getSize()));
    }

    void evalPrimop(RReil.PrimOp prim) {
        AnalysisCtx context = this.childState.getContext();
        this.introduceRegisters(prim.getOutArgs());
        this.tryPrimitiveOnAll(prim);
        if (this.childState == null) {
            context.addWarning(new PrimitiveNotFound(prim));
            throw new Unreachable();
        }
    }

    private void tryPrimitiveOnAll(RReil.PrimOp prim) {
        for (int i = 0; i < this.segments.length; ++i) {
            SegmentWithState<D> res = this.segments[i].tryPrimitive(prim, this.childState);
            if (res == null) continue;
            this.segments[i] = res.segment;
            this.childState = res.state;
            return;
        }
    }

    void evalStore(AbstractMemPointer target, RReil.Store storeStmt) {
        this.introduceRegisters(storeStmt);
        Range ofs = target.getOffsetRange(this.childState);
        this.informAboutAssign(target.region, ofs, storeStmt.getRhs().getRegionOrNull(), storeStmt.getRhs().getOffsetOrTop());
        this.childState = this.childState.evalStore(target, storeStmt.getRhs());
    }

    void evalTest(Test test) {
        this.introduceRegisters(test);
        this.childState = this.childState.eval(test);
    }

    void introduceRegion(MemVar region, RegionCtx ctx) {
        if (ctx.getSegment().isSome()) {
            assert (!this.explicitlyIntroducedRegions.contains(region));
            this.explicitlyIntroducedRegions = this.explicitlyIntroducedRegions.insert(region);
            for (int i = 0; i < this.segments.length; ++i) {
                Segment<D> seg = this.segments[i];
                if ((seg = seg.introduceRegion(region, ctx.getSegment().get())) == null) continue;
                this.segments[i] = seg;
            }
        }
        this.childState = this.childState.introduceRegion(region, ctx);
    }

    void summarizeHeap() {
        for (int i = 0; i < this.segments.length; ++i) {
            SegmentWithState<D> summarized = this.segments[i].summarizeHeap(this.childState);
            this.segments[i] = summarized.segment;
            this.childState = summarized.state;
        }
    }

    void introduceRegister(Rhs.Lin value) {
        List<Rhs.Rvar> all = RvarExtractor.fromRhs(value);
        List<Rhs.Rval> inArgs = CollectionHelpers.cast(all);
        if (!inArgs.isEmpty()) {
            this.addRegisters(null, inArgs);
        }
    }

    void introduceRegister(Rhs.Rval variable) {
        List<Rhs.Rval> inArgs = Collections.singletonList(variable);
        this.addRegisters(null, inArgs);
    }

    private void introduceRegisters(List<Lhs> args) {
        if (!args.isEmpty()) {
            this.addRegisters(args, null);
        }
    }

    private void introduceRegisters(RReil insn) {
        List<Rhs.Rvar> all = RvarExtractor.getAll(insn);
        List<Rhs.Rval> inArgs = CollectionHelpers.cast(all);
        if (!inArgs.isEmpty()) {
            this.addRegisters(null, inArgs);
        }
    }

    private void introduceRegisters(Test insn) {
        List<Rhs.Rvar> all = RvarExtractor.fromRhs(insn.getComparison());
        List<Rhs.Rval> inArgs = CollectionHelpers.cast(all);
        if (!inArgs.isEmpty()) {
            this.addRegisters(null, inArgs);
        }
    }

    private void addRegisters(List<Lhs> args, List<Rhs.Rval> inArgs) {
        this.tryPrimitiveOnAll(new RReil.PrimOp("addRegisters", args, inArgs));
    }

    private void informAboutAssign(MemVar toRegion, Range toOffset, MemVar memVar, Range fromRange) {
        for (int i = 0; i < this.segments.length; ++i) {
            SegmentWithState<D> p2 = this.segments[i].informAboutAssign(this.childState, toRegion, toOffset, memVar, fromRange);
            this.segments[i] = p2.segment;
            this.childState = p2.state;
        }
    }

    private void triggerN(Integer n, Lhs lhs, Rhs rhs) {
        Segment<D> seg = this.segments[n];
        SegmentWithState<D> res = seg.triggerAssignment(lhs, rhs, this.childState);
        this.segments[n.intValue()] = res.segment;
        this.childState = res.state;
    }
}

