/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.segments;

import bindead.data.MemVarSet;
import bindead.debug.PrettyDomain;
import bindead.domainnetwork.interfaces.FunctorState;
import bindead.domainnetwork.interfaces.MemoryDomain;
import bindead.domains.segments.basics.Segment;
import com.jamesmurty.utils.XMLBuilder;
import java.util.List;
import java.util.Map;
import javalx.data.products.P3;
import rreil.lang.MemVar;

public class SegMemState<D extends MemoryDomain<D>>
extends FunctorState {
    private final Segment<D>[] segments;
    final MemVarSet explicitlyIntroducedRegions;

    public SegMemState(Segment<D>[] segments, MemVarSet explicitlyIntroducedRegions) {
        this.segments = segments;
        this.explicitlyIntroducedRegions = explicitlyIntroducedRegions;
        assert (explicitlyIntroducedRegions != null);
    }

    public D initialize(Map<MemVar, Integer> triggers, D state) {
        for (int i = 0; i < this.segments.length; ++i) {
            P3<List<MemVar>, Boolean, D> triple = this.segments[i].initialize(state);
            state = (MemoryDomain)triple._3();
            for (MemVar v : triple._1()) {
                triggers.put(v, i);
            }
        }
        return state;
    }

    @Override
    public XMLBuilder toXML(XMLBuilder builder) {
        return builder;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Segment<D> segment : this.segments) {
            builder.append(segment).append("\n");
        }
        builder.setLength(builder.length() - 1);
        return builder.toString();
    }

    Segment<D>[] cloneSegments() {
        return (Segment[])this.segments.clone();
    }

    MemVarSet getChildSupportSet() {
        MemVarSet css = this.explicitlyIntroducedRegions;
        for (Segment<D> s : this.segments) {
            css = css.insertAll(s.getChildSupportSet());
        }
        return MemVarSet.from(css);
    }

    int size() {
        return this.segments.length;
    }

    SegMemState<D> setSegmentAt(int i, Segment<D> segment) {
        Segment<D>[] segments = this.cloneSegments();
        segments[i] = segment;
        return new SegMemState<D>(segments, this.explicitlyIntroducedRegions);
    }

    Segment<D> get(int i) {
        return this.segments[i];
    }

    public boolean edgenodesAreSane() {
        for (Segment<D> s : this.segments) {
            if (s.connectorsAreSane()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void toCompactString(String domainName, StringBuilder builder, PrettyDomain childDomain) {
        for (Segment<D> seg : this.segments) {
            seg.toCompactString(builder, childDomain);
        }
    }
}

