/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.predicates.zeno;

import bindead.abstractsyntax.zeno.Zeno;
import bindead.abstractsyntax.zeno.ZenoFactory;
import bindead.abstractsyntax.zeno.util.ZenoTestHelper;
import bindead.data.Linear;
import bindead.data.VarSet;
import bindead.domainnetwork.channels.SetOfEquations;
import bindead.domainnetwork.interfaces.ZenoDomain;
import bindead.domains.predicates.zeno.PredicatesStateBuilder;
import bindead.exceptions.Unreachable;
import javalx.data.products.P2;
import javalx.persistentcollections.AVLSet;
import javalx.persistentcollections.MultiMap;

class Entailment {
    private static final ZenoFactory zeno = ZenoFactory.getInstance();

    Entailment() {
    }

    public static AVLSet<Zeno.Test> equalitiesToTests(SetOfEquations equalities) {
        AVLSet<Zeno.Test> result = AVLSet.empty();
        for (Linear equality : equalities) {
            Zeno.Test test = zeno.comparison(equality, Zeno.ZenoTestOp.EqualToZero);
            result = result.add(test);
        }
        return result;
    }

    public static AVLSet<Zeno.Test> getSyntacticallyEntailed(Zeno.Test test, PredicatesStateBuilder builder) {
        AVLSet<Object> result = AVLSet.empty();
        AVLSet<Zeno.Test> entailed1 = Entailment.getSyntacticallyForwardEntailed(test, builder);
        result = result.union(entailed1);
        AVLSet<Zeno.Test> entailed2 = Entailment.getSyntacticallyBackwardEntailed(test, builder);
        result = result.union(entailed2);
        return result;
    }

    private static AVLSet<Zeno.Test> getSyntacticallyForwardEntailed(Zeno.Test test, PredicatesStateBuilder builder) {
        AVLSet<Zeno.Test> result = AVLSet.empty();
        VarSet testVars = test.getVars();
        Iterable<Zeno.Test> predicates = builder.getAllLhsContaining(testVars);
        for (Zeno.Test predicate : predicates) {
            if (!ZenoTestHelper.isSyntacticallyEntailedBy(predicate, test)) continue;
            result = result.union(builder.getConsequences(predicate));
        }
        return result;
    }

    private static AVLSet<Zeno.Test> getSyntacticallyBackwardEntailed(Zeno.Test test, PredicatesStateBuilder builder) {
        AVLSet<Zeno.Test> result = AVLSet.empty();
        VarSet testVars = test.getVars();
        Iterable<Zeno.Test> predicates = builder.getAllRhsContaining(testVars);
        for (Zeno.Test predicate : predicates) {
            if (!ZenoTestHelper.isSyntacticallyEntailedBy(predicate.not(), test)) continue;
            result = result.union(ZenoTestHelper.negateTests(builder.getPremises(predicate)));
        }
        return result;
    }

    public static <D extends ZenoDomain<D>> AVLSet<Zeno.Test> getSemanticallyEntailed(D childState, VarSet modifiedVars, PredicatesStateBuilder builder) {
        AVLSet<Object> result = AVLSet.empty();
        AVLSet<Zeno.Test> entailed1 = Entailment.getSemanticallyForwardEntailed(childState, modifiedVars, builder);
        result = result.union(entailed1);
        AVLSet<Zeno.Test> entailed2 = Entailment.getSemanticallyBackwardEntailed(childState, modifiedVars, builder);
        result = result.union(entailed2);
        return result;
    }

    public static <D extends ZenoDomain<D>> boolean areAllImplicationsSemanticallyEntailed(Iterable<P2<Zeno.Test, Zeno.Test>> implications, D childState) {
        D newChildState = childState;
        for (P2<Zeno.Test, Zeno.Test> implication : implications) {
            Zeno.Test premise = implication._1();
            Zeno.Test consequence = implication._2();
            try {
                newChildState = childState.eval(premise);
                if (Entailment.isSemanticallyEntailedIn(consequence, newChildState)) continue;
                return false;
            }
            catch (Unreachable unreachable) {
            }
        }
        return true;
    }

    public static <D extends ZenoDomain<D>> MultiMap<Zeno.Test, Zeno.Test> getAllSemanticallyEntailedImplications(Iterable<P2<Zeno.Test, Zeno.Test>> implications, D childState) {
        MultiMap<Zeno.Test, Zeno.Test> result = MultiMap.empty();
        D newChildState = childState;
        for (P2<Zeno.Test, Zeno.Test> implication : implications) {
            Zeno.Test premise = implication._1();
            Zeno.Test consequence = implication._2();
            boolean entailed = false;
            try {
                newChildState = childState.eval(premise);
                if (Entailment.isSemanticallyEntailedIn(consequence, newChildState)) {
                    entailed = true;
                }
            }
            catch (Unreachable _) {
                entailed = true;
            }
            if (!entailed) continue;
            result = result.add(premise, consequence);
        }
        return result;
    }

    private static <D extends ZenoDomain<D>> AVLSet<Zeno.Test> getSemanticallyForwardEntailed(D childState, VarSet modifiedVars, PredicatesStateBuilder builder) {
        AVLSet<Zeno.Test> result = AVLSet.empty();
        Iterable<Zeno.Test> predicates = modifiedVars.isEmpty() ? builder.getAllLhs() : builder.getAllLhsContaining(modifiedVars);
        for (Zeno.Test predicate : predicates) {
            if (!Entailment.isSemanticallyEntailedIn(predicate, childState)) continue;
            result = result.union(builder.getConsequences(predicate));
        }
        return result;
    }

    private static <D extends ZenoDomain<D>> AVLSet<Zeno.Test> getSemanticallyBackwardEntailed(D childState, VarSet modifiedVars, PredicatesStateBuilder builder) {
        AVLSet<Zeno.Test> result = AVLSet.empty();
        Iterable<Zeno.Test> predicates = modifiedVars.isEmpty() ? builder.getAllRhs() : builder.getAllRhsContaining(modifiedVars);
        for (Zeno.Test predicate : predicates) {
            if (!Entailment.isNegationSemanticallyEntailedIn(predicate, childState)) continue;
            result = result.union(ZenoTestHelper.negateTests(builder.getPremises(predicate)));
        }
        return result;
    }

    private static <D extends ZenoDomain<D>> boolean isSemanticallyEntailedIn(Zeno.Test test, D childState) {
        return Entailment.isNegationSemanticallyEntailedIn(test.not(), childState);
    }

    private static <D extends ZenoDomain<D>> boolean isNegationSemanticallyEntailedIn(Zeno.Test test, D childState) {
        try {
            childState.eval(test);
        }
        catch (Unreachable _) {
            return true;
        }
        return false;
    }
}

