/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.predicates.finite;

import bindead.abstractsyntax.finite.Finite;
import bindead.abstractsyntax.finite.util.FiniteTestSimplifier;
import bindead.data.FoldMap;
import bindead.data.Linear;
import bindead.data.NumVar;
import bindead.data.VarPair;
import bindead.data.VarSet;
import bindead.domainnetwork.channels.QueryChannel;
import bindead.domainnetwork.combinators.FiniteStateBuilder;
import bindead.domainnetwork.interfaces.FiniteDomain;
import bindead.domains.affine.Substitution;
import bindead.domains.predicates.finite.PredicatesState;
import java.util.List;
import javalx.fn.Predicate;
import javalx.mutablecollections.CollectionHelpers;
import javalx.numeric.BigInt;
import javalx.numeric.Bound;
import javalx.persistentcollections.AVLSet;

public class PredicatesStateBuilder
extends FiniteStateBuilder {
    private final PredicatesState.MutableState state;
    private final QueryChannel childState;

    public PredicatesStateBuilder(PredicatesState state, QueryChannel childState) {
        this.state = state.toMutable();
        this.childState = childState;
    }

    public PredicatesState build() {
        return this.state.toImmutable();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Childops: ");
        builder.append(this.getChildOps());
        builder.append('\n');
        builder.append(this.state);
        return builder.toString();
    }

    protected boolean isFlag(NumVar flag) {
        return this.state.isFlag(flag);
    }

    protected boolean isPredicatesVar(NumVar var) {
        return this.state.isPredicatesVar(var);
    }

    protected AVLSet<Finite.Test> getPredicates(NumVar flag, boolean flagValuation) {
        return this.state.getPredicates(flag, flagValuation);
    }

    protected AVLSet<Finite.Test> getPredicates(PredicatesState.Flag flag) {
        return this.state.getPredicates(flag);
    }

    protected AVLSet<PredicatesState.Flag> getOccurrencesOf(VarSet predicateVars) {
        AVLSet<PredicatesState.Flag> occurences = AVLSet.empty();
        for (NumVar var : predicateVars) {
            occurences = occurences.union(this.state.getOccurrencesOf(var));
        }
        return occurences;
    }

    protected AVLSet<PredicatesState.Flag> getFlagsFromVars(VarSet vars) {
        return this.state.getFlagsFromVars(vars);
    }

    protected void assignPredicateToFlag(NumVar flag, Finite.Test test) {
        this.removePredicatesContaining(flag);
        VarSet predicateVars = test.getVars();
        this.removeFlags(predicateVars);
        if (predicateVars.contains(flag)) {
            this.projectFlag(flag, predicateVars);
            return;
        }
        this.projectFlag(flag, predicateVars);
        this.state.addPredicate(flag, true, test);
        this.state.addPredicate(flag, false, test.not());
    }

    protected void assignPredicatesToFlag(NumVar flag, AVLSet<Finite.Test> truePredicates, AVLSet<Finite.Test> falsePredicates) {
        VarSet predicatesVars = PredicatesState.getVariablesInPredicates(truePredicates).union(PredicatesState.getVariablesInPredicates(falsePredicates));
        this.removePredicatesContaining(flag);
        this.removeFlags(predicatesVars);
        if (predicatesVars.contains(flag)) {
            this.projectFlag(flag, predicatesVars);
            return;
        }
        this.projectFlag(flag, predicatesVars);
        for (Finite.Test test : truePredicates) {
            this.state.addPredicate(flag, true, test);
        }
        for (Finite.Test test : falsePredicates) {
            this.state.addPredicate(flag, false, test);
        }
    }

    protected void assignCopy(NumVar targetFlag, NumVar sourceFlag) {
        if (targetFlag.equalTo(sourceFlag)) {
            return;
        }
        this.projectFlag(targetFlag, VarSet.of(sourceFlag));
        this.state.copyFlagPredicates(targetFlag, sourceFlag);
    }

    protected void assignNegatedCopy(NumVar targetFlag, NumVar sourceFlag) {
        if (targetFlag.equalTo(sourceFlag)) {
            this.state.negateFlag(sourceFlag);
            return;
        }
        this.project(targetFlag, VarSet.of(sourceFlag));
        this.state.copyFlagPredicatesNegated(targetFlag, sourceFlag);
    }

    private void projectFlag(NumVar flag, VarSet forbiddenSubstitutionVariables) {
        assert (!this.isPredicatesVar(flag));
        if (!this.isFlag(flag)) {
            return;
        }
        forbiddenSubstitutionVariables = forbiddenSubstitutionVariables.union(this.state.getVariablesInPredicatesOf(flag));
        this.tryFlagSubstitution(flag, forbiddenSubstitutionVariables);
        this.removeFlag(flag);
    }

    protected void project(NumVar var, VarSet forbiddenSubstitutionVariables) {
        if (this.isFlag(var)) {
            this.tryFlagSubstitution(var, forbiddenSubstitutionVariables);
            this.removeFlag(var);
        } else if (this.isPredicatesVar(var)) {
            this.tryPredicatesVarSubstitution(var);
            this.removePredicatesContaining(var);
        }
    }

    protected void project(NumVar var) {
        this.project(var, VarSet.empty());
    }

    protected void substitute(NumVar x, NumVar y) {
        if (this.isFlag(x) && (this.isFlag(y) || !this.isPredicatesVar(y))) {
            this.state.substituteFlag(x, y);
            return;
        }
        if (this.isPredicatesVar(x) && this.isPredicatesVar(y)) {
            this.tryPredicatesVarSubstitution(x, y);
            this.removePredicatesContaining(x);
            return;
        }
        this.removeFlag(x);
        this.removeFlag(y);
        this.removePredicatesContaining(x);
        this.removePredicatesContaining(y);
    }

    protected void copyAndPaste(VarSet vars, PredicatesStateBuilder from) {
        assert (!this.state.getAllFlagVars().union(this.state.getAllPredicateVars()).containsAny(vars));
        for (NumVar varToCopy : vars) {
            AVLSet<Finite.Test> truePredicatesToCopy = from.getPredicates(varToCopy, true);
            truePredicatesToCopy = PredicatesStateBuilder.filterContaining(truePredicatesToCopy, vars);
            AVLSet<Finite.Test> falsePredicatesToCopy = from.getPredicates(varToCopy, false);
            falsePredicatesToCopy = PredicatesStateBuilder.filterContaining(falsePredicatesToCopy, vars);
            this.assignPredicatesToFlag(varToCopy, truePredicatesToCopy, falsePredicatesToCopy);
        }
    }

    private static AVLSet<Finite.Test> filterContaining(AVLSet<Finite.Test> predicates, final VarSet vars) {
        return CollectionHelpers.filter(predicates, new Predicate<Finite.Test>(){

            @Override
            public Boolean apply(Finite.Test test) {
                return vars.containsAll(test.getVars());
            }
        });
    }

    protected void intersect(PredicatesStateBuilder other) {
        this.state.intersect(other.state);
    }

    protected <D extends FiniteDomain<D>> boolean isSubset(D thisChildState, PredicatesStateBuilder other) {
        return PredicatesState.MutableState.isEntailed(other.state, this.state, thisChildState);
    }

    protected <D extends FiniteDomain<D>> PredicatesStateBuilder join(PredicatesStateBuilder other, D thisChildState, D otherChildState) {
        PredicatesState.MutableState entailedThisInOther = PredicatesState.MutableState.getEntailed(this.state, other.state, otherChildState);
        PredicatesState.MutableState entailedOtherInThis = PredicatesState.MutableState.getEntailed(other.state, this.state, thisChildState);
        entailedThisInOther.union(entailedOtherInThis);
        return new PredicatesStateBuilder(entailedThisInOther.toImmutable(), thisChildState);
    }

    protected void renameFold(FoldMap pairs) {
        for (VarPair pair : pairs) {
            this.rename((NumVar)pair.getEphemeral(), (NumVar)pair.getPermanent());
        }
    }

    public void renameExpand(List<VarPair> nvps) {
        for (VarPair pair : nvps) {
            this.rename((NumVar)pair.getPermanent(), (NumVar)pair.getEphemeral());
        }
    }

    private void rename(NumVar x, NumVar y) {
        if (this.isFlag(x)) {
            this.state.copyFlagPredicates(y, x);
            this.removeFlag(x);
        } else if (this.isPredicatesVar(x)) {
            Substitution substitution = new Substitution(x, Linear.linear(y), Bound.ONE);
            this.applyPredicatesSubstitution(substitution);
        }
    }

    protected void union(PredicatesStateBuilder other) {
        this.state.union(other.state);
    }

    protected void applyPredicatesSubstitution(Substitution substitution) {
        for (PredicatesState.Flag flag : this.state.getOccurrencesOf(substitution.getVar())) {
            AVLSet<Finite.Test> oldPredicates = this.state.getPredicates(flag);
            AVLSet<Finite.Test> newPredicates = AVLSet.empty();
            for (Finite.Test oldPredicate : oldPredicates) {
                if (!oldPredicate.getVars().contains(substitution.getVar())) {
                    newPredicates = newPredicates.add(oldPredicate);
                    continue;
                }
                Finite.Test newPredicate = oldPredicate.applySubstitution(substitution);
                if (!oldPredicate.equals(newPredicate)) {
                    newPredicate = FiniteTestSimplifier.normalizeTautology(newPredicate);
                }
                newPredicates = newPredicates.add(newPredicate);
            }
            VarSet oldVars = PredicatesState.getVariablesInPredicates(oldPredicates);
            VarSet newVars = PredicatesState.getVariablesInPredicates(newPredicates);
            VarSet removedVars = oldVars.difference(newVars);
            for (NumVar var : removedVars) {
                this.state.removeVariableOccurrenceInPredicatesOf(flag, var);
            }
            VarSet addedVars = newVars.difference(oldVars);
            for (NumVar var : addedVars) {
                this.state.addVariableOccurrenceInPredicatesOf(flag, var);
            }
            this.state.setPredicates(flag, newPredicates);
        }
    }

    private void removeFlag(NumVar flag) {
        if (!this.isFlag(flag)) {
            return;
        }
        this.state.removeFlag(flag);
    }

    private void removeFlags(VarSet flags) {
        for (NumVar flag : flags) {
            this.removeFlag(flag);
        }
    }

    private void removePredicatesContaining(NumVar var) {
        this.state.removePredicatesContaining(var);
    }

    private void tryFlagSubstitution(NumVar flag, VarSet forbiddenSubstitutionVariables) {
        AVLSet<Substitution> allSubstitutions = this.state.generateSubstitutionsFor(flag, this.childState);
        AVLSet<Object> usefulSubstitutions = AVLSet.empty();
        for (Substitution substitution : allSubstitutions) {
            NumVar y;
            if (!substitution.isSimple() || forbiddenSubstitutionVariables.contains(y = substitution.getExpr().getSingleVarOrNull()) || this.isPredicatesVar(y)) continue;
            usefulSubstitutions = AVLSet.singleton(substitution);
            break;
        }
        if (!usefulSubstitutions.isEmpty()) {
            Substitution substitution = (Substitution)usefulSubstitutions.getMin().get();
            assert (substitution.getFac().isOne());
            NumVar y = substitution.getExpr().getSingleVarOrNull();
            assert (y != null);
            this.state.substituteFlag(flag, y);
        }
    }

    private void tryPredicatesVarSubstitution(NumVar var) {
        AVLSet<Substitution> allSubstitutions = this.state.generateSubstitutionsFor(var, this.childState);
        AVLSet<Object> usefulSubstitutions = AVLSet.empty();
        for (Substitution substitution : allSubstitutions) {
            boolean isUseful = true;
            for (NumVar substituteVar : substitution.getExpr().getVars()) {
                if (!this.isFlag(substituteVar)) continue;
                isUseful = false;
                break;
            }
            if (!isUseful) continue;
            usefulSubstitutions = AVLSet.singleton(substitution);
            break;
        }
        if (!usefulSubstitutions.isEmpty()) {
            Substitution substitution = (Substitution)usefulSubstitutions.getMin().get();
            this.applyPredicatesSubstitution(substitution);
        }
    }

    private void tryPredicatesVarSubstitution(NumVar x, NumVar y) {
        assert (!x.equalTo(y));
        Substitution substitution = new Substitution(x, Linear.linear(y), BigInt.ONE);
        this.applyPredicatesSubstitution(substitution);
    }
}

