/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.predicates.finite;

import bindead.abstractsyntax.finite.Finite;
import bindead.analyses.algorithms.AnalysisProperties;
import bindead.data.FoldMap;
import bindead.data.ListVarPair;
import bindead.data.NumVar;
import bindead.data.VarPair;
import bindead.data.VarSet;
import bindead.domainnetwork.channels.QueryChannel;
import bindead.domainnetwork.channels.SetOfEquations;
import bindead.domainnetwork.channels.SynthChannel;
import bindead.domainnetwork.combinators.FiniteFunctor;
import bindead.domainnetwork.interfaces.FiniteDomain;
import bindead.domains.predicates.PredicatesProperties;
import bindead.domains.predicates.finite.Entailment;
import bindead.domains.predicates.finite.PredicatesAssignmentVisitor;
import bindead.domains.predicates.finite.PredicatesState;
import bindead.domains.predicates.finite.PredicatesStateBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javalx.data.products.P2;
import javalx.data.products.P3;
import javalx.persistentcollections.AVLSet;

public class Predicates<D extends FiniteDomain<D>>
extends FiniteFunctor<PredicatesState, D, Predicates<D>> {
    public static final String NAME = "PREDICATES(F)";
    private final boolean DEBUGASSIGN;
    private final boolean DEBUGBINARIES;
    private final boolean DEBUGSUBSET;
    private final boolean DEBUGOTHER;
    private final SetOfEquations newEqualities;

    public Predicates(D child) {
        this(PredicatesState.EMPTY, child, SetOfEquations.empty());
    }

    private Predicates(PredicatesState state, D childState, SetOfEquations newEqualities) {
        super(NAME, state, childState);
        this.DEBUGASSIGN = PredicatesProperties.INSTANCE.debugAssignments.isTrue();
        this.DEBUGBINARIES = PredicatesProperties.INSTANCE.debugBinaryOperations.isTrue();
        this.DEBUGSUBSET = PredicatesProperties.INSTANCE.debugSubsetOrEqual.isTrue();
        this.DEBUGOTHER = PredicatesProperties.INSTANCE.debugOther.isTrue();
        this.newEqualities = newEqualities;
    }

    private Predicates<D> build(PredicatesState state, D childState, SetOfEquations newEqualities) {
        return new Predicates<D>(state, childState, newEqualities);
    }

    @Override
    public Predicates<D> build(PredicatesState state, D childState) {
        return this.build(state, childState, SetOfEquations.empty());
    }

    @Override
    public P3<PredicatesState, D, D> makeCompatible(Predicates<D> other, boolean isWideningPoint) {
        PredicatesStateBuilder thisBuilder = new PredicatesStateBuilder((PredicatesState)this.state, (QueryChannel)((Object)this.childState));
        PredicatesStateBuilder otherBuilder = new PredicatesStateBuilder((PredicatesState)other.state, (QueryChannel)((Object)other.childState));
        PredicatesStateBuilder joinedBuilder = otherBuilder.join(thisBuilder, (FiniteDomain)other.childState, (FiniteDomain)this.childState);
        return P3.tuple3(joinedBuilder.build(), this.childState, other.childState);
    }

    @Override
    public Predicates<D> addToState(Predicates<D> newState, boolean isWideningPoint) {
        FiniteDomain collectedChild;
        if (newState == this) {
            this.debugSubsetOrEqual(isWideningPoint, true);
            return null;
        }
        PredicatesStateBuilder thisBuilder = new PredicatesStateBuilder((PredicatesState)this.state, (QueryChannel)((Object)this.childState));
        PredicatesStateBuilder otherBuilder = new PredicatesStateBuilder((PredicatesState)newState.state, (QueryChannel)((Object)newState.childState));
        boolean isSubset = otherBuilder.isSubset((FiniteDomain)newState.childState, thisBuilder);
        if (this.DEBUGSUBSET) {
            System.out.println("PREDICATES(F) (subset): " + isSubset);
            System.out.println("    fst: " + this.state);
            System.out.println("    other: " + newState.state);
        }
        if ((collectedChild = (FiniteDomain)((FiniteDomain)this.childState).addToState(newState.childState, isWideningPoint)) == null) {
            if (isSubset) {
                return null;
            }
            collectedChild = (FiniteDomain)this.childState;
        }
        PredicatesStateBuilder joinedBuilder = otherBuilder.join(thisBuilder, (FiniteDomain)newState.childState, (FiniteDomain)this.childState);
        Predicates<FiniteDomain> result = this.build(joinedBuilder.build(), (D)collectedChild);
        if (this.DEBUGBINARIES) {
            System.out.println("PREDICATES(F) (join):");
            System.out.println("    fst: " + this.state);
            System.out.println("    other: " + newState.state);
            System.out.println("  join: " + result);
        }
        return result;
    }

    @Override
    public Predicates<D> eval(Finite.Assign assign) {
        PredicatesStateBuilder builder = new PredicatesStateBuilder((PredicatesState)this.state, (QueryChannel)((Object)this.childState));
        Finite.Assign stmt = PredicatesAssignmentVisitor.run(assign, builder);
        if (this.DEBUGASSIGN) {
            System.out.println(this.name + ":");
            System.out.println("  evaluating: " + assign + " that is: " + stmt);
            System.out.println("  before: " + this.state);
            System.out.println("  after: " + builder.build());
        }
        FiniteDomain newChildState = builder.applyChildOps((FiniteDomain)this.childState);
        newChildState = newChildState.eval(stmt);
        return this.build(builder.build(), (D)newChildState);
    }

    @Override
    public Predicates<D> eval(Finite.Test stmt) {
        PredicatesStateBuilder builder = new PredicatesStateBuilder((PredicatesState)this.state, (QueryChannel)((Object)this.childState));
        P2<FiniteDomain, SetOfEquations> result = this.fixApply(stmt, (FiniteDomain)this.childState, builder, new HashSet<Finite.Test>());
        FiniteDomain newChildState = result._1();
        SetOfEquations newEqualities = result._2();
        return this.build(builder.build(), newChildState, newEqualities);
    }

    private P2<D, SetOfEquations> fixApply(Finite.Test test, D state, PredicatesStateBuilder builder, Set<Finite.Test> alreadyAppliedTests) {
        if (AnalysisProperties.INSTANCE.debugTests.isTrue().booleanValue()) {
            System.out.println("Predicates test: " + test);
        }
        Object newChildState = state.eval(test);
        alreadyAppliedTests.add(test);
        AVLSet<Object> newImpliedTests = AVLSet.empty();
        newImpliedTests = newImpliedTests.union(Entailment.getSyntacticallyEntailed(test, builder));
        SetOfEquations newEqualities = newChildState.getSynthChannel().getEquations();
        for (Finite.Test test2 : Entailment.equalitiesToTests(newEqualities)) {
            if (alreadyAppliedTests.contains(test2)) continue;
            newImpliedTests = newImpliedTests.union(Entailment.getSyntacticallyEntailed(test2, builder));
        }
        for (Finite.Test test3 : newImpliedTests) {
            if (alreadyAppliedTests.contains(test3)) continue;
            P2 result = this.fixApply(test3, newChildState, builder, alreadyAppliedTests);
            newChildState = (FiniteDomain)result._1();
            newEqualities = newEqualities.union(result._2());
        }
        return P2.tuple2(newChildState, newEqualities);
    }

    @Override
    public Predicates<D> project(NumVar variable) {
        PredicatesStateBuilder builder = new PredicatesStateBuilder((PredicatesState)this.state, (QueryChannel)((Object)this.childState));
        builder.project(variable);
        if (this.DEBUGOTHER) {
            System.out.println(this.name + ":");
            System.out.println("  projecting: " + variable);
            System.out.println("  before: " + this.state);
            System.out.println("  after: " + builder.build());
        }
        Object newChildState = ((FiniteDomain)this.childState).project(variable);
        return this.build(builder.build(), newChildState);
    }

    @Override
    public Predicates<D> substitute(NumVar x, NumVar y) {
        PredicatesStateBuilder builder = new PredicatesStateBuilder((PredicatesState)this.state, (QueryChannel)((Object)this.childState));
        builder.substitute(x, y);
        if (this.DEBUGOTHER) {
            System.out.println(this.name + ":");
            System.out.println("  substitute: [" + x + "\\" + y + "]");
            System.out.println("  before: " + this.state);
            System.out.println("  after: " + builder.build());
        }
        Object newChildState = ((FiniteDomain)this.childState).substitute(x, y);
        return this.build(builder.build(), newChildState);
    }

    @Override
    public Predicates<D> copyAndPaste(VarSet vars, Predicates<D> from) {
        FiniteDomain newChildState = ((FiniteDomain)this.childState).copyAndPaste(vars, (FiniteDomain)from.childState);
        PredicatesStateBuilder builder = new PredicatesStateBuilder((PredicatesState)this.state, newChildState);
        builder.copyAndPaste(vars, new PredicatesStateBuilder((PredicatesState)from.state, (QueryChannel)((Object)from.childState)));
        return this.build(builder.build(), (D)newChildState);
    }

    @Override
    public SynthChannel getSynthChannel() {
        SynthChannel synth = super.getSynthChannel();
        synth.addEquations(this.newEqualities);
        return synth;
    }

    @Override
    public Predicates<D> copyVariable(NumVar to, NumVar from) {
        PredicatesState built = this.copyPredicatesOfVariable(to, from);
        Object newChildState = ((FiniteDomain)this.childState).copyVariable(to, from);
        return this.build(built, newChildState);
    }

    private PredicatesState copyPredicatesOfVariable(NumVar to, NumVar from) {
        PredicatesStateBuilder builder = new PredicatesStateBuilder((PredicatesState)this.state, (QueryChannel)((Object)this.childState));
        if (builder.isFlag(from)) {
            builder.assignCopy(to, from);
        } else {
            builder.project(to);
        }
        PredicatesState built = builder.build();
        return built;
    }

    @Override
    public Predicates<D> assumeEdgeNG(Finite.Rlin pointerVar, NumVar.AddrVar targetAddr) {
        return this.build((PredicatesState)this.state, ((FiniteDomain)this.childState).assumeEdgeNG(pointerVar, targetAddr));
    }

    @Override
    public Predicates<D> expandNG(ListVarPair nvps) {
        Object newChildState = ((FiniteDomain)this.childState).expandNG(nvps);
        PredicatesState built = this.expandOnState(nvps, newChildState);
        return this.build(built, newChildState);
    }

    @Override
    public Predicates<D> expandNG(NumVar.AddrVar p, NumVar.AddrVar e, ListVarPair nvps) {
        Object newChildState = ((FiniteDomain)this.childState).expandNG(p, e, nvps);
        PredicatesState built = this.expandOnState(nvps, newChildState);
        return this.build(built, newChildState);
    }

    @Override
    public Predicates<D> foldNG(ListVarPair nvps) {
        Object newChildState = ((FiniteDomain)this.childState).foldNG(nvps);
        PredicatesState built = this.foldOnState(nvps, newChildState);
        return this.build(built, newChildState);
    }

    @Override
    public Predicates<D> foldNG(NumVar.AddrVar p, NumVar.AddrVar e, ListVarPair nvps) {
        Object newChildState = ((FiniteDomain)this.childState).foldNG(p, e, nvps);
        PredicatesState built = this.foldOnState(nvps, newChildState);
        return this.build(built, newChildState);
    }

    private PredicatesState foldOnState(List<VarPair> nvps, D newChildState) {
        FoldMap pairs = FoldMap.fromList(nvps);
        PredicatesStateBuilder oldStateBuilder = new PredicatesStateBuilder((PredicatesState)this.state, (QueryChannel)newChildState);
        PredicatesStateBuilder newStateBuilder = new PredicatesStateBuilder((PredicatesState)this.state, (QueryChannel)newChildState);
        newStateBuilder.renameFold(pairs);
        newStateBuilder.intersect(oldStateBuilder);
        return newStateBuilder.build();
    }

    private PredicatesState expandOnState(List<VarPair> nvps, D newChildState) {
        PredicatesStateBuilder oldStateBuilder = new PredicatesStateBuilder((PredicatesState)this.state, (QueryChannel)newChildState);
        PredicatesStateBuilder newStateBuilder = new PredicatesStateBuilder((PredicatesState)this.state, (QueryChannel)newChildState);
        newStateBuilder.renameExpand(nvps);
        newStateBuilder.union(oldStateBuilder);
        PredicatesState built = newStateBuilder.build();
        return built;
    }

    @Override
    public Predicates<D> concretizeAndDisconnectNG(NumVar.AddrVar s, VarSet cs) {
        return this.build((PredicatesState)this.state, ((FiniteDomain)this.childState).concretizeAndDisconnectNG(s, cs));
    }

    @Override
    public Predicates<D> bendBackGhostEdgesNG(NumVar.AddrVar s, NumVar.AddrVar c, VarSet svs, VarSet cvs, VarSet pts, VarSet ptc) {
        return this.build((PredicatesState)this.state, ((FiniteDomain)this.childState).bendBackGhostEdgesNG(s, c, svs, cvs, pts, ptc));
    }

    @Override
    public Predicates<D> bendGhostEdgesNG(NumVar.AddrVar summary, NumVar.AddrVar concrete, VarSet svs, VarSet cvs, VarSet pts, VarSet ptc) {
        return this.build((PredicatesState)this.state, ((FiniteDomain)this.childState).bendGhostEdgesNG(summary, concrete, svs, cvs, pts, ptc));
    }

    @Override
    public Predicates<D> assumeVarsAreEqual(int size, NumVar fst, NumVar snd) {
        Object newChildState = ((FiniteDomain)this.childState).assumeVarsAreEqual(size, fst, snd);
        return this.build((PredicatesState)this.state, newChildState);
    }
}

