/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.pointsto;

import bindead.abstractsyntax.finite.Finite;
import bindead.abstractsyntax.finite.FiniteFactory;
import bindead.abstractsyntax.finite.util.FiniteTestSimplifier;
import bindead.data.Linear;
import bindead.data.NumVar;
import bindead.domainnetwork.channels.WarningsContainer;
import bindead.domainnetwork.interfaces.FiniteDomain;
import bindead.domains.pointsto.HyperPointsToSet;
import bindead.domains.pointsto.PointsToProperties;
import bindead.domains.pointsto.PointsToStateBuilder;
import bindead.exceptions.Unreachable;
import javalx.data.products.P2;

class TestTranslator<D extends FiniteDomain<D>> {
    private final FiniteFactory fin = FiniteFactory.getInstance();
    private final boolean DEBUG;
    private final PointsToStateBuilder<D> builder;
    private final WarningsContainer warningsChannel;
    D resulting;

    TestTranslator(PointsToStateBuilder<D> builder, WarningsContainer wc) {
        this.DEBUG = PointsToProperties.INSTANCE.debugOther.isTrue();
        this.resulting = null;
        assert (builder != null);
        this.builder = builder;
        this.warningsChannel = wc;
    }

    private void msg(String s) {
        if (this.DEBUG) {
            System.out.println("TestTranslator: " + s);
        }
    }

    D run(D remaining, Finite.Test test, HyperPointsToSet left, HyperPointsToSet right) {
        Linear leftOffset = left.getLinearOffset().getLinearTerm();
        Linear rightOffset = right.getLinearOffset().getLinearTerm();
        this.resulting = null;
        remaining = this.splitoffNegativeFlags(left, remaining);
        remaining = this.splitoffNegativeFlags(right, remaining);
        Linear allFlagSum = left.sumOfFlags.add(right.sumOfFlags);
        D scalarState = this.statesWithZeroFlagsOnly(remaining, allFlagSum);
        Finite.Test wrappingTest = test.build(leftOffset, rightOffset);
        scalarState = this.runTest(wrappingTest, scalarState);
        Finite.Test flagsTest = this.fin.notEqualToZero(this.fin.linear(0, allFlagSum));
        Object nonscalarState = null;
        nonscalarState = this.runTest(flagsTest, remaining);
        if (nonscalarState != null) {
            Finite.Rlin difference = this.fin.linear(test.getSize(), test.toLinear());
            HyperPointsToSet hpts = this.builder.translate(test.getSize(), difference, this.warningsChannel);
            for (P2<NumVar.AddrVar, Linear> p2 : hpts.coefficients) {
                Linear x = p2._2();
                this.resulting = this.maybeJoin(this.resulting, this.runTest(this.fin.notEqualToZero(this.fin.linear(0, x)), nonscalarState));
                nonscalarState = this.statesWithZeroFlagsOnly(nonscalarState, x);
            }
            nonscalarState = this.runTest(test.build(0, leftOffset, rightOffset), nonscalarState);
        }
        this.resulting = this.maybeJoin(this.resulting, scalarState);
        this.resulting = this.maybeJoin(this.resulting, nonscalarState);
        return this.resulting;
    }

    private D statesWithZeroFlagsOnly(D s, Linear l) {
        D s2 = this.runTest(this.fin.equalToZero(this.fin.linear(0, l)), s);
        return s2;
    }

    private D splitoffNegativeFlags(HyperPointsToSet hpts, D s) {
        for (P2<NumVar.AddrVar, Linear> p2 : hpts.getTerms()) {
            Linear x = p2._2();
            s = this.runTest(this.fin.unsignedLessThanOrEqualTo(0, Linear.ZERO, x), s);
            D bogo = this.runTest(this.fin.unsignedLessThan(0, x, Linear.ZERO), s);
            this.resulting = this.maybeJoin(this.resulting, bogo);
        }
        return s;
    }

    private D runTest(Finite.Test test, D state) {
        if (state == null) {
            return null;
        }
        try {
            if (!FiniteTestSimplifier.isTautologyReportUnreachable(test)) {
                return state.eval(test);
            }
        }
        catch (Unreachable u) {
            return null;
        }
        return state;
    }

    D maybeJoin(D a, D b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return (D)((FiniteDomain)a.join(b));
    }
}

