/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.pointsto;

import bindead.abstractsyntax.finite.Finite;
import bindead.data.Linear;
import bindead.data.NumVar;
import bindead.data.VarSet;
import bindead.debug.PrettyDomain;
import bindead.debug.StringHelpers;
import bindead.domainnetwork.channels.WarningsContainer;
import bindead.domainnetwork.interfaces.FunctorState;
import bindead.domains.pointsto.HyperPointsToSet;
import bindead.domains.pointsto.PointsToMap;
import bindead.domains.pointsto.PointsToSet;
import bindead.domains.pointsto.RhsTranslator;
import bindead.exceptions.DomainStateException;
import com.jamesmurty.utils.XMLBuilder;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import javalx.data.Option;

public class PointsToState
extends FunctorState {
    public static final PointsToState EMPTY = new PointsToState();
    private final PointsToMap pointsToMap;

    private PointsToState() {
        this(new PointsToMap());
    }

    PointsToState(PointsToMap pts) {
        this.pointsToMap = pts;
    }

    PointsToMap getPointsToMap() {
        return this.pointsToMap;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        SortedSet<PointsToSet> sorted = StringHelpers.sortLexically(this.pointsToMap);
        Iterator iterator = sorted.iterator();
        builder.append("#");
        builder.append(this.pointsToMap.pointersCount());
        builder.append(" {");
        while (iterator.hasNext()) {
            PointsToSet pts = (PointsToSet)iterator.next();
            if (pts.isBoring()) continue;
            builder.append(pts.var);
            builder.append("=");
            builder.append(pts);
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        return builder.append('}').toString();
    }

    @Override
    public XMLBuilder toXML(XMLBuilder builder) {
        XMLBuilder xml = builder;
        xml = xml.e("POINTSTO");
        for (PointsToSet pts : this.pointsToMap) {
            if (pts.isBoring()) continue;
            xml = xml.e("Entry").e("Variable").t(pts.var.toString()).up();
            xml = xml.e("pointer");
            for (PointsToSet.PointsToEntry entry : pts) {
                xml = xml.e("flag").t(entry.flag.toString()).up().e("address").t(entry.address.toString()).up();
            }
            if (!pts.sumOfFlags.isConstantZero()) {
                xml = xml.e("flagsSum").t(pts.sumOfFlags.numVar.toString()).up();
            }
            xml = xml.up().up();
        }
        xml = xml.up();
        return xml;
    }

    VarSet varsNotExportingEqualities() {
        VarSet vars = VarSet.empty();
        for (PointsToSet pts : this.pointsToMap) {
            vars = vars.union(pts.varsNotExportingEqualities());
        }
        return vars;
    }

    VarSet varsInChildDomain() {
        VarSet vars = VarSet.empty();
        for (PointsToSet pts : this.pointsToMap) {
            vars = vars.union(pts.varsInChildDomain());
        }
        return vars;
    }

    final boolean hasPts(NumVar var) {
        return this.pointsToMap.get(var).isSome();
    }

    final PointsToSet getPts(NumVar var) {
        Option<PointsToSet> pts = this.pointsToMap.get(var);
        if (pts.isNone()) {
            throw new DomainStateException.VariableSupportSetException();
        }
        return pts.get();
    }

    final boolean isLocal(NumVar var) {
        return !this.pointsToMap.contains(var);
    }

    final boolean isScalar(NumVar var) {
        return this.getPts(var).isScalar();
    }

    final boolean isScalar(Linear lin) {
        VarSet linvars = lin.getVars();
        for (NumVar var : linvars) {
            if (this.isScalar(var)) continue;
            return false;
        }
        return true;
    }

    VarSet getNonScalars() {
        return this.pointsToMap.getNonScalars();
    }

    Collection<NumVar.AddrVar> findAllPossibleEdges(NumVar id) {
        return this.getPts(id).allAddresses();
    }

    @Override
    public void toCompactString(String domainName, StringBuilder builder, PrettyDomain childDomain) {
    }

    public PointsToState removePtsEntry(NumVar src, NumVar.AddrVar tgt) {
        return new PointsToState(this.pointsToMap.removeEntry(src, tgt));
    }

    HyperPointsToSet translate(int lhsSize, Finite.Rhs rhs, WarningsContainer wc) {
        return new RhsTranslator(lhsSize, this, wc).run(rhs);
    }

    public VarSet getSupport() {
        return this.pointsToMap.getSupport();
    }
}

