/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.pointsto;

import bindead.abstractsyntax.finite.Finite;
import bindead.abstractsyntax.finite.FiniteFactory;
import bindead.data.FoldMap;
import bindead.data.Linear;
import bindead.data.NumVar;
import bindead.data.VarSet;
import bindead.debug.PrettyDomain;
import bindead.debug.XmlPrintHelpers;
import bindead.domainnetwork.combinators.FiniteSequence;
import bindead.domainnetwork.interfaces.FiniteDomain;
import bindead.domains.pointsto.NumVarOrZero;
import bindead.domains.pointsto.PointsToProperties;
import com.jamesmurty.utils.XMLBuilder;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javalx.data.products.P2;
import javalx.persistentcollections.AVLMap;
import javalx.persistentcollections.FiniteMap;
import javalx.persistentcollections.ThreeWaySplit;
import javalx.xml.XmlPrintable;

public class PointsToSet
implements Iterable<PointsToEntry>,
XmlPrintable {
    private static final FiniteFactory fin = FiniteFactory.getInstance();
    private static final boolean DEBUG = PointsToProperties.INSTANCE.debugOther.isTrue();
    final NumVar var;
    final AVLMap<NumVar.AddrVar, PointsToEntry> entryMap;
    final NumVarOrZero sumOfFlags;
    final NumVar outFlagOfGhostNode;

    static final <D extends FiniteDomain<D>> PointsToSet empty(NumVar v) {
        return new PointsToSet(v, NumVarOrZero.zero());
    }

    static final <D extends FiniteDomain<D>> PointsToSet empty(NumVar v, NumVar s) {
        return new PointsToSet(v, new NumVarOrZero(s));
    }

    private PointsToSet(NumVar v, NumVarOrZero sum) {
        this(v, sum, null, AVLMap.empty());
    }

    PointsToSet(NumVar var, NumVarOrZero sum, NumVar ghostNode, AVLMap<NumVar.AddrVar, PointsToEntry> pts) {
        this.var = var;
        this.sumOfFlags = sum;
        this.entryMap = pts;
        this.outFlagOfGhostNode = ghostNode;
    }

    Set<NumVar.AddrVar> allAddresses() {
        HashSet<NumVar.AddrVar> s = new HashSet<NumVar.AddrVar>();
        for (NumVar.AddrVar k : this.entryMap.keys()) {
            s.add(k);
        }
        return s;
    }

    PointsToSet bind(NumVar.AddrVar adr, NumVar flag) {
        assert (adr != null);
        assert (flag != null);
        return this.bind(new PointsToEntry(adr, flag));
    }

    PointsToSet bind(PointsToEntry entry) {
        assert (entry.address != null);
        return new PointsToSet(this.var, this.sumOfFlags, this.outFlagOfGhostNode, (AVLMap<NumVar.AddrVar, PointsToEntry>)this.entryMap.bind((Object)entry.address, (Object)entry));
    }

    PointsToEntry getEntry(NumVar.AddrVar a) {
        if (a == null) {
            return null;
        }
        return this.entryMap.get(a).getOrNull();
    }

    boolean isScalar() {
        return this.entryMap.isEmpty();
    }

    public boolean isEmpty() {
        return this.isScalar();
    }

    @Override
    public Iterator<PointsToEntry> iterator() {
        return this.entryMap.values().iterator();
    }

    VarSet localVars() {
        VarSet res = this.ptsFlags();
        if (!this.sumOfFlags.isConstantZero()) {
            res = res.add(this.sumOfFlags.numVar);
        }
        return res;
    }

    private VarSet ptsFlags() {
        VarSet vs = VarSet.empty();
        for (PointsToEntry e : this.entryMap.values()) {
            vs = vs.add(e.flag);
        }
        if (this.outFlagOfGhostNode != null) {
            vs = vs.add(this.outFlagOfGhostNode);
        }
        return vs;
    }

    private static void msg(String s) {
        if (DEBUG) {
            System.out.println("PointsToSet: " + s + "\n");
        }
    }

    @Override
    public XMLBuilder toXML(XMLBuilder builder) {
        XMLBuilder xml = builder;
        xml.e("PointsToSet");
        for (PointsToEntry lvalue : this.entryMap.values()) {
            xml = XmlPrintHelpers.p2AsElement(builder, "LValue", new P2<NumVar.AddrVar, NumVar>(lvalue.address, lvalue.flag));
        }
        xml = xml.up();
        return xml;
    }

    PointsToSet remove(PointsToEntry entry) {
        NumVar.AddrVar address = entry.address;
        return this.remove(address);
    }

    PointsToSet remove(NumVar.AddrVar address) {
        return new PointsToSet(this.var, this.sumOfFlags, this.outFlagOfGhostNode, (AVLMap<NumVar.AddrVar, PointsToEntry>)this.entryMap.remove((Object)address));
    }

    ThreeWaySplit<AVLMap<NumVar.AddrVar, PointsToEntry>> splitPts(PointsToSet sndPts) {
        return this.entryMap.split(sndPts.entryMap);
    }

    public String toString() {
        Iterator<PointsToEntry> i = this.entryMap.values().iterator();
        String suf = this.sumOfFlags.isConstantZero() ? "" : "(#" + this.sumOfFlags.numVar + ")";
        suf = suf + (this.outFlagOfGhostNode == null ? "" : " " + this.outFlagOfGhostNode + "*other +");
        if (!i.hasNext()) {
            return "{" + suf + "}";
        }
        String e = "{" + i.next().toString();
        while (i.hasNext()) {
            e = e + " + " + i.next().toString();
        }
        return e + " " + suf + "}";
    }

    public static PointsToSet bendToOutFlag(PointsToSet pts, FoldMap innerVars, NumVar.AddrVar other) {
        PointsToEntry o = pts.getEntry(other);
        if (o == null) {
            return pts;
        }
        if (pts.outFlagOfGhostNode != null) {
            innerVars.add(o.flag, pts.outFlagOfGhostNode);
        }
        FiniteMap em = pts.entryMap.remove((Object)other);
        return new PointsToSet(pts.var, pts.sumOfFlags, o.flag, (AVLMap<NumVar.AddrVar, PointsToEntry>)em);
    }

    PointsToSet renameAddress(NumVar.AddrVar from, NumVar.AddrVar to) {
        PointsToEntry o = this.getEntry(from);
        assert (this.getEntry(to) == null);
        if (o == null) {
            return this;
        }
        return this.remove(from).bind(to, o.flag);
    }

    Finite.Test sumRestriction() {
        return fin.unsignedLessThanOrEqualTo(0, Linear.sumOf(this.ptsFlags()), this.sumOfFlags.getLinear());
    }

    boolean hasGhostNode() {
        return this.outFlagOfGhostNode != null;
    }

    P2<PointsToSet, FoldMap> cloneWithNewVars(NumVar newV) {
        FoldMap substs = new FoldMap();
        NumVarOrZero newSum = this.cloneSum(substs);
        NumVar ghost = this.cloneGhost(substs);
        PointsToSet newPts = new PointsToSet(newV, newSum).withGhostNode(ghost);
        for (PointsToEntry e : this) {
            NumVar nv = substs.freshSubstitute(e.flag);
            newPts = newPts.bind(e.address, nv);
        }
        return P2.tuple2(newPts, substs);
    }

    private NumVar cloneGhost(FoldMap substs) {
        NumVar ghost = null;
        if (this.outFlagOfGhostNode != null) {
            ghost = substs.freshSubstitute(this.outFlagOfGhostNode);
        }
        return ghost;
    }

    private NumVarOrZero cloneSum(FoldMap substs) {
        NumVarOrZero newSum;
        if (!this.sumOfFlags.isConstantZero()) {
            NumVar fv = substs.freshSubstitute(this.sumOfFlags.numVar);
            newSum = new NumVarOrZero(fv);
        } else {
            newSum = NumVarOrZero.zero();
        }
        return newSum;
    }

    boolean isBoring() {
        return this.isScalar() && this.sumOfFlags.isConstantZero() && this.outFlagOfGhostNode == null;
    }

    void killLocalVars(FiniteSequence co) {
        for (NumVar oldFlag : this.localVars()) {
            co.addKill(oldFlag);
        }
    }

    boolean hasEntry(NumVar.AddrVar a) {
        return this.entryMap.contains(a);
    }

    PointsToSet substituteAddress(NumVar.AddrVar toAddr, NumVar.AddrVar fromAddr, FiniteSequence childOps) {
        PointsToSet newPts;
        assert (!this.hasEntry(toAddr));
        PointsToEntry entry = this.getEntry(fromAddr);
        if (entry != null) {
            NumVar newFlag = NumVar.fresh();
            childOps.addSubst(entry.flag, newFlag);
            newPts = this.remove(fromAddr).bind(toAddr, newFlag);
        } else {
            newPts = null;
        }
        return newPts;
    }

    PointsToSet withGhostNode(NumVar outFlagOfGhostNode2) {
        return new PointsToSet(this.var, this.sumOfFlags, outFlagOfGhostNode2, this.entryMap);
    }

    PointsToSet withSumVar(NumVar s) {
        assert (this.sumOfFlags.isConstantZero());
        return new PointsToSet(this.var, new NumVarOrZero(s), this.outFlagOfGhostNode, this.entryMap);
    }

    void appendInfo(StringBuilder builder, PrettyDomain childDomain) {
        if (this.entryMap.isEmpty() && this.sumOfFlags.isConstantZero() && this.outFlagOfGhostNode == null) {
            childDomain.varToCompactString(builder, this.var);
            return;
        }
        builder.append("{");
        if (!this.sumOfFlags.isConstantZero()) {
            builder.append("(#");
            childDomain.varToCompactString(builder, this.sumOfFlags.numVar);
            builder.append(") ");
        }
        if (this.outFlagOfGhostNode != null) {
            childDomain.varToCompactString(builder, this.outFlagOfGhostNode);
            builder.append("*other +");
        }
        for (PointsToEntry e : this.entryMap.values()) {
            e.appendInfo(builder, childDomain);
            builder.append(" + ");
        }
        childDomain.varToCompactString(builder, this.var);
        builder.append("}");
    }

    VarSet varsInChildDomain() {
        return this.localVars().add(this.var);
    }

    boolean knownToBeScalar() {
        return this.isScalar() || this.sumOfFlags.isConstantZero();
    }

    VarSet varsNotExportingEqualities() {
        VarSet l = this.localVars();
        if (!this.knownToBeScalar()) {
            l = l.add(this.var);
        }
        return l;
    }

    static class PointsToEntry {
        final NumVar.AddrVar address;
        final NumVar flag;

        PointsToEntry(NumVar.AddrVar a, NumVar f) {
            this.address = a;
            this.flag = f;
        }

        public String toString() {
            return this.flag + "*" + this.address;
        }

        public void appendInfo(StringBuilder builder, PrettyDomain childDomain) {
            childDomain.varToCompactString(builder, this.flag);
            builder.append("*");
            childDomain.varToCompactString(builder, this.address);
        }
    }
}

