/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.pointsto;

import bindead.abstractsyntax.finite.Finite;
import bindead.abstractsyntax.finite.FiniteFactory;
import bindead.data.Linear;
import bindead.data.NumVar;
import bindead.domains.pointsto.PointsToProperties;
import java.util.Iterator;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.numeric.BigInt;
import javalx.numeric.Bound;
import javalx.numeric.Interval;
import javalx.persistentcollections.AVLMap;

class HyperPointsToSet
implements Iterable<P2<NumVar.AddrVar, Linear>> {
    private static final FiniteFactory fin = FiniteFactory.getInstance();
    AVLMap<NumVar.AddrVar, Linear> coefficients;
    Finite.Rhs offset;
    Linear sumOfFlags;
    private final boolean DEBUG;

    private void msg(String s) {
        if (this.DEBUG) {
            System.out.println("\nHyperPointsToSet: " + s);
        }
    }

    HyperPointsToSet(int size) {
        this(fin.literal(size, Bound.ZERO));
    }

    HyperPointsToSet(Finite.Rhs offset) {
        this.DEBUG = PointsToProperties.INSTANCE.debugOther.isTrue();
        this.coefficients = AVLMap.empty();
        this.offset = offset;
        this.sumOfFlags = Linear.ZERO;
    }

    private HyperPointsToSet(AVLMap<NumVar.AddrVar, Linear> cm, Finite.Rlin o, Linear s) {
        this.DEBUG = PointsToProperties.INSTANCE.debugOther.isTrue();
        this.coefficients = cm;
        this.offset = o;
        this.sumOfFlags = s;
    }

    void addCoefficient(NumVar.AddrVar adr, Linear c) {
        Option<Linear> y = this.coefficients.get(adr);
        if (y.isSome()) {
            c = c.add(y.get());
        }
        this.coefficients = this.coefficients.bind((Object)adr, (Object)c);
    }

    void addSumOfFlags(Linear c) {
        this.sumOfFlags = this.sumOfFlags.add(c);
    }

    void addOffset(Finite.Rlin o) {
        this.offset = this.getLinearOffset().add(o);
    }

    public String toString() {
        String s = "";
        for (P2<NumVar.AddrVar, Linear> p2 : this.coefficients) {
            s = s + "(" + p2._1() + " -> " + p2._2() + ") + ";
        }
        return s + "offset(" + this.offset + ") sumOfFlags(" + this.sumOfFlags + ")";
    }

    void add(HyperPointsToSet other) {
        for (P2<NumVar.AddrVar, Linear> p2 : other.coefficients) {
            Linear myl = this.coefficients.get(p2._1()).getOrNull();
            myl = myl == null ? p2._2() : myl.add(p2._2());
            this.coefficients = this.coefficients.bind((Object)p2._1(), (Object)myl);
        }
        this.offset = this.getLinearOffset().add(other.getLinearOffset());
        this.sumOfFlags = this.sumOfFlags.add(other.sumOfFlags);
    }

    void sub(HyperPointsToSet other) {
        for (P2<NumVar.AddrVar, Linear> p2 : other.coefficients) {
            Linear myl = this.coefficients.get(p2._1()).getOrNull();
            myl = myl == null ? p2._2().negate() : myl.sub(p2._2());
            this.coefficients = this.coefficients.bind((Object)p2._1(), (Object)myl);
        }
        this.offset = this.getLinearOffset().sub(other.getLinearOffset());
        this.sumOfFlags = this.sumOfFlags.sub(other.sumOfFlags);
    }

    Finite.Rlin getLinearOffset() {
        return (Finite.Rlin)this.offset;
    }

    boolean isScalar() {
        boolean isScalar = this.coefficients.isEmpty();
        return isScalar;
    }

    void setToTop() {
        this.coefficients = AVLMap.empty();
        this.offset = fin.range(0, Interval.TOP);
        this.sumOfFlags = Linear.ZERO;
    }

    AVLMap<NumVar.AddrVar, Linear> getTerms() {
        return this.coefficients;
    }

    void addOffset(int size, BigInt o) {
        this.addOffset(fin.linear(size, Linear.linear(o)));
    }

    public HyperPointsToSet mul(BigInt coeff) {
        AVLMap<NumVar.AddrVar, Linear> result = AVLMap.empty();
        for (P2<NumVar.AddrVar, Linear> p2 : this.coefficients) {
            result = result.bind((Object)p2._1(), (Object)p2._2().smul(coeff));
        }
        Finite.Rlin o = ((Finite.Rlin)this.offset).smul(coeff);
        Linear linear = this.sumOfFlags.smul(coeff);
        return new HyperPointsToSet(result, o, linear);
    }

    @Override
    public Iterator<P2<NumVar.AddrVar, Linear>> iterator() {
        return this.coefficients.iterator();
    }
}

