/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.intervals;

import bindead.abstractsyntax.zeno.Zeno;
import bindead.abstractsyntax.zeno.ZenoRhsVisitorSkeleton;
import bindead.analyses.algorithms.AnalysisProperties;
import bindead.data.FoldMap;
import bindead.data.Linear;
import bindead.data.NumVar;
import bindead.data.VarPair;
import bindead.data.VarSet;
import bindead.debug.DomainStringBuilder;
import bindead.debug.StringHelpers;
import bindead.domainnetwork.channels.SetOfEquations;
import bindead.domainnetwork.channels.SynthChannel;
import bindead.domainnetwork.interfaces.AnalysisCtx;
import bindead.domainnetwork.interfaces.ZenoHeadDomain;
import bindead.domains.intervals.IntervalProperties;
import bindead.domains.intervals.SynthesizedPredicatesBuilder;
import bindead.exceptions.DomainStateException;
import bindead.exceptions.Unreachable;
import com.jamesmurty.utils.XMLBuilder;
import java.util.Iterator;
import java.util.SortedSet;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.exceptions.UnimplementedException;
import javalx.numeric.BigInt;
import javalx.numeric.Bound;
import javalx.numeric.Interval;
import javalx.numeric.Range;
import javalx.persistentcollections.AVLMap;
import javalx.persistentcollections.FiniteMap;
import javalx.persistentcollections.ThreeWaySplit;
import rreil.lang.MemVar;
import rreil.lang.util.Type;

public class Intervals
extends ZenoHeadDomain<Intervals> {
    private final boolean DEBUGSUBSETOREQUAL;
    private final boolean DEBUGASSIGN;
    private final boolean DEBUGBINARIES;
    private final boolean DEBUGWIDENING;
    private final boolean DEBUGTESTS;
    private final boolean DEBUGOTHER;
    public static final String NAME = "INTERVALS";
    private final AVLMap<NumVar, Interval> intervals;
    private final SynthChannel channel;

    public Intervals() {
        this(AVLMap.empty(), new SynthChannel(), AnalysisCtx.unknown());
    }

    private Intervals(AVLMap<NumVar, Interval> intervals, SynthChannel channel, AnalysisCtx ctx) {
        super(NAME, ctx);
        this.DEBUGSUBSETOREQUAL = IntervalProperties.INSTANCE.debugSubsetOrEqual.isTrue();
        this.DEBUGASSIGN = IntervalProperties.INSTANCE.debugAssignments.isTrue();
        this.DEBUGBINARIES = IntervalProperties.INSTANCE.debugBinaryOperations.isTrue();
        this.DEBUGWIDENING = IntervalProperties.INSTANCE.debugWidening.isTrue();
        this.DEBUGTESTS = IntervalProperties.INSTANCE.debugTests.isTrue();
        this.DEBUGOTHER = IntervalProperties.INSTANCE.debugOther.isTrue();
        this.intervals = intervals;
        this.channel = channel;
    }

    private Intervals build(AVLMap<NumVar, Interval> intervals, SynthChannel channel) {
        return new Intervals(intervals, channel, this.getContext());
    }

    private Intervals build(AVLMap<NumVar, Interval> intervals) {
        return this.build(intervals, new SynthChannel());
    }

    @Override
    public Intervals setContext(AnalysisCtx ctx) {
        return new Intervals(this.intervals, new SynthChannel(), ctx);
    }

    @Override
    public Intervals eval(Zeno.Assign stmt) {
        Interval valueApproximation = this.evaluate(stmt.getRhs());
        VarSet equalities = VarSet.empty();
        if (valueApproximation.isConstant()) {
            equalities = equalities.add(stmt.getLhs().getId());
        }
        FiniteMap newIntervals = this.intervals.bind((Object)stmt.getLhs().getId(), (Object)valueApproximation);
        SynthChannel synth = new SynthChannel();
        for (NumVar var : equalities) {
            synth.addEquation(Linear.linear(((Interval)((AVLMap)newIntervals).get(var).get()).getConstant().negate(), Linear.term(var)).toEquality());
        }
        if (!synth.getEquations().isEmpty() && AnalysisProperties.INSTANCE.debugTests.isTrue().booleanValue()) {
            System.out.println("Synth: " + synth);
        }
        Intervals result = this.build((AVLMap<NumVar, Interval>)newIntervals, synth);
        if (this.DEBUGASSIGN) {
            System.out.println("INTERVALS:");
            System.out.println("  after " + stmt + " that is " + valueApproximation);
            System.out.println("  values: " + result);
        }
        return result;
    }

    @Override
    public Intervals eval(Zeno.Test test) {
        if (test.getOperator().equals((Object)Zeno.ZenoTestOp.NotEqualToZero)) {
            if (AnalysisProperties.INSTANCE.debugTests.isTrue().booleanValue()) {
                System.out.println("Intervals splits test: " + test);
            }
            P2<Zeno.Test, Zeno.Test> tests = test.splitEquality();
            Intervals firstState = null;
            Intervals secondState = null;
            try {
                firstState = this.eval(tests._1());
            }
            catch (Unreachable unreachable) {
                // empty catch block
            }
            try {
                secondState = this.eval(tests._2());
            }
            catch (Unreachable unreachable) {
                // empty catch block
            }
            Intervals result = Intervals.joinNullables(firstState, secondState);
            if (result == null) {
                throw new Unreachable();
            }
            return result;
        }
        if (AnalysisProperties.INSTANCE.debugTests.isTrue().booleanValue()) {
            System.out.println("Numeric test: " + test);
        }
        FiniteMap newIntervals = this.intervals;
        VarSet newEqualities = VarSet.empty();
        Linear expr = test.getExpr();
        boolean allReachable = true;
        if (expr.isConstantOnly()) {
            BigInt lhs = expr.getConstant();
            switch (test.getOperator()) {
                case EqualToZero: {
                    allReachable = lhs.isZero();
                    break;
                }
                case NotEqualToZero: {
                    allReachable = !lhs.isZero();
                    break;
                }
                case LessThanOrEqualToZero: {
                    allReachable = !lhs.isPositive();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        } else {
            for (Linear.Term term : expr) {
                Option<Interval> approxLhsOption = this.intervals.get(term.getId());
                if (approxLhsOption.isNone()) {
                    throw new DomainStateException.VariableSupportSetException();
                }
                Interval approxLhs = approxLhsOption.get();
                Linear equation = expr.dropTerm(term.getId());
                Interval approxRhs = this.evaluate(equation).negate();
                Option<Interval> meet = Intervals.applyMeet(test.getOperator(), term.getCoeff(), approxLhs, approxRhs);
                if (meet.isNone()) {
                    allReachable = false;
                    break;
                }
                Interval newValue = meet.get();
                if (newValue.isConstant()) {
                    newEqualities = newEqualities.add(term.getId());
                }
                newIntervals = newIntervals.bind(term.getId(), newValue);
            }
        }
        if (!allReachable) {
            if (this.DEBUGTESTS) {
                System.out.println("INTERVALS: ");
                System.out.println("  evaluating test: " + test);
                System.out.println("  before: " + this);
                System.out.println("  after: unreachable");
            }
            throw new Unreachable();
        }
        SynthChannel synth = new SynthChannel();
        for (NumVar var : newEqualities) {
            synth.addEquation(Linear.linear(newIntervals.get(var).get().getConstant().negate(), Linear.term(var)).toEquality());
        }
        if (!synth.getEquations().isEmpty() && AnalysisProperties.INSTANCE.debugTests.isTrue().booleanValue()) {
            System.out.println("Synth: " + synth);
        }
        Intervals result = this.build((AVLMap<NumVar, Interval>)newIntervals, synth);
        if (this.DEBUGTESTS) {
            System.out.println("INTERVALS: ");
            System.out.println("  evaluating test: " + test);
            System.out.println("  before: " + this);
            System.out.println("  after: " + result);
        }
        return result;
    }

    private Interval evaluate(Zeno.Rhs rhs) {
        return rhs.accept(RhsEvaluator.instance, this);
    }

    private Interval evaluate(Linear linear) {
        Interval res = Interval.ZERO;
        for (Linear.Term term : linear) {
            Interval value = this.intervals.get(term.getId()).getOrElse(Interval.TOP).mul(term.getCoeff());
            res = res.add(value);
        }
        res = res.add(linear.getConstant());
        return res;
    }

    private static Option<Interval> applyMeet(Zeno.ZenoTestOp testOp, BigInt lhsCoeff, Interval lhs, Interval rhs) {
        switch (testOp) {
            case EqualToZero: {
                rhs = rhs.divRoundInvards(lhsCoeff);
                if (rhs == null) {
                    return Option.none();
                }
                return lhs.meet(rhs);
            }
            case NotEqualToZero: {
                assert (false) : "Disequalities should be split up on test application in eval(Test)";
                Option<Interval> leftPart = Intervals.applyMeet(Zeno.ZenoTestOp.LessThanOrEqualToZero, lhsCoeff, lhs, rhs.sub(Bound.ONE));
                Option<Interval> rightPart = Intervals.applyMeet(Zeno.ZenoTestOp.LessThanOrEqualToZero, lhsCoeff.negate(), lhs, rhs.negate().sub(Bound.ONE));
                return Intervals.join(leftPart, rightPart);
            }
            case LessThanOrEqualToZero: {
                rhs = Interval.downFrom(rhs.high()).divRoundInvards(lhsCoeff);
                return lhs.meet(rhs);
            }
        }
        throw new IllegalStateException();
    }

    private static Option<Interval> join(Option<Interval> first, Option<Interval> second) {
        if (first.isSome() && second.isSome()) {
            return Option.some(first.get().join(second.get()));
        }
        if (first.isNone() && second.isNone()) {
            return Option.none();
        }
        if (first.isSome()) {
            return first;
        }
        return second;
    }

    @Override
    public Intervals join(Intervals other) {
        AVLMap<NumVar, Interval> differing = this.inBothButDifferingOnly(other);
        SynthChannel synth = new SynthChannel();
        synth.setImplications(SynthesizedPredicatesBuilder.generateImplications(differing, other.intervals));
        FiniteMap joined = AVLMap.empty();
        for (P2<NumVar, Interval> p2 : differing) {
            NumVar var = p2._1();
            Interval thisValue = p2._2();
            Interval otherValue = other.intervals.get(var).get();
            Interval resultValue = thisValue.join(otherValue);
            joined = joined.bind(var, resultValue);
        }
        Intervals result = this.build(joined.union(this.intervals), synth);
        if (this.DEBUGBINARIES) {
            System.out.println("INTERVALS:");
            System.out.println("  differing:");
            System.out.println("    from fst: " + this.build(this.intervals.intersection(differing)));
            System.out.println("    from snd: " + this.build(other.intervals.intersection(differing)));
            System.out.println("  join: " + result);
        }
        return result;
    }

    @Override
    public Intervals widen(Intervals other) {
        AVLMap<NumVar, Interval> differing = this.inBothButDifferingOnly(other);
        SynthChannel synth = new SynthChannel();
        synth.setImplications(SynthesizedPredicatesBuilder.generateImplications(differing, other.intervals));
        FiniteMap widened = AVLMap.empty();
        for (P2<NumVar, Interval> p2 : differing) {
            Interval resultValue;
            NumVar var = p2._1();
            Interval thisValue = p2._2();
            Interval otherValue = other.intervals.get(var).get();
            if (var.isFlag()) {
                resultValue = thisValue.join(otherValue);
                if (!resultValue.subsetOrEqual(Interval.BOOLEANTOP)) {
                    resultValue = thisValue.widen(otherValue);
                }
            } else {
                resultValue = thisValue.widen(otherValue);
            }
            widened = widened.bind(var, resultValue);
        }
        Intervals result = this.build(widened.union(this.intervals), synth);
        if (this.DEBUGWIDENING || this.DEBUGBINARIES) {
            System.out.println("INTERVALS:");
            System.out.println("  differing:");
            System.out.println("    values in 1st: " + this.build(this.intervals.intersection(differing)));
            System.out.println("    values in 2nd: " + this.build(other.intervals.intersection(differing)));
            System.out.println("  widened values: " + this.build(result.intervals.intersection(differing)));
        }
        return result;
    }

    private AVLMap<NumVar, Interval> inBothButDifferingOnly(Intervals other) {
        ThreeWaySplit<AVLMap<NumVar, Interval>> split = this.intervals.split(other.intervals);
        if (!split.onlyInFirst().isEmpty()) {
            throw new DomainStateException.VariableSupportSetException();
        }
        if (!split.onlyInSecond().isEmpty()) {
            throw new DomainStateException.VariableSupportSetException();
        }
        return split.inBothButDiffering();
    }

    @Override
    public boolean subsetOrEqual(Intervals other) {
        AVLMap<NumVar, Interval> split = this.inBothButDifferingOnly(other);
        if (this.DEBUGSUBSETOREQUAL) {
            System.out.println("INTERVALS:");
            System.out.println(" subset-or-equal:");
            System.out.println("  differing:");
            System.out.println("    from fst: " + this.build(this.intervals.intersection(split)));
            System.out.println("    from snd: " + this.build(other.intervals.intersection(split)));
        }
        for (P2<NumVar, Interval> p2 : split) {
            Interval b;
            NumVar variable = p2._1();
            Interval a = p2._2();
            if (a.subsetOrEqual(b = other.intervals.get(variable).get())) continue;
            return false;
        }
        return true;
    }

    @Override
    public Intervals introduce(NumVar variable, Type type, Option<BigInt> value) {
        FiniteMap updatedIntervals = this.intervals;
        Interval initial = Interval.top();
        switch (type) {
            case Bool: {
                initial = Interval.BOOLEANTOP;
                break;
            }
            case Zeno: {
                initial = Interval.TOP;
                break;
            }
            case Address: {
                initial = Interval.GREATER_THAN_OR_EQUAL_TO_ZERO;
            }
        }
        if (value.isSome()) {
            initial = Interval.of(value.get());
        }
        updatedIntervals = updatedIntervals.bind(variable, initial);
        return this.build((AVLMap<NumVar, Interval>)updatedIntervals);
    }

    @Override
    public Intervals project(VarSet vars) {
        FiniteMap removed = this.intervals;
        for (NumVar var : vars) {
            removed = removed.remove(var);
        }
        Intervals result = this.build((AVLMap<NumVar, Interval>)removed);
        if (this.DEBUGOTHER) {
            System.out.println("INTERVALS:");
            System.out.println("  project: " + vars);
            System.out.println("  values: " + result);
        }
        return result;
    }

    @Override
    public Intervals substitute(NumVar x, NumVar y) {
        FiniteMap updatedIntervals = this.intervals;
        Option<Interval> valueOfXOption = ((AVLMap)updatedIntervals).get((NumVar)x);
        if (valueOfXOption.isNone()) {
            throw new DomainStateException.VariableSupportSetException();
        }
        Interval valueOfX = valueOfXOption.get();
        updatedIntervals = ((AVLMap)updatedIntervals).remove(x);
        updatedIntervals = ((AVLMap)updatedIntervals).bind(y, valueOfX);
        return this.build((AVLMap<NumVar, Interval>)updatedIntervals);
    }

    @Override
    public Intervals expand(FoldMap vars) {
        FiniteMap updatedIntervals = this.intervals;
        for (VarPair vp : vars) {
            Option<Interval> valueOfPermanentOption = updatedIntervals.get((NumVar)vp.getPermanent());
            if (valueOfPermanentOption.isNone()) {
                throw new DomainStateException.VariableSupportSetException();
            }
            Interval valueOfPermanent = valueOfPermanentOption.get();
            updatedIntervals = updatedIntervals.bind(vp.getEphemeral(), valueOfPermanent);
        }
        return this.build((AVLMap<NumVar, Interval>)updatedIntervals);
    }

    @Override
    public Intervals fold(FoldMap vars) {
        FiniteMap updatedIntervals = this.intervals;
        for (VarPair vp : vars) {
            Option<Interval> valueOfPermanentOption = ((AVLMap)updatedIntervals).get(vp.getPermanent());
            if (valueOfPermanentOption.isNone()) {
                throw new DomainStateException.VariableSupportSetException();
            }
            Interval valueOfPermanent = valueOfPermanentOption.get();
            Option<Interval> valueOfEphemeralOption = ((AVLMap)updatedIntervals).get(vp.getEphemeral());
            if (valueOfEphemeralOption.isNone()) {
                throw new DomainStateException.VariableSupportSetException();
            }
            Interval valueOfEphemeral = valueOfEphemeralOption.get();
            updatedIntervals = ((AVLMap)updatedIntervals).remove(vp.getEphemeral());
            updatedIntervals = ((AVLMap)updatedIntervals).bind(vp.getPermanent(), valueOfPermanent.join(valueOfEphemeral));
        }
        return this.build((AVLMap<NumVar, Interval>)updatedIntervals);
    }

    @Override
    public Intervals copyAndPaste(VarSet vars, Intervals from) {
        FiniteMap updatedIntervals = this.intervals;
        for (NumVar var : vars) {
            Interval value = from.intervals.get(var).getOrNull();
            if (value == null) {
                throw new DomainStateException.VariableSupportSetException();
            }
            updatedIntervals = updatedIntervals.bind(var, value);
        }
        return this.build((AVLMap<NumVar, Interval>)updatedIntervals);
    }

    @Override
    public Range queryRange(Linear lin) {
        Range result = Range.from(this.evaluate(lin));
        if (this.DEBUGOTHER) {
            System.out.println("INTERVALS:");
            System.out.println("  query: " + lin);
            System.out.println("  values: " + this);
            System.out.println("  result: " + result);
        }
        return result;
    }

    @Override
    public SetOfEquations queryEqualities(NumVar variable) {
        return SetOfEquations.empty();
    }

    @Override
    public SynthChannel getSynthChannel() {
        return this.channel;
    }

    @Override
    public void varToCompactString(StringBuilder builder, NumVar var) {
        Interval interval = this.intervals.get(var).get();
        if (interval.isConstant()) {
            builder.append(interval.toString());
        } else {
            builder.append(var.toString());
        }
    }

    @Override
    public void toCompactString(StringBuilder builder) {
        builder.append("INTERVALS: #" + this.intervals.size() + " ");
        builder.append("{");
        for (P2<NumVar, Interval> p2 : this.intervals) {
            NumVar var = p2._1();
            Interval interval = p2._2();
            if (interval.isConstant() || interval.isTop()) continue;
            builder.append(var + "=");
            interval.toStringDotted(builder);
            builder.append(", ");
        }
        builder.setLength(builder.length() - 2);
        builder.append("}");
    }

    @Override
    public XMLBuilder toXML(XMLBuilder builder) {
        builder = builder.e(NAME);
        for (P2<NumVar, Interval> p2 : this.intervals) {
            Interval value = p2._2();
            builder = builder.e("Entry").a("type", "interval").e("Variable").t(p2._1().toString()).up().e("Value").e("lowerBound").t(value.low().toString()).up().e("upperBound").t(value.high().toString()).up().up().up();
        }
        return builder.up();
    }

    @Override
    public void toString(DomainStringBuilder builder) {
        builder.append(NAME, this.toString());
    }

    public String toString() {
        return "INTERVALS: #" + this.intervals.size() + " " + this.toLexicallySortedString();
    }

    private String toLexicallySortedString() {
        StringBuilder builder = new StringBuilder();
        SortedSet<NumVar> sorted = StringHelpers.sortLexically(this.intervals.keys());
        Iterator iterator = sorted.iterator();
        builder.append('{');
        while (iterator.hasNext()) {
            NumVar key = (NumVar)iterator.next();
            Interval value = this.intervals.getOrNull(key);
            builder.append(key);
            builder.append('=');
            builder.append(value);
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        return builder.append('}').toString();
    }

    @Override
    public void memVarToCompactString(StringBuilder builder, MemVar var) {
        throw new UnimplementedException();
    }

    private static final class RhsEvaluator
    extends ZenoRhsVisitorSkeleton<Interval, Intervals> {
        public static RhsEvaluator instance = new RhsEvaluator();

        private RhsEvaluator() {
        }

        @Override
        public Interval visit(Zeno.Bin stmt, Intervals intervals) {
            Interval approximation;
            Interval left = stmt.getLeft().accept(this, intervals);
            Interval right = stmt.getRight().accept(this, intervals);
            if (left.isConstant() && right.isConstant()) {
                return Interval.of(RhsEvaluator.applyToConstants(stmt.getOp(), left.getConstant(), right.getConstant()));
            }
            switch (stmt.getOp()) {
                case Mul: {
                    approximation = left.mul(right);
                    break;
                }
                case Div: {
                    approximation = left.divRoundZero(right);
                    break;
                }
                case Shl: {
                    approximation = left.shl(right);
                    break;
                }
                case Shr: {
                    approximation = left.shr(right);
                    break;
                }
                case Mod: {
                    approximation = Interval.top();
                    break;
                }
                default: {
                    approximation = Interval.top();
                }
            }
            return approximation;
        }

        private static BigInt applyToConstants(Zeno.ZenoBinOp op, BigInt left, BigInt right) {
            switch (op) {
                case Div: {
                    if (right.isZero()) {
                        return Bound.ZERO;
                    }
                    return left.divRoundZero(right);
                }
                case Mod: {
                    return left.mod(right);
                }
                case Mul: {
                    return left.mul(right);
                }
                case Shl: {
                    return left.shl(right);
                }
                case Shr: {
                    return left.shr(right);
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public Interval visit(Zeno.Rlin stmt, Intervals intervals) {
            Interval res = intervals.evaluate(stmt.getLinearTerm());
            return res.divRoundInvards(stmt.getDivisor());
        }

        @Override
        public Interval visit(Zeno.RangeRhs range, Intervals intervals) {
            return range.getRange().convexHull();
        }
    }
}

