/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.gauge;

import bindead.abstractsyntax.zeno.Zeno;
import bindead.abstractsyntax.zeno.ZenoRhsVisitorSkeleton;
import bindead.data.Linear;
import bindead.data.NumVar;
import bindead.domains.gauge.Wedge;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.numeric.Bound;
import javalx.numeric.Interval;
import javalx.persistentcollections.AVLMap;

public final class WedgeEvaluator
extends ZenoRhsVisitorSkeleton<Wedge, AVLMap<NumVar, Wedge>> {
    public static final WedgeEvaluator INSTANCE = new WedgeEvaluator();

    @Override
    public Wedge visit(Zeno.Bin stmt, AVLMap<NumVar, Wedge> wedges) {
        Wedge approximation;
        Wedge left = stmt.getLeft().accept(this, wedges);
        Wedge right = stmt.getRight().accept(this, wedges);
        switch (stmt.getOp()) {
            case Mul: {
                approximation = left.multiply(right);
                break;
            }
            case Div: {
                approximation = Wedge.FULL;
                break;
            }
            default: {
                approximation = Wedge.FULL;
            }
        }
        return approximation;
    }

    @Override
    public Wedge visit(Zeno.Rlin rlin, AVLMap<NumVar, Wedge> wedges) {
        Linear lin = rlin.getLinearTerm();
        Wedge wedge = Wedge.singleton(lin.getConstant());
        for (Linear.Term t : lin.getTerms()) {
            if (t.getCoeff().isEqualTo(Bound.ZERO)) continue;
            wedge = wedge.add(wedges.get(t.getId()).getOrElse(Wedge.FULL).multiply(Wedge.singleton(t.getCoeff())));
        }
        return wedge;
    }

    @Override
    public Wedge visit(Zeno.RangeRhs range, AVLMap<NumVar, Wedge> wedges) {
        Interval interval = range.getRange().convexHull();
        Bound lower = interval.low();
        Bound upper = interval.high();
        Option<Object> l = lower.isFinite() ? Option.some(Linear.linear(lower.asInteger())) : Option.none();
        Option<Object> u = upper.isFinite() ? Option.some(Linear.linear(upper.asInteger())) : Option.none();
        return Wedge.wedge(P2.tuple2(l, u));
    }
}

