/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.gauge;

import bindead.data.Linear;
import bindead.data.NumVar;
import bindead.data.VarSet;
import bindead.domains.affine.Substitution;
import bindead.domains.gauge.ImmutableGaugeStateData;
import bindead.domains.gauge.MutableGaugeStateData;
import bindead.domains.gauge.Wedge;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.numeric.Bound;
import javalx.persistentcollections.AVLMap;

public class GaugeStateData
implements ImmutableGaugeStateData,
MutableGaugeStateData {
    private VarSet candidates;
    private VarSet counters;
    private AVLMap<NumVar, Wedge> wedges;
    private AVLMap<NumVar, VarSet> reverse;
    private final Option<ImmutableGaugeStateData> wideningReference = Option.none();
    public static final GaugeStateData EMPTY = new GaugeStateData(VarSet.empty(), VarSet.empty(), AVLMap.empty(), AVLMap.empty());

    @Override
    public Option<ImmutableGaugeStateData> getWideningReference() {
        return this.wideningReference;
    }

    public String toString() {
        return "candidates=" + this.candidates + "\n\tcounters=" + this.counters + "\n\twedges=" + this.wedges + "]";
    }

    @Override
    public ImmutableGaugeStateData getImmutableCopy() {
        return new GaugeStateData(this.candidates, this.counters, this.wedges, this.reverse);
    }

    @Override
    public MutableGaugeStateData getMutableCopy() {
        return new GaugeStateData(this.candidates, this.counters, this.wedges, this.reverse);
    }

    private GaugeStateData(VarSet candidates, VarSet counters, AVLMap<NumVar, Wedge> wedges, AVLMap<NumVar, VarSet> reverse) {
        this.candidates = candidates;
        this.counters = counters;
        this.wedges = wedges;
        this.reverse = reverse;
    }

    @Override
    public VarSet getCandidates() {
        return this.candidates;
    }

    @Override
    public void setCandidates(VarSet candidates) {
        this.candidates = candidates;
    }

    @Override
    public VarSet getCounters() {
        return this.counters;
    }

    @Override
    public void setCounters(VarSet counters) {
        this.counters = counters;
    }

    @Override
    public AVLMap<NumVar, Wedge> getWedges() {
        return this.wedges;
    }

    @Override
    public void setWedges(AVLMap<NumVar, Wedge> wedges) {
        this.wedges = wedges;
    }

    @Override
    public AVLMap<NumVar, VarSet> getReverse() {
        return this.reverse;
    }

    @Override
    public void setReverse(AVLMap<NumVar, VarSet> reverse) {
        this.reverse = reverse;
    }

    public void addReverse(NumVar lambda, NumVar x) {
        this.reverse = this.reverse.contains(lambda) ? this.reverse.bind((Object)lambda, (Object)this.reverse.getOrNull(lambda).add(x)) : this.reverse.bind((Object)lambda, (Object)VarSet.of(x));
    }

    public void removeReverse(NumVar lambda, NumVar x) {
        if (this.reverse.contains(lambda)) {
            this.reverse = this.reverse.bind((Object)lambda, (Object)this.reverse.get(lambda).get().remove(x));
        }
    }

    @Override
    public Option<Wedge> getWedgeOption(NumVar var) {
        return this.getWedges().get(var);
    }

    @Override
    public Wedge getWedge(NumVar var) {
        Option<Wedge> optionWedge = this.getWedgeOption(var);
        return optionWedge.getOrElse(Wedge.FULL);
    }

    @Override
    public VarSet getWedgesDomain() {
        VarSet domain = VarSet.empty();
        for (P2<NumVar, Wedge> p2 : this.getWedges()) {
            domain = domain.add(p2._1());
        }
        return domain;
    }

    @Override
    public VarSet getOccurences(NumVar counter) {
        Option<VarSet> occurences = this.getReverse().get(counter);
        return occurences.getOrElse(VarSet.empty());
    }

    @Override
    public void setWedge(NumVar var, Wedge wedge) {
        VarSet newWedgeCounters = wedge.getVars();
        VarSet oldWedgeCounters = this.wedges.contains(var) ? this.wedges.get(var).get().getVars() : VarSet.empty();
        this.wedges = this.wedges.bind((Object)var, (Object)wedge);
        for (NumVar removedCounter : oldWedgeCounters.difference(newWedgeCounters)) {
            this.removeReverse(removedCounter, var);
        }
        for (NumVar addedCounter : newWedgeCounters.difference(oldWedgeCounters)) {
            this.addReverse(addedCounter, var);
        }
    }

    @Override
    public void removeWedge(NumVar var) {
        if (this.wedges.contains(var)) {
            for (NumVar counter : this.getWedge(var).getVars()) {
                this.removeReverse(counter, var);
            }
            this.wedges = this.wedges.remove((Object)var);
        }
    }

    @Override
    public boolean isCandidate(NumVar x) {
        return this.getCandidates().contains(x);
    }

    @Override
    public boolean isCounter(NumVar var) {
        return this.getCounters().contains(var);
    }

    @Override
    public void substituteCounter(NumVar x, NumVar y) {
        Substitution sigma = new Substitution(x, Linear.linear(y), Bound.ONE);
        for (NumVar v : this.getOccurences(x)) {
            this.setWedge(v, this.getWedge(v).applySubstitution(sigma));
        }
    }
}

