/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.gauge;

import bindead.abstractsyntax.zeno.Zeno;
import bindead.abstractsyntax.zeno.ZenoFactory;
import bindead.data.Linear;
import bindead.data.NumVar;
import bindead.data.VarSet;
import bindead.domainnetwork.combinators.ZenoStateBuilder;
import bindead.domainnetwork.interfaces.ZenoDomain;
import bindead.domains.affine.Substitution;
import bindead.domains.gauge.GaugeState;
import bindead.domains.gauge.MutableGaugeStateData;
import bindead.domains.gauge.Wedge;
import bindead.domains.gauge.WedgeEvaluator;
import bindead.exceptions.DomainStateException;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.numeric.BigInt;
import javalx.numeric.Bound;
import javalx.numeric.Range;
import javalx.persistentcollections.AVLMap;
import javalx.persistentcollections.ThreeWaySplit;

class GaugeStateBuilder
extends ZenoStateBuilder {
    private final MutableGaugeStateData data;

    public GaugeStateBuilder(MutableGaugeStateData data) {
        this.data = data;
    }

    public GaugeState build() {
        return new GaugeState(this.data.getImmutableCopy());
    }

    private <D extends ZenoDomain<D>> void joinCounters(D thisChild, GaugeStateBuilder other) {
        VarSet joinedCandidates = this.data.getCandidates().intersection(other.data.getCandidates());
        VarSet joinedCounters = this.data.getCandidates().union(this.data.getCounters()).intersection(other.data.getCounters()).union(other.data.getCandidates().union(other.data.getCounters())).intersection(this.data.getCounters());
        for (NumVar lambda : this.data.getCounters().difference(joinedCounters)) {
            this.forgetCounter(lambda, thisChild.queryRange(lambda));
        }
        joinedCandidates = joinedCandidates.difference(joinedCounters);
        this.data.setCandidates(joinedCandidates);
        this.data.setCounters(joinedCounters);
    }

    private <D extends ZenoDomain<D>> void inferCounters(D thisChild, GaugeStateBuilder other) {
        VarSet inferredCounters = this.data.getCandidates().intersection(other.data.getCandidates()).union(other.data.getCounters().union(this.data.getCounters()));
        this.data.setCandidates(VarSet.empty());
        this.data.setCounters(inferredCounters);
    }

    private void forgetCounter(NumVar lambda, Range lambda_range) {
        for (NumVar x : this.data.getOccurences(lambda)) {
            this.data.setWedge(x, this.data.getWedge(x).forgetCounter(lambda, lambda_range));
        }
    }

    private void deleteCounter(NumVar lambda, Range lambda_range) {
        this.forgetCounter(lambda, lambda_range);
        this.data.setCounters(this.data.getCounters().remove(lambda));
    }

    public <D extends ZenoDomain<D>> void join(D thisChild, GaugeStateBuilder other) {
        this.joinCounters(thisChild, other);
        ThreeWaySplit<AVLMap<NumVar, Wedge>> diff = this.data.getWedges().split(other.data.getWedges());
        AVLMap<NumVar, Wedge> onlyInThis = diff.onlyInFirst();
        AVLMap<NumVar, Wedge> onlyInOther = diff.onlyInSecond();
        AVLMap<NumVar, Wedge> differentValues = diff.inBothButDiffering();
        for (P2<NumVar, Wedge> p2 : onlyInOther) {
            this.data.setWedge(p2._1(), Wedge.FULL);
        }
        for (P2<NumVar, Wedge> p2 : onlyInThis) {
            this.data.setWedge(p2._1(), Wedge.FULL);
        }
        for (P2<NumVar, Wedge> p2 : differentValues) {
            this.data.setWedge(p2._1(), p2._2().join(other.data.getWedge(p2._1())));
        }
    }

    private Option<BigInt> toZT(Range range) {
        if (range.isConstant()) {
            return Option.some(range.getConstantOrNull());
        }
        return Option.none();
    }

    private Wedge widenLI(Wedge left, Wedge right, NumVar lambda, Range left_range, Range right_range) {
        return left.widenLI(right, lambda, this.toZT(left_range), this.toZT(right_range));
    }

    public <D extends ZenoDomain<D>> void widen(D thisChild, GaugeStateBuilder other, D otherChild) {
        VarSet Lambda;
        this.inferCounters(thisChild, other);
        VarSet ChangedCounters = Lambda = this.data.getCounters().union(other.data.getCounters());
        VarSet Domain2 = this.data.getWedgesDomain().union(other.data.getWedgesDomain());
        for (NumVar lambda : Lambda) {
            if (!this.toZT(thisChild.queryRange(lambda)).equals(this.toZT(otherChild.queryRange(lambda)))) continue;
            ChangedCounters = ChangedCounters.remove(lambda);
        }
        if (ChangedCounters.isEmpty()) {
            for (NumVar x : Domain2) {
                this.data.setWedge(x, this.data.getWedge(x).intervalWiden(other.data.getWedge(x)));
            }
        } else {
            for (NumVar lambda : ChangedCounters) {
                Range u_range = thisChild.queryRange(lambda);
                Range v_range = otherChild.queryRange(lambda);
                for (NumVar x : Domain2.remove(lambda)) {
                    this.data.setWedge(x, this.widenLI(this.data.getWedge(x), other.data.getWedge(x), lambda, u_range, v_range));
                }
            }
            VarSet UnchangedCounters = Lambda.difference(ChangedCounters);
            for (NumVar x : Domain2) {
                if (this.data.getWedge(x).getVars().intersection(UnchangedCounters).isEmpty()) continue;
                this.data.setWedge(x, this.data.getWedge(x).partialJoin(other.data.getWedge(x), UnchangedCounters));
            }
        }
    }

    private static Option<BigInt> getIncrementOf(NumVar c, Zeno.Rhs rhs) {
        if (!(rhs instanceof Zeno.Rlin)) {
            return Option.none();
        }
        Linear lin = ((Zeno.Rlin)rhs).getLinearTerm();
        VarSet linVars = lin.getVars();
        if (linVars.size() == 1 && linVars.contains(c) && !lin.getConstant().isNegative() && lin.getCoeff(c).isEqualTo(Bound.ONE)) {
            return Option.some(lin.getConstant());
        }
        return Option.none();
    }

    public <D extends ZenoDomain<D>> void assignCounter(D childState, NumVar assignedToVar, Zeno.Rhs rhs, Wedge rhsValue) {
        assert (this.data.isCounter(assignedToVar));
        Option<BigInt> increment = GaugeStateBuilder.getIncrementOf(assignedToVar, rhs);
        if (increment.isSome()) {
            if (this.data.getWideningReference().isSome()) {
                for (NumVar x : this.data.getOccurences(assignedToVar)) {
                    this.data.setWedge(x, this.data.getWedge(x).inc(assignedToVar, increment.get()));
                }
            } else {
                for (NumVar x : this.data.getOccurences(assignedToVar)) {
                    this.data.setWedge(x, this.data.getWedge(x).inc(assignedToVar, increment.get()));
                }
            }
        } else {
            this.deleteCounter(assignedToVar, childState.queryRange(assignedToVar));
        }
    }

    public <D extends ZenoDomain<D>> void assignCandidate(D childState, NumVar assignedToVar, Zeno.Rhs rhs, Wedge rhsValue) {
        assert (this.data.isCandidate(assignedToVar));
        Option<BigInt> increment = GaugeStateBuilder.getIncrementOf(assignedToVar, rhs);
        if (!(increment.isSome() || rhsValue.hasLowerBound() && !rhsValue.lower().getConstant().isNegative())) {
            this.data.setCandidates(this.data.getCandidates().remove(assignedToVar));
        }
    }

    public <D extends ZenoDomain<D>> void assignPotentialCandidate(D childState, NumVar assignedToVar, Zeno.Rhs rhs, Wedge rhsValue) {
        assert (this.data.isCandidate(assignedToVar));
        Option<BigInt> increment = GaugeStateBuilder.getIncrementOf(assignedToVar, rhs);
        if (increment.isSome() || rhsValue.hasLowerBound() && !rhsValue.lower().getConstant().isNegative()) {
            this.data.setCandidates(this.data.getCandidates().add(assignedToVar));
        }
    }

    public <D extends ZenoDomain<D>> void assign(D childState, Zeno.Assign stmt) {
        NumVar assignedToVar = stmt.getLhs().getId();
        Zeno.Rhs assignedExpression = stmt.getRhs();
        Wedge assignedValue = assignedExpression.accept(WedgeEvaluator.INSTANCE, this.data.getWedges());
        if (this.data.isCounter(assignedToVar)) {
            this.assignCounter(childState, assignedToVar, assignedExpression, assignedValue);
        } else if (this.data.isCandidate(assignedToVar)) {
            this.assignCandidate(childState, assignedToVar, assignedExpression, assignedValue);
        } else {
            this.assignPotentialCandidate(childState, assignedToVar, assignedExpression, assignedValue);
        }
        this.data.setWedge(assignedToVar, assignedValue);
    }

    public Wedge approximate(Zeno.Rhs rhs) {
        return rhs.accept(WedgeEvaluator.INSTANCE, this.data.getWedges());
    }

    public Wedge approximate(Linear lin) {
        return new Zeno.Rlin(lin).accept(WedgeEvaluator.INSTANCE, this.data.getWedges());
    }

    public boolean subsetOrEqualTo(GaugeStateBuilder other) {
        VarSet Domain2 = this.data.getWedgesDomain().union(other.data.getWedgesDomain());
        for (NumVar x : Domain2) {
            if (this.data.getWedge(x).subsetOrEqualTo(other.data.getWedge(x))) continue;
            return false;
        }
        return true;
    }

    public <D extends ZenoDomain<D>> void project(D child, NumVar x) {
        if (this.data.isCounter(x)) {
            this.deleteCounter(x, child.queryRange(x));
        }
        if (this.data.isCandidate(x)) {
            this.data.setCandidates(this.data.getCandidates().remove(x));
        }
        this.data.removeWedge(x);
    }

    public void introduce(NumVar x, Option<BigInt> value) {
        if (this.data.getWedgesDomain().contains(x)) {
            throw new IllegalArgumentException("GAUGE: Cannot introduce a variable that is already present.");
        }
        this.data.setWedge(x, Wedge.FULL);
        if (value.isSome()) {
            this.data.setWedge(x, Wedge.singleton(value.get()));
        }
    }

    public void substitute(NumVar x, NumVar y) {
        Option<Wedge> Wx = this.data.getWedgeOption(x);
        if (Wx.isSome()) {
            if (this.data.isCounter(x)) {
                this.data.substituteCounter(x, y);
            }
        } else {
            throw new DomainStateException.VariableSupportSetException();
        }
        this.data.setWedge(y, Wx.get());
    }

    private static Zeno.Test leq0(Linear expr) {
        return ZenoFactory.getInstance().comparison(expr, Zeno.ZenoTestOp.LessThanOrEqualToZero);
    }

    public <D extends ZenoDomain<D>> D reduce(D childState, Zeno.Test test) {
        Linear expr = test.getExpr();
        VarSet exprVars = expr.getVars();
        VarSet exprCounters = exprVars.intersection(this.data.getCounters());
        VarSet exprNonCounters = exprVars.difference(this.data.getCounters());
        VarSet relevantVars = VarSet.empty();
        for (NumVar v : exprCounters) {
            relevantVars = relevantVars.union(this.data.getOccurences(v));
        }
        switch (test.getOperator()) {
            case LessThanOrEqualToZero: {
                Substitution sigma;
                for (NumVar v : exprNonCounters) {
                    Linear testExpr;
                    sigma = expr.genSubstitution(v);
                    Wedge W = this.data.getWedge(v);
                    if (expr.getCoeff(v).compareTo(Bound.ZERO) < 0 && W.hasUpperBound()) {
                        testExpr = Linear.mulAdd(Bound.MINUSONE, W.upper(), sigma.getFac(), sigma.getExpr());
                        childState = childState.eval(GaugeStateBuilder.leq0(testExpr));
                    }
                    if (expr.getCoeff(v).compareTo(Bound.ZERO) <= 0 || !W.hasLowerBound()) continue;
                    testExpr = Linear.mulAdd(Bound.ONE, W.lower(), sigma.getFac().negate(), sigma.getExpr());
                    childState = childState.eval(GaugeStateBuilder.leq0(testExpr));
                }
                for (NumVar c : exprCounters) {
                    sigma = expr.genSubstitution(c);
                    for (NumVar v : relevantVars.remove(c)) {
                        Linear testExpr;
                        Wedge W = this.data.getWedge(v);
                        Wedge Wsubst = W.applySubstitution(sigma);
                        if (expr.getCoeff(c).isNegative() && W.hasLowerBound()) {
                            testExpr = Linear.mulAdd(Bound.MINUSONE, Linear.linear(Linear.term(v)), Bound.ONE, Wsubst.lower());
                            childState = childState.eval(GaugeStateBuilder.leq0(testExpr));
                        }
                        if (!expr.getCoeff(c).isPositive() || !W.hasUpperBound()) continue;
                        testExpr = Linear.mulAdd(Bound.ONE, Linear.linear(Linear.term(v)), Bound.MINUSONE, Wsubst.upper());
                        childState = childState.eval(GaugeStateBuilder.leq0(testExpr));
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return childState;
    }
}

