/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.finitesupportset;

import bindead.abstractsyntax.finite.Finite;
import bindead.abstractsyntax.finite.util.VarExtractor;
import bindead.data.Linear;
import bindead.data.ListVarPair;
import bindead.data.NumVar;
import bindead.data.VarPair;
import bindead.data.VarSet;
import bindead.domainnetwork.channels.SetOfEquations;
import bindead.domainnetwork.combinators.FiniteFunctor;
import bindead.domainnetwork.interfaces.FiniteDomain;
import bindead.domains.finitesupportset.SupportSetState;
import bindead.domains.pointsto.PointsTo;
import bindead.domains.pointsto.PointsToState;
import bindead.exceptions.Unreachable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.data.products.P3;
import javalx.numeric.BigInt;
import javalx.numeric.Range;
import rreil.lang.util.Type;

public final class FiniteSupportSet<D extends FiniteDomain<D>>
extends FiniteFunctor<SupportSetState, D, FiniteSupportSet<D>> {
    public static final String NAME = "SUPPORTSET";

    public FiniteSupportSet(D child) {
        super(NAME, SupportSetState.empty(), child);
    }

    public FiniteSupportSet(SupportSetState state, D childState) {
        super(NAME, state, childState);
    }

    @Override
    public FiniteSupportSet<D> build(SupportSetState s, D cs) {
        if (cs instanceof PointsTo) {
            PointsTo cs2 = (PointsTo)cs;
            VarSet x = ((PointsToState)cs2.state).getSupport();
            VarSet supp = s.getSupportSet();
            VarSet onlyInChild = x.difference(supp);
            VarSet onlyInParent = supp.difference(x);
            assert (onlyInChild.isEmpty()) : "only in child: " + onlyInChild;
            assert (onlyInParent.isEmpty()) : "only in parent: " + onlyInParent;
        }
        return new FiniteSupportSet<D>(s, cs);
    }

    @Override
    public FiniteSupportSet<D> copyAndPaste(VarSet vars, FiniteSupportSet<D> from) {
        ((SupportSetState)this.state).haveNot(vars);
        ((SupportSetState)from.state).have(vars);
        return this.build(((SupportSetState)this.state).with(vars), (D)((FiniteDomain)this.childState).copyAndPaste(vars, (FiniteDomain)from.childState));
    }

    @Override
    public List<P2<NumVar.AddrVar, FiniteSupportSet<D>>> deprecatedDeref(Finite.Rlin ptr, VarSet summaries) throws Unreachable {
        ((SupportSetState)this.state).have(ptr);
        ((SupportSetState)this.state).have(summaries);
        LinkedList<P2<NumVar.AddrVar, FiniteSupportSet<D>>> alts = new LinkedList<P2<NumVar.AddrVar, FiniteSupportSet<D>>>();
        for (P2 ca : ((FiniteDomain)this.childState).deprecatedDeref(ptr, summaries)) {
            NumVar.AddrVar adr = ca._1();
            alts.add(new P2<NumVar.AddrVar, FiniteSupportSet<FiniteDomain>>(adr, this.build((SupportSetState)this.state, (D)((FiniteDomain)ca._2()))));
        }
        return alts;
    }

    @Override
    public FiniteSupportSet<D> eval(Finite.Assign stmt) {
        ((SupportSetState)this.state).have(VarExtractor.get(stmt));
        return this.build((SupportSetState)this.state, ((FiniteDomain)this.childState).eval(stmt));
    }

    @Override
    public FiniteSupportSet<D> eval(Finite.Test test) {
        ((SupportSetState)this.state).have(test.getVars());
        return this.build((SupportSetState)this.state, ((FiniteDomain)this.childState).eval(test));
    }

    @Override
    public FiniteSupportSet<D> introduce(NumVar var, Type type, Option<BigInt> value) {
        ((SupportSetState)this.state).haveNot(var);
        return this.build(((SupportSetState)this.state).with(var), ((FiniteDomain)this.childState).introduce(var, type, value));
    }

    @Override
    public FiniteSupportSet<D> project(NumVar var) {
        ((SupportSetState)this.state).have(var);
        return this.build(((SupportSetState)this.state).without(var), ((FiniteDomain)this.childState).project(var));
    }

    @Override
    public SetOfEquations queryEqualities(NumVar var) {
        ((SupportSetState)this.state).have(var);
        return ((FiniteDomain)this.childState).queryEqualities(var);
    }

    @Override
    public Range queryRange(Linear lin) {
        ((SupportSetState)this.state).have(lin);
        return ((FiniteDomain)this.childState).queryRange(lin);
    }

    @Override
    public P3<SupportSetState, D, D> makeCompatible(FiniteSupportSet<D> other, boolean isWideningPoint) {
        ((SupportSetState)this.state).sameAs((SupportSetState)other.state);
        return P3.tuple3(this.state, this.childState, other.childState);
    }

    @Override
    public FiniteSupportSet<D> substitute(NumVar from, NumVar to) {
        ((SupportSetState)this.state).have(from);
        ((SupportSetState)this.state).haveNot(to);
        return this.build(((SupportSetState)this.state).without(from).with(to), ((FiniteDomain)this.childState).substitute(from, to));
    }

    @Override
    public FiniteSupportSet<D> copyVariable(NumVar to, NumVar from) {
        ((SupportSetState)this.state).haveNot(to);
        ((SupportSetState)this.state).have(from);
        return this.build(((SupportSetState)this.state).with(to), ((FiniteDomain)this.childState).copyVariable(to, from));
    }

    @Override
    public FiniteSupportSet<D> assumeEdgeNG(Finite.Rlin pointerVar, NumVar.AddrVar targetAddr) {
        ((SupportSetState)this.state).have(pointerVar);
        ((SupportSetState)this.state).have(targetAddr);
        return this.build((SupportSetState)this.state, ((FiniteDomain)this.childState).assumeEdgeNG(pointerVar, targetAddr));
    }

    @Override
    public FiniteSupportSet<D> expandNG(ListVarPair nvps) {
        SupportSetState s = this.expandOnState(nvps);
        Object cs = ((FiniteDomain)this.childState).expandNG(nvps);
        return this.build(s, cs);
    }

    @Override
    public FiniteSupportSet<D> expandNG(NumVar.AddrVar p, NumVar.AddrVar e, ListVarPair nvps) {
        ((SupportSetState)this.state).have(p);
        SupportSetState s = this.expandOnState(nvps).with(e);
        Object cs = ((FiniteDomain)this.childState).expandNG(p, e, nvps);
        return this.build(s, cs);
    }

    private SupportSetState expandOnState(List<VarPair> nvps) {
        SupportSetState s = (SupportSetState)this.state;
        for (VarPair vp : nvps) {
            s.have((NumVar)vp.getPermanent());
            s.haveNot((NumVar)vp.getEphemeral());
            s = s.with((NumVar)vp.getEphemeral());
        }
        return s;
    }

    @Override
    public FiniteSupportSet<D> concretizeAndDisconnectNG(NumVar.AddrVar s, VarSet cs) {
        Object chs = ((FiniteDomain)this.childState).concretizeAndDisconnectNG(s, cs);
        return this.build((SupportSetState)this.state, chs);
    }

    @Override
    public FiniteSupportSet<D> bendBackGhostEdgesNG(NumVar.AddrVar s, NumVar.AddrVar c, VarSet svs, VarSet cvs, VarSet pts, VarSet ptc) {
        Object cs = ((FiniteDomain)this.childState).bendBackGhostEdgesNG(s, c, svs, cvs, pts, ptc);
        return this.build((SupportSetState)this.state, cs);
    }

    @Override
    public FiniteSupportSet<D> foldNG(ListVarPair nvps) {
        SupportSetState newState = (SupportSetState)this.state;
        for (VarPair vp : nvps) {
            ((SupportSetState)this.state).have((NumVar)vp.getPermanent());
            newState = newState.without((NumVar)vp.getEphemeral());
        }
        return this.build(newState, ((FiniteDomain)this.childState).foldNG(nvps));
    }

    @Override
    public FiniteSupportSet<D> foldNG(NumVar.AddrVar p, NumVar.AddrVar e, ListVarPair nvps) {
        ((SupportSetState)this.state).have(p);
        SupportSetState newState = ((SupportSetState)this.state).without(e);
        for (VarPair vp : nvps) {
            ((SupportSetState)this.state).have((NumVar)vp.getPermanent());
            newState = newState.without((NumVar)vp.getEphemeral());
        }
        Object newChild = ((FiniteDomain)this.childState).foldNG(p, e, nvps);
        return this.build(newState, newChild);
    }

    @Override
    public FiniteSupportSet<D> bendGhostEdgesNG(NumVar.AddrVar summary, NumVar.AddrVar concrete, VarSet svs, VarSet cvs, VarSet pts, VarSet ptc) {
        Object chs = ((FiniteDomain)this.childState).bendGhostEdgesNG(summary, concrete, svs, cvs, pts, ptc);
        return this.build((SupportSetState)this.state, chs);
    }

    @Override
    public FiniteSupportSet<D> assumeVarsAreEqual(int size, NumVar fst, NumVar snd) {
        ((SupportSetState)this.state).have(fst);
        ((SupportSetState)this.state).have(snd);
        return this.build((SupportSetState)this.state, ((FiniteDomain)this.childState).assumeVarsAreEqual(size, fst, snd));
    }

    @Override
    public Collection<NumVar.AddrVar> findPossiblePointerTargets(NumVar id) throws Unreachable {
        ((SupportSetState)this.state).have(id);
        return ((FiniteDomain)this.childState).findPossiblePointerTargets(id);
    }
}

