/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.fields;

import bindead.abstractsyntax.finite.Finite;
import bindead.abstractsyntax.finite.FiniteFactory;
import bindead.abstractsyntax.memderef.AbstractMemPointer;
import bindead.abstractsyntax.memderef.AbstractPointer;
import bindead.data.MemVarPair;
import bindead.data.MemVarSet;
import bindead.data.NumVar;
import bindead.data.VarSet;
import bindead.debug.PrettyDomain;
import bindead.domainnetwork.channels.DebugChannel;
import bindead.domainnetwork.channels.QueryChannel;
import bindead.domainnetwork.combinators.MemoryFiniteFunctor;
import bindead.domainnetwork.interfaces.FiniteDomain;
import bindead.domainnetwork.interfaces.RegionCtx;
import bindead.domains.fields.FieldGraph;
import bindead.domains.fields.FieldState;
import bindead.domains.fields.FieldStateBuilder;
import bindead.domains.fields.Region;
import bindead.domains.fields.VariableCtx;
import bindead.domains.fields.messages.ReadFromXrefWithNonConstantOffsetInfo;
import bindead.domains.fields.messages.WriteToReadOnlySegmentWarning;
import bindead.domains.fields.messages.WriteToXrefWithNonConstantOffsetWarning;
import bindead.domains.segments.heap.PathString;
import bindead.exceptions.Unreachable;
import java.util.LinkedList;
import java.util.List;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.data.products.P3;
import javalx.numeric.BigInt;
import javalx.numeric.Bound;
import javalx.numeric.FiniteRange;
import javalx.numeric.Interval;
import javalx.numeric.Range;
import javalx.persistentcollections.AVLSet;
import javalx.persistentcollections.ThreeWaySplit;
import javalx.persistentcollections.tree.FiniteRangeTree;
import javalx.persistentcollections.tree.OverlappingRanges;
import rreil.lang.Lhs;
import rreil.lang.MemVar;
import rreil.lang.RReilAddr;
import rreil.lang.Rhs;
import rreil.lang.Test;
import rreil.lang.util.RhsFactory;

public class Fields<D extends FiniteDomain<D>>
extends MemoryFiniteFunctor<FieldState, D, Fields<D>> {
    private static final RhsFactory imp = RhsFactory.getInstance();
    private static final FiniteFactory fin = FiniteFactory.getInstance();
    public static final String NAME = "FIELDS";

    public Fields(D child) {
        super(NAME, FieldState.EMPTY, child);
    }

    private Fields(FieldState state, D childState) {
        super(NAME, state, childState);
    }

    @Override
    public Fields<D> build(FieldState state, D childState) {
        return new Fields<D>(state, childState);
    }

    @Override
    public P3<FieldState, D, D> makeCompatible(Fields<D> other, boolean isWideningPoint) {
        FieldStateBuilder fst = new FieldStateBuilder((FieldState)this.state);
        FieldStateBuilder<FiniteDomain> snd = new FieldStateBuilder<FiniteDomain>((FieldState)other.state);
        fst.makeCompatible(snd);
        FiniteDomain newChildStateOfFst = fst.applyReorderedChildOps((FiniteDomain)this.childState);
        FiniteDomain newChildStateOfSnd = snd.applyReorderedChildOps((FiniteDomain)other.childState);
        return P3.tuple3(fst.build(), newChildStateOfFst, newChildStateOfSnd);
    }

    @Override
    public Fields<D> evalAssign(Lhs lhs, Rhs rhs) {
        FieldStateBuilder builder = new FieldStateBuilder((FieldState)this.state);
        builder.runAssign((QueryChannel)((Object)this.childState), lhs, rhs);
        return this.finish(builder);
    }

    @Override
    public Fields<D> evalLoad(Lhs value, AbstractMemPointer location) {
        Rhs rhs;
        int accessSize = value.getSize();
        Range offset = location.getOffsetRange((QueryChannel)((Object)this.childState));
        if (offset.isConstant()) {
            rhs = Fields.varFromRegion(accessSize, offset, location.region);
        } else {
            this.getContext().addWarning(new ReadFromXrefWithNonConstantOffsetInfo(location, offset));
            rhs = imp.range(accessSize, Interval.TOP);
        }
        return this.evalAssign(value, rhs);
    }

    @Override
    public Fields<D> evalStore(AbstractMemPointer location, Rhs.Lin value) {
        Range offset = location.getOffsetRange((QueryChannel)((Object)this.childState));
        int accessSize = value.getSize();
        if (!((FieldState)this.state).canWriteTo(location.region)) {
            this.getContext().addWarning(new WriteToReadOnlySegmentWarning(location.region));
            return this;
        }
        if (offset.isConstant()) {
            Rhs.Rvar varFromXref = Fields.varFromRegion(accessSize, offset, location.region);
            return this.evalAssign(varFromXref.asLhs(), value);
        }
        FieldStateBuilder builder = new FieldStateBuilder((FieldState)this.state);
        this.getContext().addWarning(new WriteToXrefWithNonConstantOffsetWarning(location, offset));
        Interval fieldFromRange = offset.convexHull().mul(Bound.EIGHT).add(Interval.of(0L, accessSize - 1));
        builder.removeOverlapping(location.region, fieldFromRange);
        return this.finish(builder);
    }

    private static Rhs.Rvar varFromRegion(int accessSize, Range offset, MemVar region) {
        int effectiveOffset = offset.getMin().mul(Bound.EIGHT).intValue();
        return imp.variable(accessSize, effectiveOffset, region);
    }

    @Override
    public Fields<D> eval(Test test) {
        FieldStateBuilder builder = new FieldStateBuilder((FieldState)this.state);
        builder.runTest((QueryChannel)((Object)this.childState), test);
        return this.finish(builder);
    }

    @Override
    public P3<AVLSet<NumVar.AddrVar>, Fields<D>, Finite.Rlin> findPointerTargets(Rhs.Lin ptr) throws Unreachable {
        FieldStateBuilder<FiniteDomain> builder = new FieldStateBuilder<FiniteDomain>((FieldState)this.state);
        Finite.Rlin effectiveRhs = (Finite.Rlin)builder.resolveRhs(ptr);
        FiniteDomain newChildState = builder.applyChildOps((FiniteDomain)this.childState);
        P2 newChildren = newChildState.deref(effectiveRhs);
        FieldState newState = builder.build();
        Fields<FiniteDomain> s = this.build(newState, (D)((FiniteDomain)newChildren._2()));
        return new P3<AVLSet<NumVar.AddrVar>, Fields<D>, Finite.Rlin>(newChildren._1(), s, effectiveRhs);
    }

    @Override
    @Deprecated
    public List<P2<AbstractPointer, Fields<D>>> deprecatedDeref(int size, Rhs.Rval ptr, VarSet summaries) throws Unreachable {
        FieldStateBuilder<FiniteDomain> builder = new FieldStateBuilder<FiniteDomain>((FieldState)this.state);
        Finite.Rlin effectiveRhs = builder.resolveRval(ptr);
        FiniteDomain newChildState = builder.applyChildOps((FiniteDomain)this.childState);
        LinkedList<P2<AbstractPointer, Fields<D>>> res = new LinkedList<P2<AbstractPointer, Fields<D>>>();
        List newChildren = newChildState.deprecatedDeref(effectiveRhs, summaries);
        FieldState newState = builder.build();
        for (P2 tuple : newChildren) {
            assert (builder.hasNoTempVars());
            FiniteDomain localCS = builder.applyDelayedKillOps((FiniteDomain)tuple._2());
            AbstractPointer md = AbstractPointer.createMemDeref(effectiveRhs, tuple._1());
            res.add(new P2<AbstractPointer, Fields<FiniteDomain>>(md, this.build(newState, (D)localCS)));
        }
        return res;
    }

    @Override
    public Fields<D> introduceRegion(MemVar region, RegionCtx regionCtx) {
        FieldStateBuilder builder = new FieldStateBuilder((FieldState)this.state);
        builder.introduce(region, regionCtx);
        return this.finish(builder);
    }

    @Override
    public Fields<D> substituteRegion(MemVar from, MemVar to) {
        if (from == to) {
            return this;
        }
        assert (((FieldState)this.state).containsRegion(from));
        assert (!((FieldState)this.state).containsRegion(to));
        FieldStateBuilder builder = new FieldStateBuilder((FieldState)this.state);
        builder.rename(from, to);
        return this.finish(builder);
    }

    @Override
    public Fields<D> assignSymbolicAddressOf(Lhs lhs, NumVar symbolicAddress) {
        FieldStateBuilder builder = new FieldStateBuilder((FieldState)this.state);
        assert (((FieldState)this.state).regions.contains(lhs.getRegionId()));
        Finite.Lhs finiteLhs = builder.resolveLhs(lhs);
        Finite.Rlin finiteRhs = fin.linear(lhs.getSize(), symbolicAddress);
        builder.getChildOps().addAssignment(finiteLhs, finiteRhs);
        return this.finish(builder);
    }

    @Override
    public Fields<D> projectRegion(MemVar region) {
        FieldStateBuilder builder = new FieldStateBuilder((FieldState)this.state);
        builder.projectRegion(region);
        return this.finish(builder);
    }

    private Fields<D> finish(FieldStateBuilder<D> builder) {
        FiniteDomain newChildState = builder.applyReorderedChildOps((FiniteDomain)this.childState);
        return this.build(builder.build(), (D)newChildState);
    }

    @Override
    public Fields<D> assumePointsToAndConcretize(Rhs.Lin pointerValue, NumVar.AddrVar target, MemVar region) {
        FieldStateBuilder<FiniteDomain> builder = new FieldStateBuilder<FiniteDomain>((FieldState)this.state);
        builder.assumePointsTo(pointerValue, target, region);
        FiniteDomain newChildState = builder.applyReorderedChildOps((FiniteDomain)this.childState);
        return this.build(builder.build(), (D)newChildState);
    }

    @Override
    public List<P2<PathString, NumVar.AddrVar>> findPossiblePointerTargets(MemVar id) throws Unreachable {
        return ((FieldState)this.state).findPossiblePointerTargets((FiniteDomain)this.childState, id);
    }

    @Override
    public Fields<D> copyMemRegion(MemVar fromVar, MemVar toVar) {
        FieldStateBuilder<FiniteDomain> builder = new FieldStateBuilder<FiniteDomain>((FieldState)this.state);
        builder.copyMemRegion(fromVar, toVar);
        FiniteDomain newChildState = builder.applyReorderedChildOps((FiniteDomain)this.childState);
        return this.build(builder.build(), (D)newChildState);
    }

    private final Range tryLinearization(OverlappingRanges<VariableCtx> overlapping, FiniteRange key) {
        FieldGraph g = FieldGraph.build(overlapping);
        FieldGraph.Partitioning path = g.findPartitioning(key.low(), key.high());
        Option<FiniteRange> span = path.span();
        if (span.isNone() || !key.isEqualTo(span.get())) {
            return null;
        }
        return this.linearize(path, key.getSpan());
    }

    private final Range linearize(FieldGraph.Partitioning path, BigInt size) {
        Range value = null;
        assert (!path.isEmpty());
        int baseOffset = ((FiniteRange)((P2)path.get(0))._1()).low().asInteger().intValue();
        for (P2 ctx : path) {
            FiniteRange intervalKey = (FiniteRange)ctx._1();
            NumVar variable = ((VariableCtx)ctx._2()).getVariable();
            Range variableRange = this.queryRange(variable);
            int currentOffset = intervalKey.low().asInteger().intValue();
            BigInt coeff = BigInt.powerOfTwo(currentOffset - baseOffset);
            if (value == null) {
                value = variableRange.mul(coeff);
                continue;
            }
            value = value.add(variableRange.mul(coeff));
        }
        return value;
    }

    @Override
    public final Range queryRange(Rhs.Rval value) {
        if (value instanceof Rhs.Rlit) {
            BigInt c = ((Rhs.Rlit)value).getValue();
            return Range.from(c);
        }
        if (value instanceof Rhs.Address) {
            RReilAddr address = ((Rhs.Address)value).getAddress();
            if (address.offset() != 0) {
                throw new IllegalArgumentException("Not possible to translate a RREIL address with offset to a range: " + address);
            }
            return Range.from(address.base());
        }
        Rhs.Rvar var = (Rhs.Rvar)value;
        return this.queryRange(var.getRegionId(), var.bitsRange());
    }

    @Override
    public final Range queryRange(MemVar region, FiniteRange key) {
        OverlappingRanges<VariableCtx> overlapping = ((FieldState)this.state).queryOverlappingFields(region, key);
        if (overlapping.isEmpty()) {
            return null;
        }
        overlapping.sortByFiniteRangeKey();
        return this.tryLinearization(overlapping, key);
    }

    @Override
    public Range queryRange(Rhs.Lin value) {
        FieldStateBuilder builder = new FieldStateBuilder((FieldState)this.state);
        if (value instanceof Rhs.LinRval) {
            return this.queryRange(((Rhs.LinRval)value).getRval());
        }
        Finite.Rhs resolved = builder.resolveRhs(value);
        if (resolved instanceof Finite.Rlin) {
            Finite.Rlin linear = (Finite.Rlin)resolved;
            return ((FiniteDomain)this.childState).queryRange(linear.getLinearTerm());
        }
        return null;
    }

    @Override
    public DebugChannel getDebugChannel() {
        return new DebugChannel(((FiniteDomain)this.childState).getDebugChannel()){

            @Override
            public Finite.Rlin resolve(Rhs.Rvar value) {
                FieldStateBuilder builder = new FieldStateBuilder((FieldState)Fields.this.state);
                return builder.resolve(value);
            }
        };
    }

    @Override
    public Option<NumVar> pickSpecificField(MemVar region, FiniteRange access) {
        OverlappingRanges<VariableCtx> overlapping = ((FieldState)this.state).queryOverlappingFields(region, access);
        for (P2<FiniteRange, VariableCtx> p2 : overlapping) {
            if (!p2._1().isEqualTo(access)) continue;
            return Option.some(p2._2().getVariable());
        }
        return Option.none();
    }

    @Override
    public Fields<D> copyAndPaste(MemVarSet vars, Fields<D> other) {
        FieldStateBuilder<D> builder = new FieldStateBuilder<D>((FieldState)this.state);
        builder.copyAndPaste(vars, other);
        FiniteDomain newChildState = builder.applyReorderedChildOps((FiniteDomain)this.childState);
        return this.build(builder.build(), (D)newChildState);
    }

    @Override
    public MemVarSet getSupportSet() {
        return ((FieldState)this.state).getSupportSet();
    }

    @Override
    public Fields<D> assumeEdgeNG(Rhs.Lin fieldThatPoints, NumVar.AddrVar address) {
        FieldStateBuilder<FiniteDomain> builder = new FieldStateBuilder<FiniteDomain>((FieldState)this.state);
        builder.assumeEdgeNG(fieldThatPoints, address);
        FiniteDomain newChildState = builder.applyReorderedChildOps((FiniteDomain)this.childState);
        return this.build(builder.build(), (D)newChildState);
    }

    @Override
    public Fields<D> expandNG(List<MemVarPair> mvps) {
        FieldStateBuilder builder = new FieldStateBuilder((FieldState)this.state);
        builder.expandNG(mvps);
        return this.finish(builder);
    }

    @Override
    public Fields<D> expandNG(NumVar.AddrVar address, NumVar.AddrVar address2, List<MemVarPair> mvps) {
        FieldStateBuilder builder = new FieldStateBuilder((FieldState)this.state);
        builder.expandNG(address, address2, mvps);
        return this.finish(builder);
    }

    @Override
    public Fields<D> concretizeAndDisconnectNG(NumVar.AddrVar summary, AVLSet<MemVar> concreteNodes) {
        FieldStateBuilder<FiniteDomain> builder = new FieldStateBuilder<FiniteDomain>((FieldState)this.state);
        builder.concretizeAndDisconnectNG(summary, concreteNodes);
        FiniteDomain newChildState = builder.applyReorderedChildOps((FiniteDomain)this.childState);
        return this.build(builder.build(), (D)newChildState);
    }

    @Override
    public Fields<D> bendBackGhostEdgesNG(NumVar.AddrVar summary, NumVar.AddrVar concrete, MemVarSet sContents, MemVarSet cContents, MemVarSet pointingToSummary, MemVarSet pointingToConcrete) {
        FieldStateBuilder<FiniteDomain> builder = new FieldStateBuilder<FiniteDomain>((FieldState)this.state);
        builder.bendBackGhostEdgesNG(concrete, summary, sContents, cContents, pointingToSummary, pointingToConcrete);
        FiniteDomain newChildState = builder.applyReorderedChildOps((FiniteDomain)this.childState);
        return this.build(builder.build(), (D)newChildState);
    }

    @Override
    public Fields<D> foldNG(NumVar.AddrVar address, NumVar.AddrVar address2, List<MemVarPair> mvps) {
        FieldStateBuilder builder = new FieldStateBuilder((FieldState)this.state);
        builder.foldNG(address, address2, mvps);
        return this.finish(builder);
    }

    @Override
    public Fields<D> foldNG(List<MemVarPair> mvps) {
        FieldStateBuilder builder = new FieldStateBuilder((FieldState)this.state);
        builder.foldNG(mvps);
        return this.finish(builder);
    }

    @Override
    public Fields<D> bendGhostEdgesNG(NumVar.AddrVar summary, NumVar.AddrVar concrete, MemVarSet sContents, MemVarSet cContents, MemVarSet pointingToSummary, MemVarSet pointingToConcrete) {
        FieldStateBuilder<FiniteDomain> builder = new FieldStateBuilder<FiniteDomain>((FieldState)this.state);
        builder.bendGhostEdgesNG(concrete, summary, sContents, cContents, pointingToSummary, pointingToConcrete);
        FiniteDomain newChildState = builder.applyReorderedChildOps((FiniteDomain)this.childState);
        return this.build(builder.build(), (D)newChildState);
    }

    @Override
    public Range queryPtsEdge(MemVar from, BigInt offset, int size, NumVar.AddrVar to) {
        MemVar region = from;
        FiniteRange key = FiniteRange.of(offset, (long)size);
        OverlappingRanges<VariableCtx> overlapping = ((FieldState)this.state).queryOverlappingFields(region, key);
        if (overlapping.size() != 1) {
            return Range.top();
        }
        NumVar fromVar = overlapping.getFirst()._2().getVariable();
        Range queryEdgeFlag = ((FiniteDomain)this.childState).queryEdgeFlag(fromVar, to);
        return queryEdgeFlag;
    }

    @Override
    public Fields<D> assumeRegionsAreEqual(MemVar first, MemVar second) {
        Region r1 = ((FieldState)this.state).regions.get(first);
        Region r2 = ((FieldState)this.state).regions.get(second);
        ThreeWaySplit<FiniteRangeTree<VariableCtx>> split = r1.fields.split(r2.fields);
        assert (split.onlyInFirst().isEmpty());
        assert (split.onlyInSecond().isEmpty());
        FiniteDomain cs = (FiniteDomain)this.childState;
        for (P2<FiniteRange, VariableCtx> p2 : split.inBothButDiffering()) {
            NumVar fst = ((VariableCtx)p2.snd).getVariable();
            NumVar snd = r2.fields.get(p2._1()).get().getVariable();
            int size = p2._1().getSpan().intValue();
            cs = cs.assumeVarsAreEqual(size, fst, snd);
        }
        return this.build((FieldState)this.state, (D)cs);
    }

    @Override
    public void memVarToCompactString(StringBuilder builder, MemVar var) {
        ((FieldState)this.state).regions.get(var).appendInfo(builder, (PrettyDomain)((Object)this.childState));
    }
}

