/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.fields;

import bindead.data.MemVarSet;
import bindead.data.NumVar;
import bindead.debug.PrettyDomain;
import bindead.domainnetwork.interfaces.ContentCtx;
import bindead.domainnetwork.interfaces.FiniteDomain;
import bindead.domainnetwork.interfaces.FunctorState;
import bindead.domains.fields.ClobberedMap;
import bindead.domains.fields.Region;
import bindead.domains.fields.RegionMap;
import bindead.domains.fields.VariableCtx;
import bindead.domains.segments.heap.PathString;
import binparse.Permission;
import com.jamesmurty.utils.XMLBuilder;
import java.util.LinkedList;
import java.util.List;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.numeric.FiniteRange;
import javalx.persistentcollections.AVLMap;
import javalx.persistentcollections.tree.OverlappingRanges;
import rreil.lang.MemVar;

class FieldState
extends FunctorState {
    protected static final FieldState EMPTY = new FieldState();
    protected final RegionMap regions;
    protected final AVLMap<MemVar, ClobberedMap> clobbered;

    private FieldState() {
        this(RegionMap.empty(), AVLMap.empty());
    }

    protected FieldState(RegionMap regions, AVLMap<MemVar, ClobberedMap> clobbered) {
        this.regions = regions;
        this.clobbered = clobbered;
    }

    public String toString() {
        return "#" + this.regions.size() + " " + this.regions.toString();
    }

    @Override
    public XMLBuilder toXML(XMLBuilder xml) {
        xml = xml.e("FIELD");
        for (P2<MemVar, Region> p2 : this.regions.map) {
            Region region = p2._2();
            if (region.fields.isEmpty()) {
                xml = xml.e("Entry").a("type", "Field").e("MemoryVariable").t(p2._1().toString()).up().up();
                continue;
            }
            Option<ClobberedMap> map = this.clobbered.get(p2._1());
            for (P2<FiniteRange, VariableCtx> p22 : region.fields) {
                boolean isClobbered = false;
                if (map.isSome()) {
                    isClobbered = map.get().isClobbered(p22._1());
                }
                xml = xml.e("Entry").a("type", "Field").e("MemoryVariable").t(p2._1().toString()).up();
                xml = xml.e("Variable").t(((VariableCtx)p22.snd).getVariable().toString()).up().e("offset").e("lowerBound").t(p22._1().low().toString()).up().e("upperBound").t(p22._1().high().toString()).up().up();
                xml = xml.e("Clobbered").t(Boolean.toString(isClobbered)).up();
                xml = xml.up();
            }
        }
        xml = xml.up();
        xml = xml.up();
        return xml;
    }

    public boolean canWriteTo(MemVar varId) {
        Option<ContentCtx> maybeSegment = this.regions.getSegment(varId);
        if (maybeSegment.isSome()) {
            ContentCtx segmentCtx = maybeSegment.get();
            return Permission.isWritable(segmentCtx.getPermissions());
        }
        return true;
    }

    <D extends FiniteDomain<D>> List<P2<PathString, NumVar.AddrVar>> findPossiblePointerTargets(D childState, MemVar sourceId) {
        LinkedList<P2<PathString, NumVar.AddrVar>> l = new LinkedList<P2<PathString, NumVar.AddrVar>>();
        Region r = this.regions.getOrNull(sourceId);
        if (r == null) {
            return l;
        }
        for (P2<FiniteRange, VariableCtx> p2 : r.fields) {
            PathString ps = new PathString(p2._1().low());
            NumVar variable = p2._2().getVariable();
            for (NumVar.AddrVar targetaddr : childState.findPossiblePointerTargets(variable)) {
                l.add(new P2<PathString, NumVar.AddrVar>(ps, targetaddr));
            }
        }
        return l;
    }

    public OverlappingRanges<VariableCtx> queryOverlappingFields(MemVar region, FiniteRange field) {
        return this.regions.searchOverlaps(region, field.toInterval());
    }

    public boolean containsRegion(MemVar mv) {
        return this.regions.contains(mv);
    }

    public MemVarSet getSupportSet() {
        return this.regions.keys();
    }

    @Override
    public void toCompactString(String domainName, StringBuilder builder, PrettyDomain childDomain) {
    }
}

