/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.decisiontree;

import bindead.abstractsyntax.zeno.Zeno;
import bindead.data.FoldMap;
import bindead.data.Linear;
import bindead.data.NumVar;
import bindead.data.VarSet;
import bindead.debug.DomainPrintHelpers;
import bindead.debug.DomainStringBuilder;
import bindead.debug.XmlPrintHelpers;
import bindead.domainnetwork.channels.DebugChannel;
import bindead.domainnetwork.channels.Domain;
import bindead.domainnetwork.channels.SynthChannel;
import bindead.domainnetwork.interfaces.AnalysisCtx;
import bindead.domainnetwork.interfaces.SemiLattice;
import bindead.domainnetwork.interfaces.Summarization;
import bindead.domainnetwork.interfaces.ZenoDomain;
import bindead.domains.affine.Substitution;
import bindead.exceptions.Unreachable;
import com.jamesmurty.utils.XMLBuilder;
import java.util.Iterator;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.exceptions.UnimplementedException;
import javalx.fn.Fn;
import javalx.fn.Fn2;
import javalx.numeric.BigInt;
import javalx.numeric.Bound;
import javalx.numeric.Range;
import javalx.persistentcollections.AVLMap;
import javalx.persistentcollections.AVLSet;
import javalx.persistentcollections.FiniteMap;
import javalx.persistentcollections.ThreeWaySplit;
import rreil.lang.util.Type;

public abstract class DecisionTree<D extends ZenoDomain<D>>
extends Domain<DecisionTree<D>>
implements ZenoDomain<DecisionTree<D>> {
    protected final Option<D> state;
    protected final AVLMap<Zeno.Test, DecisionTree<D>> children;
    private final AnalysisCtx analysisContext;

    protected DecisionTree(String name, Option<D> state, AVLMap<Zeno.Test, DecisionTree<D>> children, final AnalysisCtx ctx) {
        super(name);
        this.state = state.fmap(new Fn<D, D>(){

            @Override
            public D apply(D s) {
                return (ZenoDomain)s.setContext(ctx);
            }
        });
        this.children = children.mapOnValues(new Fn<DecisionTree<D>, DecisionTree<D>>(){

            @Override
            public DecisionTree<D> apply(DecisionTree<D> a) {
                return a.setContext(ctx);
            }
        });
        this.analysisContext = ctx;
    }

    protected abstract DecisionTree<D> build(Option<D> var1, AVLMap<Zeno.Test, DecisionTree<D>> var2);

    private DecisionTree<D> build(Option<D> child) {
        return this.build(child, DecisionTree.noChild());
    }

    @Override
    public AnalysisCtx getContext() {
        return this.analysisContext;
    }

    @Override
    public DecisionTree<D> setContext(AnalysisCtx ctx) {
        throw new UnimplementedException("Needs to be implemented in subclassers, passing the context through the constructor.");
    }

    protected static <D extends ZenoDomain<D>> AVLMap<Zeno.Test, DecisionTree<D>> noChild() {
        return AVLMap.empty();
    }

    private static <D extends ZenoDomain<D>> Option<D> join(Option<D> arg1, Option<D> arg2) {
        if (arg1.isNone()) {
            return arg2;
        }
        if (arg2.isNone()) {
            return arg1;
        }
        return Option.some(((ZenoDomain)arg1.get()).join((SemiLattice)arg2.get()));
    }

    protected static <D extends ZenoDomain<D>> Option<D> applyTest(Zeno.Test t, Option<D> state) {
        if (t == null) {
            return state;
        }
        if (state.isNone()) {
            return state;
        }
        try {
            return Option.some(((ZenoDomain)state.get()).eval(t));
        }
        catch (Unreachable _) {
            return Option.none();
        }
    }

    private P2<DecisionTree<D>, DecisionTree<D>> makeCompatible(DecisionTree<D> other) {
        P2<DecisionTree<D>, DecisionTree<D>> recurse;
        Option<D> testState;
        Zeno.Test t;
        Option<D> thisState = this.state;
        Option<D> thatState = other.state;
        ThreeWaySplit<AVLMap<Zeno.Test, DecisionTree<D>>> split = this.children.split(other.children);
        FiniteMap thisChildren = split.inBothButDiffering();
        FiniteMap thatChildren = other.children.intersection(split.inBothButDiffering());
        for (P2<Zeno.Test, DecisionTree<D>> p2 : split.onlyInFirst()) {
            t = p2._1();
            thatState = DecisionTree.applyTest(t.not(), thatState);
            testState = DecisionTree.applyTest(t, thatState);
            recurse = super.makeCompatible(this.build(testState));
            thisChildren = ((AVLMap)thisChildren).bind(t, recurse._1());
            thatChildren = ((AVLMap)thatChildren).bind(t, recurse._2());
        }
        for (P2<Zeno.Test, DecisionTree<D>> p2 : split.onlyInSecond()) {
            t = p2._1();
            thisState = DecisionTree.applyTest(t.not(), thisState);
            testState = DecisionTree.applyTest(t, thisState);
            recurse = super.makeCompatible(p2._2());
            thisChildren = ((AVLMap)thisChildren).bind(t, recurse._1());
            thatChildren = ((AVLMap)thatChildren).bind(t, recurse._2());
        }
        for (P2<Zeno.Test, DecisionTree<D>> p2 : split.inBothButDiffering()) {
            t = p2._1();
            P2<DecisionTree<D>, DecisionTree<D>> recurse2 = super.makeCompatible(other.children.get(t).get());
            thisChildren = ((AVLMap)thisChildren).bind(t, recurse2._1());
            thatChildren = ((AVLMap)thatChildren).bind(t, recurse2._2());
        }
        return P2.tuple2(this.build(thisState, (AVLMap<Zeno.Test, DecisionTree<D>>)thisChildren), this.build(thatState, (AVLMap<Zeno.Test, DecisionTree<D>>)thatChildren));
    }

    @Override
    public DecisionTree<D> join(DecisionTree<D> other) {
        P2<DecisionTree<D>, DecisionTree<D>> compat = this.makeCompatible(other);
        return this.accept(new BinaryVisitor<D>(){

            @Override
            public Option<D> visit(Option<D> arg1, Option<D> arg2) {
                return DecisionTree.join(arg1, arg2);
            }
        }, compat._1(), compat._2());
    }

    @Override
    public DecisionTree<D> widen(DecisionTree<D> other) {
        P2<DecisionTree<D>, DecisionTree<D>> compat = this.makeCompatible(other);
        return super.propagate();
    }

    @Override
    public boolean subsetOrEqual(DecisionTree<D> other) {
        P2<DecisionTree<D>, DecisionTree<D>> compat = this.makeCompatible(other);
        return super.subsetOrEqualImpl(compat._2());
    }

    private boolean subsetOrEqualImpl(DecisionTree<D> other) {
        if (this.state.isSome()) {
            if (other.state.isSome()) {
                if (!((ZenoDomain)this.state.get()).subsetOrEqual((SemiLattice)other.state.get())) {
                    return false;
                }
            } else {
                return false;
            }
        }
        ThreeWaySplit<AVLMap<Zeno.Test, DecisionTree<D>>> diff = this.children.split(other.children);
        for (P2<Zeno.Test, DecisionTree<D>> p2 : diff.onlyInFirst()) {
            if (!p2._2().state.isSome()) continue;
            return false;
        }
        for (P2<Zeno.Test, DecisionTree<D>> p2 : diff.inBothButDiffering()) {
            DecisionTree<D> thatChild;
            DecisionTree<D> thisChild = p2._2();
            if (thisChild.subsetOrEqual(thatChild = other.children.get(p2._1()).get())) continue;
            return false;
        }
        return true;
    }

    @Override
    public DecisionTree<D> expand(final FoldMap pairs) {
        return this.accept(new UnaryVisitor<D>(){

            @Override
            public Option<D> visit(D arg) {
                return Option.some(arg.expand(pairs));
            }
        });
    }

    @Override
    public DecisionTree<D> fold(final FoldMap pairs) {
        return this.accept(new UnaryVisitor<D>(){

            @Override
            public Option<D> visit(D arg) {
                return Option.some(arg.expand(pairs));
            }
        });
    }

    @Override
    public DecisionTree<D> copyAndPaste(VarSet vars, DecisionTree<D> from) {
        assert (false);
        final VarSet vars_ = vars;
        P2<DecisionTree<D>, DecisionTree<D>> compat = this.makeCompatible(from);
        return this.accept(new BinaryVisitor<D>(){

            @Override
            public Option<D> visit(Option<D> arg1, Option<D> arg2) {
                if (arg1.isNone()) {
                    return arg2;
                }
                if (arg2.isNone()) {
                    return arg1;
                }
                return Option.some(((ZenoDomain)arg1.get()).copyAndPaste(vars_, (Summarization)arg2.get()));
            }
        }, compat._1(), compat._2());
    }

    @Override
    public XMLBuilder toXML(XMLBuilder builder) {
        XMLBuilder xml = builder;
        XmlPrintHelpers.openDomain(builder, this.name, XmlPrintHelpers.DomainType.Zeno, XmlPrintHelpers.DomainKind.Functor);
        builder = this.xmlPrint(builder);
        XmlPrintHelpers.closeDomain(builder);
        return xml;
    }

    private XMLBuilder xmlPrint(XMLBuilder xml) {
        if (this.state.isSome()) {
            xml = ((ZenoDomain)this.state.get()).toXML(xml);
        }
        for (P2<Zeno.Test, DecisionTree<D>> p2 : this.children) {
            xml = xml.e("guarded").a("guard", p2._1().toString());
            xml = super.xmlPrint(xml);
            xml = xml.up();
        }
        return xml;
    }

    @Override
    public void toString(DomainStringBuilder builder) {
        builder.append(this.name, DomainPrintHelpers.printState(this.name, this.genString()));
    }

    public String toString() {
        return DomainPrintHelpers.printState(this.name, this.genString());
    }

    private String genString() {
        int amountOfPotentialChildren = this.children.size() + 1;
        int amountOfExistingChildren = this.state.isSome() ? 1 : 0;
        for (DecisionTree<D> child : this.children.values()) {
            amountOfExistingChildren += child.state.isSome() ? 1 : 0;
        }
        String res = "#" + amountOfExistingChildren + "/" + amountOfPotentialChildren;
        if (amountOfPotentialChildren == 1 && amountOfExistingChildren == 0) {
            res = "";
        }
        if (this.state.isSome()) {
            res = res + "\n" + ((ZenoDomain)this.state.get()).toString();
        }
        for (P2<Zeno.Test, DecisionTree<D>> p2 : this.children) {
            res = res + "\nwhen " + p2._1().toString() + ": ";
            res = res + super.genString();
        }
        return res.replaceAll("\n", "\n  ");
    }

    @Override
    public SynthChannel getSynthChannel() {
        SynthChannel res = this.state.isSome() ? ((ZenoDomain)this.state.get()).getSynthChannel() : new SynthChannel();
        for (P2<Zeno.Test, DecisionTree<D>> p2 : this.children) {
            DecisionTree<D> childTree = p2._2();
            if (childTree.state.isNone()) continue;
            res = res.intersect(childTree.getSynthChannel());
        }
        return res;
    }

    @Override
    public Range queryRange(Linear lin) {
        Range res = this.queryRange(null, lin);
        if (res == null) {
            throw new Unreachable();
        }
        return res;
    }

    private Range queryRange(Range res, Linear lin) {
        if (res == null) {
            if (this.state.isSome()) {
                res = ((ZenoDomain)this.state.get()).queryRange(lin);
            }
        } else if (this.state.isSome()) {
            res = res.union(((ZenoDomain)this.state.get()).queryRange(lin));
        }
        for (P2<Zeno.Test, DecisionTree<D>> p2 : this.children) {
            res = super.queryRange(res, lin);
        }
        return res;
    }

    @Override
    public DecisionTree<D> eval(final Zeno.Assign stmt) {
        return super.propagate();
    }

    @Override
    public DecisionTree<D> eval(Zeno.Test test) throws Unreachable {
        final Zeno.Test test_ = test;
        DecisionTree<D> result = this.accept(new UnaryVisitor<D>(){

            @Override
            public Option<D> visit(D arg) {
                try {
                    return Option.some(arg.eval(test_));
                }
                catch (Unreachable _) {
                    return Option.none();
                }
            }
        });
        if (!result.isReachable()) {
            throw new Unreachable();
        }
        return result;
    }

    public boolean isReachable() {
        if (this.state.isSome()) {
            return true;
        }
        for (P2<Zeno.Test, DecisionTree<D>> p2 : this.children) {
            if (!p2._2().isReachable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public DecisionTree<D> introduce(NumVar variable, Type type, Option<BigInt> value) {
        final NumVar variable_ = variable;
        final Type type_ = type;
        final Option<BigInt> value_ = value;
        return this.accept(new UnaryVisitor<D>(){

            @Override
            public Option<D> visit(D arg) {
                return Option.some(arg.introduce(variable_, type_, value_));
            }
        });
    }

    @Override
    public DecisionTree<D> project(VarSet vars) {
        final VarSet variable_ = vars;
        return this.accept(new UnaryVisitor<D>(){

            @Override
            public P2<Zeno.Test, Option<D>> visitChangeTest(Zeno.Test t, Option<D> arg) {
                if (t != null && t.getVars().containsAny(variable_)) {
                    t = null;
                }
                return P2.tuple2(t, arg.isSome() ? this.visit((ZenoDomain)arg.get()) : arg);
            }

            @Override
            public Option<D> visit(D arg) {
                return Option.some(arg.project(variable_));
            }
        });
    }

    @Override
    public DecisionTree<D> substitute(final NumVar x, final NumVar y) {
        final Substitution subst = new Substitution(x, Linear.linear(y), Bound.ONE);
        return this.accept(new UnaryVisitor<D>(){

            @Override
            public P2<Zeno.Test, Option<D>> visitChangeTest(Zeno.Test t, Option<D> arg) {
                if (t != null) {
                    t = t.applySubstitution(subst);
                }
                return P2.tuple2(t, arg.isSome() ? this.visit((ZenoDomain)arg.get()) : arg);
            }

            @Override
            public Option<D> visit(D arg) {
                return Option.some(arg.substitute(x, y));
            }
        });
    }

    private DecisionTree<D> accept(BinaryVisitor<D> v, DecisionTree<D> this_, DecisionTree<D> other) {
        P2 merged = ((BinaryVisitor)v).visitCreateChildren(this_.state, other.state);
        Option<D> newState = (Option<D>)merged._2();
        FiniteMap newChildren = DecisionTree.noChild();
        Iterator<P2<Zeno.Test, DecisionTree<D>>> thisIter = this_.children.iterator();
        Iterator<P2<Zeno.Test, DecisionTree<D>>> thatIter = other.children.iterator();
        while (thisIter.hasNext()) {
            P2<Zeno.Test, DecisionTree<D>> pair = thisIter.next();
            DecisionTree<D> thisChild = pair._2();
            assert (thatIter.hasNext());
            DecisionTree<D> thatChild = thatIter.next()._2();
            newChildren = ((AVLMap)newChildren).bind(pair._1(), this.accept(v, thisChild, thatChild));
        }
        for (Zeno.Test t : (AVLSet)merged._1()) {
            if (((AVLMap)newChildren).contains((Zeno.Test)t)) continue;
            Zeno.Test predicate = t.not();
            Option<D> childState = DecisionTree.applyTest(predicate, newState);
            newState = DecisionTree.applyTest(t, newState);
            newChildren = ((AVLMap)newChildren).bind(predicate, super.build(childState));
        }
        return this_.build(newState, (AVLMap<Zeno.Test, DecisionTree<D>>)newChildren);
    }

    protected DecisionTree<D> accept(UnaryVisitor<D> v) {
        Fn2 merger = new Fn2<DecisionTree<D>, DecisionTree<D>, DecisionTree<D>>(){

            @Override
            public DecisionTree<D> apply(DecisionTree<D> a, DecisionTree<D> b) {
                return DecisionTree.this.build(DecisionTree.join(a.state, b.state), a.children.union(this, b.children));
            }
        };
        P2<Zeno.Test, Option<ZenoDomain>> resVisitState = v.visitChangeTest(null, this.state);
        AVLSet<Zeno.Test> newTests = this.state.isSome() ? v.newTests((ZenoDomain)this.state.get()) : AVLSet.empty();
        FiniteMap curChildren = this.children;
        for (Zeno.Test t : newTests) {
            if (curChildren.contains(t)) continue;
            curChildren = curChildren.bind(t, this.build(Option.none()));
        }
        P2<Option<ZenoDomain>, AVLMap<Zeno.Test, DecisionTree<ZenoDomain>>> recurseRes = this.accept(v, merger, (AVLMap<Zeno.Test, DecisionTree<D>>)curChildren);
        Option<ZenoDomain> newState = DecisionTree.join(resVisitState._2(), recurseRes._1());
        return this.build(newState, recurseRes._2());
    }

    private P2<Option<D>, AVLMap<Zeno.Test, DecisionTree<D>>> accept(UnaryVisitor<D> v, Fn2<DecisionTree<D>, DecisionTree<D>, DecisionTree<D>> merger, AVLMap<Zeno.Test, DecisionTree<D>> children) {
        Option<Object> extraParentState = Option.none();
        FiniteMap newTree = DecisionTree.noChild();
        for (P2<Zeno.Test, DecisionTree<D>> p2 : children) {
            P2<Zeno.Test, Option<ZenoDomain>> resVisitState = v.visitChangeTest(p2._1(), p2._2().state);
            Option<ZenoDomain> newState = resVisitState._2();
            AVLSet<Zeno.Test> newTests = p2._2().state.isSome() ? v.newTests((ZenoDomain)p2._2().state.get()) : AVLSet.empty();
            FiniteMap curChildren = p2._2().children;
            for (Zeno.Test t : newTests) {
                if (curChildren.contains(t)) continue;
                curChildren = curChildren.bind(t, super.build(Option.none()));
            }
            P2<Option<ZenoDomain>, AVLMap<Zeno.Test, DecisionTree<ZenoDomain>>> resVisitChildren = this.accept(v, merger, (AVLMap<Zeno.Test, DecisionTree<D>>)curChildren);
            AVLMap<Zeno.Test, DecisionTree<D>> newChildren = resVisitChildren._2();
            if (resVisitState._1() == null) {
                extraParentState = DecisionTree.join(extraParentState, newState);
                newTree = newTree.union(merger, newChildren);
                continue;
            }
            DecisionTree<ZenoDomain> elem = p2._2().build(newState, newChildren);
            Option<DecisionTree<D>> prevElem = newTree.get(resVisitState._1());
            if (prevElem.isNone()) {
                newTree = newTree.bind(resVisitState._1(), elem);
                continue;
            }
            newTree = newTree.bind(resVisitState._1(), merger.apply(prevElem.get(), elem));
        }
        return P2.tuple2(extraParentState, newTree);
    }

    private DecisionTree<D> restrict() {
        Option<Object> newState = this.stripLocation(this.state);
        FiniteMap newTree = DecisionTree.noChild();
        for (P2<Zeno.Test, DecisionTree<D>> p2 : this.children) {
            if (newState.isSome() && p2._2().state.isSome()) {
                try {
                    newState = Option.some(((ZenoDomain)newState.get()).eval(p2._1().not()));
                }
                catch (Unreachable _) {
                    newState = Option.none();
                }
            }
            newTree = newTree.bind(p2._1(), super.restrict());
        }
        return this.build((Option<D>)newState, (AVLMap<Zeno.Test, DecisionTree<D>>)newTree);
    }

    private DecisionTree<D> propagate() {
        Option<D> newState = this.stripLocation(this.state);
        P2<Option<D>, AVLMap<Zeno.Test, DecisionTree<D>>> recurseRes = this.propagate(null, newState, this.children);
        if (newState.isSome()) {
            for (P2<Zeno.Test, DecisionTree<D>> p2 : recurseRes._2()) {
                newState = DecisionTree.applyTest(p2._1().not(), newState);
            }
        }
        newState = DecisionTree.join(newState, recurseRes._1());
        return this.build(newState, recurseRes._2());
    }

    private P2<Option<D>, AVLMap<Zeno.Test, DecisionTree<D>>> propagate(Zeno.Test guard, Option<D> spillToChildren, AVLMap<Zeno.Test, DecisionTree<D>> tree) {
        Zeno.Test guardNot = guard == null ? null : guard.not();
        FiniteMap newTree = DecisionTree.noChild();
        Option spillFromChild = Option.none();
        for (P2<Zeno.Test, DecisionTree<D>> p2 : tree) {
            Option<D> spillToChild;
            Zeno.Test childTest = p2._1();
            Option<D> newChildState = spillToChild = DecisionTree.applyTest(childTest, spillToChildren);
            DecisionTree<D> childTree = p2._2();
            for (P2<Zeno.Test, DecisionTree<D>> p22 : childTree.children) {
                newChildState = DecisionTree.applyTest(p22._1().not(), newChildState);
            }
            P2<Option<D>, AVLMap<Zeno.Test, DecisionTree<D>>> recurseRes = this.propagate(childTest, spillToChild, childTree.children);
            newChildState = DecisionTree.join(newChildState, DecisionTree.applyTest(guard, recurseRes._1()));
            spillFromChild = DecisionTree.join(spillFromChild, DecisionTree.applyTest(guardNot, recurseRes._1()));
            Option<D> option = this.stripLocation(childTree.state);
            newChildState = DecisionTree.join(newChildState, DecisionTree.applyTest(childTest, option));
            spillFromChild = DecisionTree.join(spillFromChild, DecisionTree.applyTest(childTest.not(), option));
            DecisionTree<D> newChild = childTree.build(newChildState, recurseRes._2());
            newTree = newTree.bind(childTest, newChild);
        }
        return P2.tuple2(spillFromChild, newTree);
    }

    private Option<D> stripLocation(Option<D> state) {
        return state.fmap(new Fn<D, D>(){

            @Override
            public D apply(D a) {
                return (ZenoDomain)a.setContext(a.getContext().withoutLocation());
            }
        });
    }

    @Override
    public DecisionTree<D> assumeConcrete(NumVar var) {
        throw new UnimplementedException("should never be called");
    }

    @Override
    public DebugChannel getDebugChannel() {
        return new DebugChannel();
    }

    private static abstract class BinaryVisitor<D extends ZenoDomain<D>> {
        private BinaryVisitor() {
        }

        private P2<AVLSet<Zeno.Test>, Option<D>> visitCreateChildren(Option<D> arg1, Option<D> arg2) {
            return P2.tuple2(AVLSet.empty(), this.visit(arg1, arg2));
        }

        public abstract Option<D> visit(Option<D> var1, Option<D> var2);
    }

    protected static abstract class UnaryVisitor<D extends ZenoDomain<D>> {
        protected UnaryVisitor() {
        }

        public P2<Zeno.Test, Option<D>> visitChangeTest(Zeno.Test test, Option<D> state) {
            return P2.tuple2(test, state.isSome() ? this.visit((ZenoDomain)state.get()) : state);
        }

        public abstract Option<D> visit(D var1);

        public AVLSet<Zeno.Test> newTests(D state) {
            return AVLSet.empty();
        }
    }
}

